/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import java.util.HashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Statistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/admin/cache-manager.html"})
public class CacheManagerController {
    private CacheManager cacheManager;

    @Autowired
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getCacheStatistics(ModelMap model) {
        String[] cacheNames = this.cacheManager.getCacheNames();
        model.addAttribute("cacheNames", (Object)cacheNames);
        HashMap<String, Statistics> statisticsMap = new HashMap<String, Statistics>();
        for (String cacheName : cacheNames) {
            Cache cache = this.cacheManager.getCache(cacheName);
            Statistics stats = cache.getStatistics();
            statisticsMap.put(cacheName, stats);
        }
        model.addAttribute("statisticsMap", statisticsMap);
        return "admin/cache-statistics";
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=clear"})
    public String clearCache(ModelMap model, @RequestParam String cacheName) {
        model.addAttribute("cacheName", (Object)cacheName);
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache != null) {
            cache.removeAll();
            cache.clearStatistics();
            model.addAttribute("clearCacheSuccess", (Object)cacheName);
        }
        return "admin/cache-clear-results";
    }
}

