/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.admin;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.RelationshipDao;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/admin/relationships-for-visitor.html"})
public class RelationshipsForVisitorController {
    private ICalendarAccountDao calendarAccountDao;
    private VisitorDao visitorDao;
    private RelationshipDao relationshipDao;

    @Autowired
    public void setCalendarAccountDao(@Qualifier(value="people") ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    @Autowired
    public void setRelationshipDao(@Qualifier(value="composite") RelationshipDao relationshipDao) {
        this.relationshipDao = relationshipDao;
    }

    public ICalendarAccountDao getCalendarAccountDao() {
        return this.calendarAccountDao;
    }

    public VisitorDao getVisitorDao() {
        return this.visitorDao;
    }

    public RelationshipDao getRelationshipDao() {
        return this.relationshipDao;
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String showRelationships(@RequestParam(value="id", required=false, defaultValue="") String ctcalxitemid, ModelMap model) throws NotAVisitorException {
        ICalendarAccount account;
        model.addAttribute("id", (Object)ctcalxitemid);
        if (StringUtils.isNotBlank((String)ctcalxitemid) && null != (account = this.calendarAccountDao.getCalendarAccountFromUniqueId(ctcalxitemid))) {
            IScheduleVisitor visitor = this.visitorDao.toVisitor(account);
            model.addAttribute("visitor", (Object)visitor);
            List relationships = this.relationshipDao.forVisitor(visitor);
            model.addAttribute("relationships", (Object)relationships);
        }
        return "admin/relationships-for-visitor";
    }
}

