/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.owner.statistics;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang.time.DateUtils;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.impl.owner.NotRegisteredException;
import org.jasig.schedassist.impl.statistics.StatisticsDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.web.owner.statistics.VisitorHistoryFormBackingObject;
import org.jasig.schedassist.web.owner.statistics.VisitorHistoryFormBackingObjectValidator;
import org.jasig.schedassist.web.security.CalendarAccountUserDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"/owner/visitor-history.html", "/delegate/visitor-history.html"})
@SessionAttributes(value={"command"})
public class VisitorHistoryFormController {
    private StatisticsDao statisticsDao;
    private ICalendarAccountDao calendarAccountDao;

    @Autowired
    public void setStatisticsDao(StatisticsDao statisticsDao) {
        this.statisticsDao = statisticsDao;
    }

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    public StatisticsDao getStatisticsDao() {
        return this.statisticsDao;
    }

    public ICalendarAccountDao getCalendarAccountDao() {
        return this.calendarAccountDao;
    }

    @InitBinder(value={"command"})
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new VisitorHistoryFormBackingObjectValidator());
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, false));
    }

    @RequestMapping(method={RequestMethod.GET})
    protected String setupForm(@RequestParam(value="noscript", required=false, defaultValue="false") boolean noscript, ModelMap model) {
        VisitorHistoryFormBackingObject fbo = new VisitorHistoryFormBackingObject();
        Date today = new Date();
        Date sevenDaysAgo = DateUtils.addDays((Date)today, (int)-7);
        sevenDaysAgo = DateUtils.truncate((Date)sevenDaysAgo, (int)5);
        fbo.setStartTime(sevenDaysAgo);
        fbo.setEndTime(today);
        model.addAttribute("command", (Object)fbo);
        if (noscript) {
            return "statistics/visitor-history-form-noscript";
        }
        return "statistics/visitor-history-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    protected String submit(@Valid @ModelAttribute(value="command") VisitorHistoryFormBackingObject fbo, BindingResult bindingResult, ModelMap model) throws NotRegisteredException {
        if (bindingResult.hasErrors()) {
            return "statistics/visitor-history-form";
        }
        CalendarAccountUserDetails currentUser = (CalendarAccountUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        IScheduleOwner owner = currentUser.getScheduleOwner();
        ICalendarAccount visitorAccount = this.calendarAccountDao.getCalendarAccount(fbo.getVisitorUsername());
        model.addAttribute("visitorAccount", (Object)visitorAccount);
        if (null != visitorAccount) {
            List events = this.statisticsDao.getEvents(owner, fbo.getVisitorUsername(), fbo.getAdjustedStartTime(), fbo.getAdjustedEndTime());
            Collections.sort(events);
            model.addAttribute("events", (Object)events);
        }
        return "statistics/visitor-history-success";
    }
}

