/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.web.register;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import org.jasig.schedassist.IAffiliationSource;
import org.jasig.schedassist.impl.AvailableScheduleReflectionService;
import org.jasig.schedassist.impl.owner.AvailableScheduleDao;
import org.jasig.schedassist.impl.owner.IneligibleException;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.model.AffiliationImpl;
import org.jasig.schedassist.model.AvailableBlockBuilder;
import org.jasig.schedassist.model.IAffiliation;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.InputFormatException;
import org.jasig.schedassist.model.Preferences;
import org.jasig.schedassist.web.owner.preferences.PreferencesFormBackingObjectValidator;
import org.jasig.schedassist.web.register.Registration;
import org.jasig.schedassist.web.security.CalendarAccountUserDetailsImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class RegistrationFlowHelper {
    private OwnerDao ownerDao;
    private AvailableScheduleDao availableScheduleDao;
    private AvailableScheduleReflectionService reflectionService;
    private IAffiliationSource affiliationSource;
    private PreferencesFormBackingObjectValidator preferencesValidator;

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired
    public void setAvailableScheduleDao(AvailableScheduleDao availableScheduleDao) {
        this.availableScheduleDao = availableScheduleDao;
    }

    @Autowired
    public void setReflectionService(AvailableScheduleReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    @Autowired
    public void setAffiliationSource(IAffiliationSource affiliationSource) {
        this.affiliationSource = affiliationSource;
    }

    @Autowired
    public void setPreferencesValidator(PreferencesFormBackingObjectValidator preferencesValidator) {
        this.preferencesValidator = preferencesValidator;
    }

    public Registration newRegistrationInstance() {
        return new Registration(this.preferencesValidator);
    }

    public void executeRegistration(Registration registration) throws IneligibleException, InputFormatException, ParseException {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)authentication.getPrincipal();
        IScheduleOwner owner = this.ownerDao.register(currentUser.getCalendarAccount());
        owner = this.ownerDao.updatePreference(owner, Preferences.DURATIONS, registration.durationPreferenceValue());
        owner = this.ownerDao.updatePreference(owner, Preferences.LOCATION, registration.getLocation());
        owner = this.ownerDao.updatePreference(owner, Preferences.MEETING_PREFIX, registration.getTitlePrefix());
        owner = this.ownerDao.updatePreference(owner, Preferences.NOTEBOARD, registration.getNoteboard());
        owner = this.ownerDao.updatePreference(owner, Preferences.VISIBLE_WINDOW, registration.visibleWindowPreferenceKey());
        owner = this.ownerDao.updatePreference(owner, Preferences.DEFAULT_VISITOR_LIMIT, Integer.toString(registration.getDefaultVisitorsPerAppointment()));
        owner = this.ownerDao.updatePreference(owner, Preferences.MEETING_LIMIT, Integer.toString(registration.getMeetingLimitValue()));
        owner = this.ownerDao.updatePreference(owner, Preferences.REFLECT_SCHEDULE, Boolean.toString(registration.isReflectSchedule()));
        if (this.affiliationSource.doesAccountHaveAffiliation((owner = this.ownerDao.updatePreference(owner, Preferences.REMINDERS, registration.emailReminderPreferenceKey())).getCalendarAccount(), (IAffiliation)AffiliationImpl.ADVISOR)) {
            owner = this.ownerDao.updatePreference(owner, Preferences.ADVISOR_SHARE_WITH_STUDENTS, "true");
        }
        if (this.affiliationSource.doesAccountHaveAffiliation(owner.getCalendarAccount(), (IAffiliation)AffiliationImpl.INSTRUCTOR)) {
            owner = this.ownerDao.updatePreference(owner, Preferences.INSTRUCTOR_SHARE_WITH_STUDENTS, "true");
        }
        if (registration.isScheduleSet()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            SortedSet blocks = AvailableBlockBuilder.createBlocks((String)registration.getStartTimePhrase(), (String)registration.getEndTimePhrase(), (String)registration.getDaysOfWeekPhrase(), (Date)dateFormat.parse(registration.getStartDatePhrase()), (Date)dateFormat.parse(registration.getEndDatePhrase()), (int)registration.getDefaultVisitorsPerAppointment());
            this.availableScheduleDao.addToSchedule(owner, (Set)blocks);
        }
        if (registration.isReflectSchedule()) {
            this.reflectionService.reflectAvailableSchedule(owner);
        }
        SecurityContextHolder.clearContext();
    }

    public boolean isCurrentAuthenticatedCalendarUserAdvisor() {
        if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof SecurityContext) || SecurityContextHolder.getContext().getAuthentication() == null) {
            return false;
        }
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        ICalendarAccount calendarAccount = currentUser.getCalendarAccount();
        return this.affiliationSource.doesAccountHaveAffiliation(calendarAccount, (IAffiliation)AffiliationImpl.ADVISOR);
    }

    public boolean isCurrentAuthenticatedCalendarUserInstructor() {
        if (SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext() instanceof SecurityContext) || SecurityContextHolder.getContext().getAuthentication() == null) {
            return false;
        }
        CalendarAccountUserDetailsImpl currentUser = (CalendarAccountUserDetailsImpl)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        ICalendarAccount calendarAccount = currentUser.getCalendarAccount();
        return this.affiliationSource.doesAccountHaveAffiliation(calendarAccount, (IAffiliation)AffiliationImpl.INSTRUCTOR);
    }
}

