/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.xerces.parsers.DOMParser;
import org.jasig.portal.security.provider.saml.AssertionIdpResolverImpl;
import org.jasig.portal.security.provider.saml.DelegatedAuthenticationRuntimeException;
import org.jasig.portal.security.provider.saml.DelegatedSAMLAuthenticationState;
import org.jasig.portal.security.provider.saml.Resource;
import org.jasig.portal.security.provider.saml.SAMLNamespaceContext;
import org.jasig.portal.security.provider.saml.SAMLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAMLDelegatedAuthenticationService {
    Logger log = LoggerFactory.getLogger(SAMLDelegatedAuthenticationService.class);
    private DOMImplementationLS domLoadSaveImpl = null;
    private SAMLNamespaceContext namespaceContext = new SAMLNamespaceContext();
    private static final String SOAP_PREFIX = "soap";

    public SAMLDelegatedAuthenticationService() {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            this.domLoadSaveImpl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        }
        catch (ClassCastException ex) {
            this.log.error("Unable to initialize XML serializer implementation.  Make sure that the correct jar files are present.", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            this.log.error("Unable to initialize XML serializer implementation.  Make sure that the correct jar files are present.", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            this.log.error("Unable to initialize XML serializer implementation.  Make sure that the correct jar files are present.", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            this.log.error("Unable to initialize XML serializer implementation.  Make sure that the correct jar files are present.", (Throwable)ex);
        }
    }

    public HttpResponse authenticate(SAMLSession samlSession, Resource resource) {
        if (samlSession.getSamlAssertion() == null) {
            String message = "SAML assertion not present.";
            this.log.error(message);
            throw new DelegatedAuthenticationRuntimeException(message);
        }
        if (samlSession.getPortalEntityID() == null) {
            String message = "Portal entity ID not present.";
            this.log.error(message);
            throw new DelegatedAuthenticationRuntimeException(message);
        }
        DelegatedSAMLAuthenticationState authnState = new DelegatedSAMLAuthenticationState();
        if (this.getSOAPRequest(samlSession, resource, authnState) && this.getIDP(samlSession, authnState) && this.validateIDP(samlSession, authnState) && this.processSOAPRequest(samlSession, authnState) && this.getSOAPResponse(samlSession, authnState) && this.processSOAPResponse(samlSession, authnState)) {
            HttpResponse response = this.sendSOAPResponse(samlSession, authnState);
            this.postAuthenticationCleanup(samlSession, authnState);
            return response;
        }
        return null;
    }

    public HttpResponse authenticate(SAMLSession samlSession, byte[] paosBytes) {
        if (samlSession.getSamlAssertion() == null) {
            String message = "SAML assertion not present.";
            this.log.error(message);
            throw new DelegatedAuthenticationRuntimeException(message);
        }
        if (samlSession.getPortalEntityID() == null) {
            String message = "Portal entity ID not present.";
            this.log.error(message);
            throw new DelegatedAuthenticationRuntimeException(message);
        }
        DelegatedSAMLAuthenticationState authnState = new DelegatedSAMLAuthenticationState();
        authnState.setSoapRequest(paosBytes);
        if (this.getIDP(samlSession, authnState) && this.validateIDP(samlSession, authnState) && this.processSOAPRequest(samlSession, authnState) && this.getSOAPResponse(samlSession, authnState) && this.processSOAPResponse(samlSession, authnState)) {
            HttpResponse response = this.sendSOAPResponse(samlSession, authnState);
            this.postAuthenticationCleanup(samlSession, authnState);
            return response;
        }
        return null;
    }

    private boolean getResourceQuickly(SAMLSession samlSession, Resource resource) {
        HttpGet method = new HttpGet(resource.getResourceUrl());
        BasicHttpParams params = new BasicHttpParams();
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        method.setParams((HttpParams)params);
        try {
            resource.setupWSPClientConnection(samlSession);
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            String result = (String)samlSession.getHttpClient().execute((HttpUriRequest)method, (ResponseHandler)responseHandler);
            resource.setResource(result);
            return true;
        }
        catch (Exception ex) {
            this.log.error("Exception caught when trying to retrieve the resource.", (Throwable)ex);
            return false;
        }
    }

    private boolean getSOAPRequest(SAMLSession samlSession, Resource resource, DelegatedSAMLAuthenticationState authnState) {
        HttpGet method = new HttpGet(resource.getResourceUrl());
        try {
            resource.setupWSPClientConnection(samlSession);
            HttpResponse response = samlSession.getHttpClient().execute((HttpUriRequest)method);
            HttpEntity entity = response.getEntity();
            long contentLength = entity.getContentLength();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)os);
            os.close();
            byte[] paosBytes = os.toByteArray();
            authnState.setSoapRequest(paosBytes);
        }
        catch (Exception ex) {
            this.log.error("Exception caught when trying to retrieve the resource.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to retrieve the resource.", ex);
        }
        return true;
    }

    private boolean validateIDP(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        InputStream is = null;
        try {
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xpath = xpFactory.newXPath();
            xpath.setNamespaceContext(this.namespaceContext);
            String expression = "/S:Envelope/S:Header/ecp:Request/samlp:IDPList/samlp:IDPEntry[@ProviderID='" + authnState.getIdp() + "']";
            XPathExpression xpathExpression = xpath.compile(expression);
            is = new ByteArrayInputStream(authnState.getSoapRequest());
            InputSource source = new InputSource(is);
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.parse(source);
            Document doc = parser.getDocument();
            NodeList nodes = (NodeList)xpathExpression.evaluate(doc, XPathConstants.NODESET);
            if (nodes.getLength() > 0) {
                authnState.setSoapRequestDom(doc);
                boolean bl = true;
                return bl;
            }
        }
        catch (XPathExpressionException ex) {
            this.log.error("Programming error.  Invalid XPath expression.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Programming error.  Invalid XPath expression.", ex);
        }
        catch (SAXException ex) {
            this.log.error("XML error.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("XML error.", ex);
        }
        catch (IOException ex) {
            this.log.error("Unexpected error.  This method performs no I/O!", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Unexpected error.  This method performs no I/O!", ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        return false;
    }

    private boolean getIDP(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        InputStream is = null;
        try {
            if (samlSession.getSamlAssertionDom() == null) {
                is = new ByteArrayInputStream(samlSession.getSamlAssertion().getBytes());
                InputSource source = new InputSource(is);
                DOMParser parser = new DOMParser();
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.parse(source);
                Document doc = parser.getDocument();
                samlSession.setSamlAssertionDom(doc);
            }
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xpath = xpFactory.newXPath();
            xpath.setNamespaceContext(this.namespaceContext);
            String expression = "/saml2:Assertion/saml2:Issuer";
            XPathExpression xpathExpression = xpath.compile(expression);
            Node node = (Node)xpathExpression.evaluate(samlSession.getSamlAssertionDom(), XPathConstants.NODE);
            if (node != null) {
                String idp = node.getTextContent();
                authnState.setIdp(idp);
                if (samlSession.getIdpResolver() == null) {
                    samlSession.setIdpResolver(new AssertionIdpResolverImpl());
                }
                samlSession.getIdpResolver().resolve(samlSession, authnState);
                boolean bl = true;
                return bl;
            }
        }
        catch (XPathExpressionException ex) {
            this.log.error("Programming error.  Invalid XPath expression.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Programming error.  Invalid XPath expression.", ex);
        }
        catch (SAXException ex) {
            this.log.error("XML error.", (Throwable)ex);
            this.log.trace("XML parsing error when parsing the SAML assertion.  The assertion was: [" + samlSession.getSamlAssertion() + "].");
            throw new DelegatedAuthenticationRuntimeException("XML error.", ex);
        }
        catch (IOException ex) {
            this.log.error("Unexpected error.  This method performs no I/O!", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Unexpected error.  This method performs no I/O!", ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        return false;
    }

    private boolean processSOAPRequest(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        try {
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xpath = xpFactory.newXPath();
            xpath.setNamespaceContext(this.namespaceContext);
            String expression = "/S:Envelope/S:Header/paos:Request";
            XPathExpression xpathExpression = xpath.compile(expression);
            Document dom = authnState.getSoapRequestDom();
            Node node = (Node)xpathExpression.evaluate(dom, XPathConstants.NODE);
            if (node != null) {
                String responseConsumerURL = node.getAttributes().getNamedItem("responseConsumerURL").getTextContent();
                authnState.setResponseConsumerURL(responseConsumerURL);
                Node paosMessageID = node.getAttributes().getNamedItem("messageID");
                if (paosMessageID != null) {
                    authnState.setPaosMessageID(paosMessageID.getTextContent());
                } else {
                    authnState.setPaosMessageID(null);
                }
                node.getParentNode().removeChild(node);
                expression = "/S:Envelope/S:Header/ecp:RelayState";
                xpathExpression = xpath.compile(expression);
                node = (Node)xpathExpression.evaluate(dom, XPathConstants.NODE);
                Element relayStateElement = (Element)node;
                authnState.setRelayStateElement(relayStateElement);
                node.getParentNode().removeChild(node);
                expression = "/S:Envelope/S:Header/ecp:Request";
                xpathExpression = xpath.compile(expression);
                node = (Node)xpathExpression.evaluate(dom, XPathConstants.NODE);
                node.getParentNode().removeChild(node);
                expression = "/S:Envelope/S:Header";
                xpathExpression = xpath.compile(expression);
                Element soapHeader = (Element)xpathExpression.evaluate(dom, XPathConstants.NODE);
                Element newElement = dom.createElementNS(this.namespaceContext.getNamespaceURI("sbf"), "sbf:Framework");
                newElement.setAttribute("version", "2.0");
                soapHeader.appendChild(newElement);
                newElement = dom.createElementNS(this.namespaceContext.getNamespaceURI("sb"), "sb:Sender");
                newElement.setAttribute("providerID", samlSession.getPortalEntityID());
                soapHeader.appendChild(newElement);
                newElement = dom.createElementNS(this.namespaceContext.getNamespaceURI("wsa"), "wsa:MessageID");
                String messageID = this.generateMessageID();
                newElement.setTextContent(messageID);
                soapHeader.appendChild(newElement);
                newElement = dom.createElementNS(this.namespaceContext.getNamespaceURI("wsa"), "wsa:Action");
                newElement.setTextContent("urn:liberty:ssos:2006-08:AuthnRequest");
                soapHeader.appendChild(newElement);
                Element securityElement = dom.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
                securityElement.setAttribute("S:mustUnderstand", "1");
                Element createdElement = dom.createElement("wsu:Created");
                TimeZone zuluTimeZone = TimeZone.getTimeZone("Zulu");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
                sdf.setTimeZone(zuluTimeZone);
                createdElement.setTextContent(sdf.format(new Date()));
                newElement = dom.createElementNS("http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
                newElement.appendChild(createdElement);
                securityElement.appendChild(newElement);
                Node samlAssertionNode = dom.importNode(samlSession.getSamlAssertionDom().getDocumentElement(), true);
                securityElement.appendChild(samlAssertionNode);
                soapHeader.appendChild(securityElement);
                String modifiedSOAPRequest = this.writeDomToString(dom);
                authnState.setModifiedSOAPRequest(modifiedSOAPRequest);
                return true;
            }
        }
        catch (XPathExpressionException ex) {
            this.log.error("Programming error.  Invalid XPath expression.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Programming error.  Invalid XPath expression.", ex);
        }
        return false;
    }

    private String generateMessageID() {
        UUID uuid = UUID.randomUUID();
        String messageID = "urn:uuid:" + uuid.toString();
        return messageID;
    }

    private boolean getSOAPResponse(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        String result = null;
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        params.setParameter("SOAPAction", (Object)"urn:liberty:ssos:2006-08:AuthnRequest");
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        try {
            this.setupIdPClientConnection((HttpClient)client, samlSession, authnState);
            HttpPost method = new HttpPost(authnState.getIdpEndpoint());
            StringEntity postData = new StringEntity(authnState.getModifiedSOAPRequest(), "UTF-8");
            method.setEntity((HttpEntity)postData);
            HttpResponse httpResponse = client.execute((HttpUriRequest)method);
            int resultCode = httpResponse.getStatusLine().getStatusCode();
            if (resultCode >= 200 && resultCode < 300) {
                HttpEntity httpEntity = httpResponse.getEntity();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                httpEntity.writeTo((OutputStream)output);
                result = output.toString();
                authnState.setSoapResponse(result);
                boolean bl = true;
                return bl;
            }
            try {
                this.log.error("Unsupported HTTP result code when retrieving the resource: " + resultCode + ".");
                throw new DelegatedAuthenticationRuntimeException("Unsupported HTTP result code when retrieving the resource: " + resultCode + ".");
            }
            catch (Exception ex) {
                this.log.error("Exception caught when trying to retrieve the resource.", (Throwable)ex);
                throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to retrieve the resource.", ex);
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processSOAPResponse(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        try {
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xpath = xpFactory.newXPath();
            xpath.setNamespaceContext(this.namespaceContext);
            String expression = "/soap:Envelope/soap:Header/ecp:Response";
            XPathExpression xpathExpression = xpath.compile(expression);
            ByteArrayInputStream is = new ByteArrayInputStream(authnState.getSoapResponse().getBytes());
            InputSource source = new InputSource(is);
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.parse(source);
            Document doc = parser.getDocument();
            Node node = (Node)xpathExpression.evaluate(doc, XPathConstants.NODE);
            if (node != null) {
                String responseConsumerURL = node.getAttributes().getNamedItem("AssertionConsumerServiceURL").getTextContent();
                if (responseConsumerURL != null && responseConsumerURL.equals(authnState.getResponseConsumerURL())) {
                    String soapPrefix = node.getParentNode().getPrefix();
                    Element ecpResponse = (Element)node;
                    Element soapHeader = (Element)ecpResponse.getParentNode();
                    this.removeAllChildren(soapHeader);
                    Element paosResponse = doc.createElementNS("urn:liberty:paos:2003-08", "paos:Response");
                    paosResponse.setAttribute(soapPrefix + ":mustUnderstand", "1");
                    paosResponse.setAttribute(soapPrefix + ":actor", "http://schemas.xmlsoap.org/soap/actor/next");
                    if (authnState.getPaosMessageID() != null) {
                        paosResponse.setAttribute("refToMessageID", authnState.getPaosMessageID());
                    }
                    soapHeader.appendChild(paosResponse);
                    if (authnState.getRelayStateElement() != null) {
                        Node relayState = doc.importNode(authnState.getRelayStateElement(), true);
                        soapHeader.appendChild(relayState);
                    }
                    String modifiedSOAPResponse = this.writeDomToString(doc);
                    authnState.setModifiedSOAPResponse(modifiedSOAPResponse);
                    return true;
                }
                Document soapFaultMessage = this.createSOAPFaultDocument("AssertionConsumerServiceURL attribute missing or not matching the expected value.");
                Element soapHeader = (Element)soapFaultMessage.getFirstChild().getFirstChild();
                Element paosResponse = soapFaultMessage.createElementNS("urn:liberty:paos:2003-08", "paos:Response");
                paosResponse.setAttribute("soap:mustUnderstand", "1");
                paosResponse.setAttribute("soap:actor", "http://schemas.xmlsoap.org/soap/actor/next");
                if (authnState.getPaosMessageID() != null) {
                    paosResponse.setAttribute("refToMessageID", authnState.getPaosMessageID());
                }
                soapHeader.appendChild(paosResponse);
                if (authnState.getRelayStateElement() != null) {
                    Node relayState = soapFaultMessage.importNode(authnState.getRelayStateElement(), true);
                    soapHeader.appendChild(relayState);
                }
                String modifiedSOAPResponse = this.writeDomToString(soapFaultMessage);
                authnState.setModifiedSOAPResponse(modifiedSOAPResponse);
                this.sendSOAPFault(samlSession, authnState);
                return false;
            }
            String errorMessage = this.getSOAPFaultAsString(is);
            if (errorMessage == null) return false;
            throw new DelegatedAuthenticationRuntimeException(errorMessage);
        }
        catch (XPathExpressionException ex) {
            this.log.error("XPath programming error.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("XPath programming error.", ex);
        }
        catch (SAXNotRecognizedException ex) {
            this.log.error("Exception caught when trying to process the SOAP esponse from the IdP.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("XPath programming error.", ex);
        }
        catch (SAXNotSupportedException ex) {
            this.log.error("Exception caught when trying to process the SOAP esponse from the IdP.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to process the SOAP esponse from the IdP.", ex);
        }
        catch (SAXException ex) {
            this.log.error("Exception caught when trying to process the SOAP esponse from the IdP.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to process the SOAP esponse from the IdP.", ex);
        }
        catch (DOMException ex) {
            this.log.error("Exception caught when trying to process the SOAP esponse from the IdP.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught when trying to process the SOAP esponse from the IdP.", ex);
        }
        catch (IOException ex) {
            this.log.error("This exception should not ever really occur, as the only I/O this method performs is on a ByteArrayInputStream.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("This exception should not ever really occur, as the only I/O this method performs is on a ByteArrayInputStream.", ex);
        }
        catch (SOAPException ex) {
            this.log.error("Error processing a SOAP message.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Error processing a SOAP message.", ex);
        }
    }

    private String writeDomToString(Document doc) {
        LSSerializer writer = this.domLoadSaveImpl.createLSSerializer();
        DOMConfiguration domConfig = writer.getDomConfig();
        domConfig.setParameter("xml-declaration", false);
        String xmlString = writer.writeToString(doc);
        return xmlString;
    }

    private HttpResponse sendSOAPResponse(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        HttpPost method = new HttpPost(authnState.getResponseConsumerURL());
        method.setHeader("Content-Type", "application/vnd.paos+xml");
        try {
            StringEntity postData = new StringEntity(authnState.getModifiedSOAPResponse(), "UTF-8");
            method.setEntity((HttpEntity)postData);
            HttpParams params = method.getParams();
            boolean redirecting = HttpClientParams.isRedirecting((HttpParams)params);
            if (redirecting) {
                HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
                method.setParams(params);
            }
            HttpResponse response = samlSession.getHttpClient().execute((HttpUriRequest)method);
            if (redirecting) {
                HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
                method.setParams(params);
            }
            return response;
        }
        catch (Exception ex) {
            this.log.error("Exception caught when trying to retrieve the resource.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught while sending the delegated authentication assertion to the service provider.", ex);
        }
    }

    private boolean sendSOAPFault(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        HttpPost method = new HttpPost(authnState.getResponseConsumerURL());
        method.setHeader("Content-Type", "application/vnd.paos+xml");
        try {
            StringEntity postData = new StringEntity(authnState.getModifiedSOAPResponse(), "UTF-8");
            method.setEntity((HttpEntity)postData);
            HttpResponse response = samlSession.getHttpClient().execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            return true;
        }
        catch (Exception ex) {
            this.log.error("Exception caught when trying to retrieve the resource.", (Throwable)ex);
            throw new DelegatedAuthenticationRuntimeException("Exception caught while sending the delegated authentication assertion to the service provider.", ex);
        }
    }

    private void removeAllChildren(Element element) {
        Node child = element.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            element.removeChild(child);
            child = next;
        }
    }

    private String getSOAPFaultAsString(InputStream is) throws IOException, SOAPException {
        is.reset();
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage(null, is);
        SOAPBody body = message.getSOAPBody();
        if (body.hasFault()) {
            SOAPFault fault = body.getFault();
            String code = fault.getFaultCode();
            String string = fault.getFaultString();
            String actor = fault.getFaultActor();
            String formatedMessage = "SOAP transaction resulted in a SOAP fault.";
            if (code != null) {
                formatedMessage = formatedMessage + "  Code=\"" + code + ".\"";
            }
            if (string != null) {
                formatedMessage = formatedMessage + "  String=\"" + string + ".\"";
            }
            if (actor != null) {
                formatedMessage = formatedMessage + "  Actor=\"" + actor + ".\"";
            }
            return formatedMessage;
        }
        return null;
    }

    private Document createSOAPFaultDocument(String faultString) throws SOAPException {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage();
        SOAPPart sp = message.getSOAPPart();
        SOAPEnvelope se = sp.getEnvelope();
        se.setPrefix(SOAP_PREFIX);
        se.getHeader().detachNode();
        SOAPHeader header = se.addHeader();
        se.getBody().detachNode();
        SOAPBody body = se.addBody();
        SOAPFault fault = body.addFault();
        Name faultCode = se.createName("Client", null, "http://schemas.xmlsoap.org/soap/envelope/");
        fault.setFaultCode(faultCode);
        fault.setFaultString(faultString);
        return se.getOwnerDocument();
    }

    private void postAuthenticationCleanup(SAMLSession samlSession, DelegatedSAMLAuthenticationState resource) {
    }

    private void setupIdPClientConnection(HttpClient client, SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) throws MalformedURLException {
        URL url = new URL(authnState.getIdpEndpoint());
        String protocol = url.getProtocol();
        int port = url.getPort();
        if (protocol.equalsIgnoreCase("https")) {
            SSLSocketFactory socketFactory = samlSession.getIdPSocketFactory();
            if (port == -1) {
                port = 443;
            }
            Scheme sch = new Scheme(protocol, (SocketFactory)socketFactory, port);
            client.getConnectionManager().getSchemeRegistry().unregister(protocol);
            client.getConnectionManager().getSchemeRegistry().register(sch);
        }
    }
}

