/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class SAMLNamespaceContext
implements NamespaceContext {
    private static final String[] prefixes = new String[]{"saml2", "ds", "S", "soap", "env", "paos", "ecp", "samlp", "wsa", "sbf", "sb", "disco"};
    private static final String[] uris = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "http://www.w3.org/2000/09/xmldsig#", "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope", "urn:liberty:paos:2003-08", "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp", "urn:oasis:names:tc:SAML:2.0:protocol", "http://www.w3.org/2005/08/addressing", "urn:liberty:sb", "urn:liberty:sb:2006-08", "urn:liberty:disco:2006-08"};
    private List<String> prefixList = new ArrayList<String>();
    private Map<String, String> prefixToURI = new HashMap<String, String>();
    private Map<String, String> uriToPrefix = new HashMap<String, String>();

    public SAMLNamespaceContext() {
        for (int i = 0; i < prefixes.length; ++i) {
            this.prefixList.add(prefixes[i]);
            this.prefixToURI.put(prefixes[i], uris[i]);
            this.uriToPrefix.put(uris[i], prefixes[i]);
        }
    }

    public String getNamespaceURI(String prefix) {
        String uri = this.prefixToURI.get(prefix);
        if (uri != null) {
            return uri;
        }
        return "";
    }

    public String getPrefix(String uri) {
        return this.uriToPrefix.get(uri);
    }

    public Iterator getPrefixes(String arg0) {
        return this.prefixList.iterator();
    }
}

