/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import java.util.concurrent.TimeUnit;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class XPathExpressionPool {
    private final GenericKeyedObjectPool pool;
    private final NamespaceContext namespaceContext;

    public XPathExpressionPool() {
        this(null);
    }

    public XPathExpressionPool(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
        XPathExpressionFactory xpathExpressionfactory = new XPathExpressionFactory();
        this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)xpathExpressionfactory);
        this.pool.setMaxActive(100);
        this.pool.setMaxIdle(100);
        this.pool.setTimeBetweenEvictionRunsMillis(TimeUnit.SECONDS.toMillis(60L));
        this.pool.setMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(5L));
        this.pool.setNumTestsPerEvictionRun(this.pool.getMaxIdle() / 6);
    }

    protected void finalize() throws Throwable {
        this.pool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T doWithExpression(String expression, XPathExpressionCallback<T> callback) throws XPathExpressionException {
        try {
            XPathExpression xPathExpression = (XPathExpression)this.pool.borrowObject((Object)expression);
            try {
                T t = callback.doWithExpression(null);
                return t;
            }
            finally {
                this.pool.returnObject((Object)expression, (Object)xPathExpression);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (!(e instanceof XPathExpressionException)) throw new IllegalStateException("Exception of type " + e.getClass().getName() + " is not expected", e);
            throw (XPathExpressionException)e;
        }
    }

    public <T> T evaluate(String expression, final Object item, final QName returnType) throws XPathExpressionException {
        return this.doWithExpression(expression, new XPathExpressionCallback<T>(){

            @Override
            public T doWithExpression(XPathExpression xPathExpression) throws XPathExpressionException {
                return xPathExpression.evaluate(item, returnType);
            }
        });
    }

    public void clear() {
        this.pool.clear();
    }

    public void clearOldest() {
        this.pool.clearOldest();
    }

    public void close() throws Exception {
        this.pool.close();
    }

    public void evict() throws Exception {
        this.pool.evict();
    }

    public boolean getLifo() {
        return this.pool.getLifo();
    }

    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    public int getMaxIdle() {
        return this.pool.getMaxIdle();
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    public long getMaxWait() {
        return this.pool.getMaxWait();
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.pool.getMinEvictableIdleTimeMillis();
    }

    public int getMinIdle() {
        return this.pool.getMinIdle();
    }

    public int getNumActive() {
        return this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    public int getNumTestsPerEvictionRun() {
        return this.pool.getNumTestsPerEvictionRun();
    }

    public boolean getTestOnBorrow() {
        return this.pool.getTestOnBorrow();
    }

    public boolean getTestOnReturn() {
        return this.pool.getTestOnReturn();
    }

    public boolean getTestWhileIdle() {
        return this.pool.getTestWhileIdle();
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.pool.getTimeBetweenEvictionRunsMillis();
    }

    public byte getWhenExhaustedAction() {
        return this.pool.getWhenExhaustedAction();
    }

    public void setLifo(boolean lifo) {
        this.pool.setLifo(lifo);
    }

    public void setMaxActive(int maxActive) {
        this.pool.setMaxActive(maxActive);
    }

    public void setMaxIdle(int maxIdle) {
        this.pool.setMaxIdle(maxIdle);
    }

    public void setMaxTotal(int maxTotal) {
        this.pool.setMaxTotal(maxTotal);
    }

    public void setMaxWait(long maxWait) {
        this.pool.setMaxWait(maxWait);
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.pool.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    public void setMinIdle(int poolSize) {
        this.pool.setMinIdle(poolSize);
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.pool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.pool.setTestOnBorrow(testOnBorrow);
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.pool.setTestOnReturn(testOnReturn);
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.pool.setTestWhileIdle(testWhileIdle);
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.pool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public void setWhenExhaustedAction(byte whenExhaustedAction) {
        this.pool.setWhenExhaustedAction(whenExhaustedAction);
    }

    private class XPathExpressionFactory
    extends BaseKeyedPoolableObjectFactory {
        private final XPathFactory xPathFactory = XPathFactory.newInstance();

        private XPathExpressionFactory() {
        }

        public synchronized Object makeObject(Object key) throws Exception {
            String expression = (String)key;
            XPath xPath = this.xPathFactory.newXPath();
            if (XPathExpressionPool.this.namespaceContext != null) {
                xPath.setNamespaceContext(XPathExpressionPool.this.namespaceContext);
            }
            return xPath.compile(expression);
        }
    }

    public static interface XPathExpressionCallback<T> {
        public T doWithExpression(XPathExpression var1) throws XPathExpressionException;
    }
}

