/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.jasig.portal.security.provider.saml.DelegatedAuthenticationRuntimeException;
import org.jasig.portal.security.provider.saml.PublicKeyVerifyingSSLSocketFactory;
import org.jasig.portal.security.provider.saml.SSLSecurityWrapper;
import org.jasig.portal.security.provider.saml.TrustAllX509TrustManager;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.x509.X509Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSecurityImpl
implements SSLSecurityWrapper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private KeyStore keyStore = null;
    private String keyStorePass = null;
    private KeyStore trustStore = null;
    private String publicKeys;
    private static final long serialVersionUID = 1L;

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        try {
            PublicKeyVerifyingSSLSocketFactory socketFactory = null;
            if (this.keyStore != null) {
                if (this.trustStore != null) {
                    socketFactory = new PublicKeyVerifyingSSLSocketFactory(this.keyStore, this.keyStorePass, this.trustStore);
                } else {
                    socketFactory = new PublicKeyVerifyingSSLSocketFactory(this.keyStore, this.keyStorePass);
                    if (this.publicKeys != null) {
                        socketFactory.setEncodedPublicKeys(this.publicKeys);
                    }
                }
            } else if (this.trustStore != null) {
                socketFactory = new PublicKeyVerifyingSSLSocketFactory(this.trustStore);
            } else if (this.publicKeys != null) {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, new TrustManager[]{TrustAllX509TrustManager.INSTANCE}, null);
                socketFactory = new PublicKeyVerifyingSSLSocketFactory(sslcontext);
                socketFactory.setEncodedPublicKeys(this.publicKeys);
            } else {
                return SSLSocketFactory.getSocketFactory();
            }
            return socketFactory;
        }
        catch (Exception ex) {
            throw new DelegatedAuthenticationRuntimeException("Error dealing with SSL.  See stack trace for details.", ex);
        }
    }

    private void setSSLClientCredentials(PrivateKey pk, Certificate cert) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException {
        this.logger.info("Private key: [{}].", (Object)pk.toString());
        this.logger.info("Certificate: [{}].", (Object)cert.toString());
        KeyStore ks = KeyStore.getInstance("JKS", "SUN");
        ks.load(null, null);
        Certificate[] certificates = new Certificate[]{cert};
        String keystorePass = UUID.randomUUID().toString();
        ks.setKeyEntry("sp", pk, keystorePass.toCharArray(), certificates);
        this.keyStore = ks;
        this.keyStorePass = keystorePass;
    }

    @Override
    public void setSSLClientKeystore(String ksFile, String pass) {
        try {
            KeyStore ks;
            this.keyStore = ks = this.loadKeyStoreFromFile(ksFile, pass);
            this.keyStorePass = pass;
        }
        catch (Exception ex) {
            throw new DelegatedAuthenticationRuntimeException("Error dealing with SSL.  See stack trace for details.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStoreFromFile(String ksFile, String pass) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream fis = new FileInputStream(ksFile);
        try {
            KeyStore ks = KeyStore.getInstance("JKS", "SUN");
            ks.load(fis, pass.toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        finally {
            fis.close();
        }
    }

    @Override
    public void setSSLTrustStore(String ksFile, String pass) {
        try {
            KeyStore ks;
            this.trustStore = ks = this.loadKeyStoreFromFile(ksFile, pass);
        }
        catch (Exception ex) {
            throw new DelegatedAuthenticationRuntimeException("Error dealing with SSL.  See stack trace for details.", ex);
        }
    }

    @Override
    public void setSSLClientPrivateKeyAndCert(String pkFile, String certFile) {
        try {
            PrivateKey key = SecurityHelper.decodePrivateKey((File)new File(pkFile), null);
            Collection certs = X509Util.decodeCertificate((File)new File(certFile));
            X509Certificate cert = (X509Certificate)certs.iterator().next();
            this.setSSLClientCredentials(key, cert);
        }
        catch (Exception ex) {
            throw new DelegatedAuthenticationRuntimeException("Error dealing with SSL.  See stack trace for details.", ex);
        }
    }

    @Override
    public void setSSLServerPublicKeys(String encodedKeys) {
        this.publicKeys = encodedKeys;
    }
}

