/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.jasig.portal.security.provider.saml.DelegatedAuthenticationRuntimeException;
import org.jasig.portal.security.provider.saml.DelegatedSAMLAuthenticationState;
import org.jasig.portal.security.provider.saml.IdPEPRResolver;
import org.jasig.portal.security.provider.saml.SAMLSession;
import org.jasig.portal.security.provider.saml.XPathExpressionExecutor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AssertionIdpResolverImpl
implements IdPEPRResolver {
    private final XPathExpressionExecutor xPathExpressionPool;

    public AssertionIdpResolverImpl(XPathExpressionExecutor xPathExpressionPool) {
        this.xPathExpressionPool = xPathExpressionPool;
    }

    @Override
    public void resolve(SAMLSession samlSession, DelegatedSAMLAuthenticationState authnState) {
        String expression = "/saml2:Assertion/saml2:AttributeStatement/saml2:Attribute[@Name='urn:liberty:ssos:2006-08']";
        try {
            Document doc = samlSession.getSamlAssertionDom();
            Node attributeNode = (Node)this.xPathExpressionPool.evaluate(expression, doc, XPathConstants.NODE);
            if (attributeNode == null) {
                throw new DelegatedAuthenticationRuntimeException("No saml2:Attribute containing IdP Endpoint Reference found in the SAML assertion.");
            }
            expression = "./saml2:AttributeValue/wsa:EndpointReference/wsa:Metadata[disco:ServiceType='urn:liberty:ssos:2006-08']";
            Node serviceTypeNode = (Node)this.xPathExpressionPool.evaluate(expression, attributeNode, XPathConstants.NODE);
            if (serviceTypeNode == null) {
                throw new DelegatedAuthenticationRuntimeException("No matching ServiceType URI found in the Endpoint Reference");
            }
            expression = "./saml2:AttributeValue/wsa:EndpointReference/wsa:Metadata[disco:ProviderID='" + authnState.getIdp() + "']";
            Node providerIDNode = (Node)this.xPathExpressionPool.evaluate(expression, attributeNode, XPathConstants.NODE);
            if (providerIDNode == null) {
                throw new DelegatedAuthenticationRuntimeException("Provider ID in the Endpoint Reference does not match the IdP previously established");
            }
            expression = "./saml2:AttributeValue/wsa:EndpointReference/wsa:Metadata/sbf:Framework[@version>=2.0]";
            Node frameworkNode = (Node)this.xPathExpressionPool.evaluate(expression, attributeNode, XPathConstants.NODE);
            if (frameworkNode == null) {
                throw new DelegatedAuthenticationRuntimeException("Framework version must be at least 2.0");
            }
            expression = "./saml2:AttributeValue/wsa:EndpointReference/wsa:Address";
            Node addressNode = (Node)this.xPathExpressionPool.evaluate(expression, attributeNode, XPathConstants.NODE);
            if (addressNode == null) {
                throw new DelegatedAuthenticationRuntimeException("Endpoint Reference Address node not present");
            }
            String ep = addressNode.getTextContent();
            authnState.setIdpEndpoint(ep);
        }
        catch (XPathExpressionException ex) {
            throw new DelegatedAuthenticationRuntimeException("XPath processing error with expression:" + expression, ex);
        }
    }
}

