/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpParams;
import org.opensaml.xml.security.SecurityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyVerifyingSSLSocketFactory
extends SSLSocketFactory {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final PublicKey publicKey;

    public PublicKeyVerifyingSSLSocketFactory(SSLContext sslContext, String encodedPublicKeys) throws KeyException {
        super(sslContext);
        byte[] decodedBytes = Base64.decodeBase64((byte[])encodedPublicKeys.getBytes());
        this.publicKey = SecurityHelper.decodePublicKey((byte[])decodedBytes, null);
    }

    public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        SSLSocket newSocket = (SSLSocket)super.connectSocket(sock, host, port, localAddress, localPort, params);
        if (this.publicKey != null) {
            this.logger.debug("Verifying SSL Socket to {}:{} against configured public key {}", new Object[]{host, port, this.publicKey});
            SSLSession session = newSocket.getSession();
            Certificate[] certs = session.getPeerCertificates();
            boolean matchFound = false;
            for (int i = 0; i < certs.length; ++i) {
                X509Certificate x509 = (X509Certificate)certs[i];
                PublicKey certKey = x509.getPublicKey();
                if (certKey.equals(this.publicKey)) {
                    this.logger.debug("Validated public key against server key: {}", (Object)certKey);
                    matchFound = true;
                    break;
                }
                this.logger.debug("server key doesn't match public key: {} ", (Object)certKey);
            }
            if (!matchFound) {
                newSocket.close();
                throw new IOException("Unable to verify the server's public key");
            }
        }
        return newSocket;
    }
}

