/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.saml;

import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.jasig.portal.security.provider.saml.HttpRequestPostprocessor;
import org.jasig.portal.security.provider.saml.HttpRequestPreprocessor;
import org.jasig.portal.security.provider.saml.IdPEPRResolver;
import org.jasig.portal.security.provider.saml.SSLSecurityImpl;
import org.jasig.portal.security.provider.saml.SSLSecurityWrapper;
import org.w3c.dom.Document;

public class SAMLSession {
    private final String samlAssertion;
    private final HttpClient wspHttpClient;
    private IdPEPRResolver idpResolver = null;
    private Document samlAssertionDom = null;
    private SSLSecurityWrapper idpSSL = new SSLSecurityImpl();
    private String portalEntityID;
    private boolean skipValidateIdp = false;

    public SAMLSession(String samlAssertion, ClientConnectionManager connectionManager, HttpParams params) {
        DefaultHttpClient client = new DefaultHttpClient(connectionManager, params);
        client.addRequestInterceptor((HttpRequestInterceptor)new HttpRequestPreprocessor());
        client.addResponseInterceptor((HttpResponseInterceptor)new HttpRequestPostprocessor(this));
        this.wspHttpClient = client;
        this.samlAssertion = samlAssertion;
    }

    public String getSamlAssertion() {
        return this.samlAssertion;
    }

    public Document getSamlAssertionDom() {
        return this.samlAssertionDom;
    }

    void setSamlAssertionDom(Document samlAssertionDom) {
        this.samlAssertionDom = samlAssertionDom;
    }

    public HttpClient getHttpClient() {
        return this.wspHttpClient;
    }

    public IdPEPRResolver getIdpResolver() {
        return this.idpResolver;
    }

    public void setIdpResolver(IdPEPRResolver idpResolver) {
        this.idpResolver = idpResolver;
    }

    public void setIdPClientPrivateKeyAndCert(String pkFile, String certFile) {
        this.idpSSL.setSSLClientPrivateKeyAndCert(pkFile, certFile);
    }

    public void setIdPClientKeystore(String ks, String pass) {
        this.idpSSL.setSSLClientKeystore(ks, pass);
    }

    public void setIdPClientTrustStore(String ks, String pass) {
        this.idpSSL.setSSLTrustStore(ks, pass);
    }

    public void setIdPServerPublicKeys(String publicKeys) {
        this.idpSSL.setSSLServerPublicKeys(publicKeys);
    }

    public SSLSocketFactory getIdPSocketFactory() {
        return this.idpSSL.getSSLSocketFactory();
    }

    public String getPortalEntityID() {
        return this.portalEntityID;
    }

    public void setPortalEntityID(String portalEntityID) {
        this.portalEntityID = portalEntityID;
    }

    public boolean isSkipValidateIdp() {
        return this.skipValidateIdp;
    }

    public void setSkipValidateIdp(boolean skipValidateIdp) {
        this.skipValidateIdp = skipValidateIdp;
    }
}

