/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.jasig.services.persondir.support.ComplexStubPersonAttributeDao;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;

public class JsonBackedComplexStubPersonAttributeDao
extends ComplexStubPersonAttributeDao {
    private final Resource personAttributesConfigFile;
    private final ObjectMapper jacksonObjectMapper = new ObjectMapper();
    private final Object synchronizationMonitor = new Object();

    public JsonBackedComplexStubPersonAttributeDao(Resource personAttributesConfigFile) {
        this.personAttributesConfigFile = personAttributesConfigFile;
    }

    public void init() throws IOException {
        try {
            this.unmarshalAndSetBackingMap();
        }
        catch (ClassCastException ex) {
            throw new BeanCreationException(String.format("The semantic structure of the person attributesJSON config is not correct. Please fix it in this resource: [%s]", this.personAttributesConfigFile.getURI()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarshalAndSetBackingMap() throws IOException {
        this.logger.info("Un-marshaling person attributes from the config file " + this.personAttributesConfigFile.getFile());
        Map backingMap = (Map)this.jacksonObjectMapper.readValue(this.personAttributesConfigFile.getFile(), Map.class);
        this.logger.debug("Person attributes have been successfully read into the map ");
        Object object = this.synchronizationMonitor;
        synchronized (object) {
            super.setBackingMap(backingMap);
        }
    }
}

