/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.springsecurity;

import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.jasypt.util.PasswordEncryptor;

public class StandardPasswordEncoder
implements PasswordEncoder {
    private PasswordEncryptor passwordEncryptor = null;

    public StandardPasswordEncoder() {
        this.passwordEncryptor = new PasswordEncryptor();
    }

    public StandardPasswordEncoder(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public String encodePassword(String rawPass, Object salt) {
        return this.passwordEncryptor.encryptPassword(rawPass);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        return this.passwordEncryptor.checkPassword(rawPass, encPass);
    }
}

