/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.springsecurity;

import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.apache.commons.lang.Validate;
import org.jasypt.digest.StringDigester;

public class StringDigesterPasswordEncoder
implements PasswordEncoder {
    private StringDigester stringDigester = null;

    public StringDigesterPasswordEncoder() {
    }

    public StringDigesterPasswordEncoder(StringDigester stringDigester) {
        this.stringDigester = stringDigester;
    }

    public void setStringDigester(StringDigester stringDigester) {
        this.stringDigester = stringDigester;
    }

    public String encodePassword(String rawPass, Object salt) {
        Validate.notNull((Object)this.stringDigester, (String)"String Digester not set for Password Encoder");
        return this.stringDigester.digest(rawPass);
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        Validate.notNull((Object)this.stringDigester, (String)"String Digester not set for Password Encoder");
        return this.stringDigester.matches(rawPass, encPass);
    }
}

