/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.xml.encryption;

import org.jasypt.spring31.xml.encryption.AbstractEncryptionBeanDefinitionParser;
import org.jasypt.spring31.xml.encryption.EncryptorFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EncryptorBeanDefinitionParser
extends AbstractEncryptionBeanDefinitionParser {
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String PARAM_ALGORITHM = "algorithm";
    private static final String PARAM_CONFIG_BEAN = "config-bean";
    private static final String PARAM_KEY_OBTENTION_ITERATIONS = "key-obtention-iterations";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_POOL_SIZE = "pool-size";
    private static final String PARAM_PROVIDER_BEAN = "provider-bean";
    private static final String PARAM_PROVIDER_NAME = "provider-name";
    private static final String PARAM_SALT_GENERATOR_BEAN = "salt-generator-bean";
    private static final String PARAM_STRING_OUTPUT_TYPE = "string-output-type";
    private final int encryptorType;

    EncryptorBeanDefinitionParser(int encryptorType) {
        this.encryptorType = encryptorType;
    }

    protected Class<?> getBeanClass(Element element) {
        return EncryptorFactoryBean.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        builder.addConstructorArgValue((Object)new Integer(this.encryptorType));
        this.processStringAttribute(element, builder, PARAM_ALGORITHM, PARAM_ALGORITHM);
        this.processBeanAttribute(element, builder, PARAM_CONFIG_BEAN, "config");
        this.processIntegerAttribute(element, builder, PARAM_KEY_OBTENTION_ITERATIONS, "keyObtentionIterations");
        this.processStringAttribute(element, builder, PARAM_PASSWORD, PARAM_PASSWORD);
        this.processIntegerAttribute(element, builder, PARAM_POOL_SIZE, "poolSize");
        this.processBeanAttribute(element, builder, PARAM_PROVIDER_BEAN, "provider");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_NAME, "providerName");
        this.processBeanAttribute(element, builder, PARAM_SALT_GENERATOR_BEAN, "saltGenerator");
        this.processStringAttribute(element, builder, PARAM_STRING_OUTPUT_TYPE, "stringOutputType");
        String scope = element.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.hasLength((String)scope)) {
            builder.setScope(scope);
        }
    }
}

