/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.springsecurity4.crypto.password;

import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jasypt.util.text.TextEncryptor;
import org.springframework.security.crypto.password.PasswordEncoder;

public final class PBEPasswordEncoder
implements PasswordEncoder {
    private TextEncryptor textEncryptor = null;
    private PBEStringEncryptor pbeStringEncryptor = null;
    private Boolean useTextEncryptor = null;

    public void setTextEncryptor(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
        this.useTextEncryptor = Boolean.TRUE;
    }

    public void setPbeStringEncryptor(PBEStringEncryptor pbeStringEncryptor) {
        this.pbeStringEncryptor = pbeStringEncryptor;
        this.useTextEncryptor = Boolean.FALSE;
    }

    public String encode(CharSequence rawPassword) {
        this.checkInitialization();
        if (this.useTextEncryptor.booleanValue()) {
            return this.textEncryptor.encrypt(rawPassword.toString());
        }
        return this.pbeStringEncryptor.encrypt(rawPassword.toString());
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        this.checkInitialization();
        String decPassword = null;
        decPassword = this.useTextEncryptor != false ? this.textEncryptor.decrypt(encodedPassword) : this.pbeStringEncryptor.decrypt(encodedPassword);
        if (decPassword == null || rawPassword == null) {
            return decPassword == rawPassword;
        }
        return decPassword.equals(rawPassword);
    }

    private synchronized void checkInitialization() {
        if (this.useTextEncryptor == null) {
            this.textEncryptor = new BasicTextEncryptor();
            this.useTextEncryptor = Boolean.TRUE;
        } else if (this.useTextEncryptor.booleanValue()) {
            if (this.textEncryptor == null) {
                throw new EncryptionInitializationException("PBE Password encoder not initialized: text encryptor is null");
            }
        } else if (this.pbeStringEncryptor == null) {
            throw new EncryptionInitializationException("PBE Password encoder not initialized: PBE string encryptor is null");
        }
    }
}

