/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.wicket15;

import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.crypt.Base64;
import org.apache.wicket.util.crypt.ICrypt;
import org.jasypt.encryption.pbe.PBEByteEncryptor;

public final class JasyptCrypt
implements ICrypt {
    private static final String CHARACTER_ENCODING = "UTF-8";
    private final PBEByteEncryptor encryptor;

    public JasyptCrypt(PBEByteEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public String decryptUrlSafe(String text) {
        try {
            byte[] base64EncryptedBytes = text.getBytes();
            byte[] encryptedBytes = Base64.decodeBase64((byte[])base64EncryptedBytes);
            return new String(this.encryptor.decrypt(encryptedBytes), CHARACTER_ENCODING);
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public String encryptUrlSafe(String plainText) {
        try {
            byte[] plainBytes = plainText.getBytes(CHARACTER_ENCODING);
            byte[] encryptedBytes = this.encryptor.encrypt(plainBytes);
            return new String(Base64.encodeBase64((byte[])encryptedBytes));
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public void setKey(String key) {
        throw new UnsupportedOperationException("JasyptCrypt encryptors cannot be set password by calling " + ICrypt.class.getName() + ".setKey()");
    }
}

