/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Selection;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.log4j.Logger;
import org.javabeanstack.data.DataInfo;
import org.javabeanstack.data.DataResult;
import org.javabeanstack.data.DataSet;
import org.javabeanstack.data.IDBConnectFactory;
import org.javabeanstack.data.IDBLinkInfo;
import org.javabeanstack.data.IDBManagerLocal;
import org.javabeanstack.data.IDataObject;
import org.javabeanstack.data.IDataResult;
import org.javabeanstack.data.IDataRow;
import org.javabeanstack.data.IDataSet;
import org.javabeanstack.data.IGenericDAO;
import org.javabeanstack.error.ErrorManager;
import org.javabeanstack.error.ErrorReg;
import org.javabeanstack.error.IErrorReg;
import org.javabeanstack.security.ISessionsLocal;
import org.javabeanstack.security.IUserSession;
import org.javabeanstack.util.Fn;
import org.javabeanstack.util.Strings;

@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public abstract class AbstractDAO
implements IGenericDAO,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(AbstractDAO.class);
    @Resource
    TransactionSynchronizationRegistry tsr;
    @EJB
    private IDBManagerLocal dbManager;
    @EJB
    private ISessionsLocal sessions;

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public EntityManager getEntityManager(String keyId) {
        String persistUnit = keyId.substring(0, keyId.indexOf(":")).toLowerCase();
        LOGGER.debug((Object)"getEntityManager()");
        LOGGER.debug((Object)("pu: " + persistUnit + ", id: " + keyId));
        return this.dbManager.getEntityManager(keyId);
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public <T> List<T> findAll(Class<T> entityClass, IDBLinkInfo dbLinkInfo) throws Exception {
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"findAll");
        LOGGER.debug((Object)entityClass.toString());
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        CriteriaQuery cq = em.getCriteriaBuilder().createQuery(entityClass);
        cq.select((Selection)cq.from(entityClass));
        List result = em.createQuery(cq).getResultList();
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public <T extends IDataRow> T find(Class<T> entityClass, IDBLinkInfo dbLinkInfo, Object id) throws Exception {
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"find");
        LOGGER.debug((Object)entityClass.toString());
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        IDataRow row = (IDataRow)em.find(entityClass, id);
        if (6 == this.tsr.getTransactionStatus()) {
            return (T)row;
        }
        List<Field> fields = DataInfo.getLazyMembers(row.getClass());
        if (!fields.isEmpty()) {
            for (Field field : fields) {
                field.setAccessible(true);
                List obj = (List)field.get(row);
                obj.size();
            }
        }
        return (T)row;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public <T extends IDataRow> T findByUk(Class<T> entityClass, IDBLinkInfo dbLinkInfo, T ejb) throws Exception {
        IDataRow row;
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"findByUk");
        LOGGER.debug((Object)entityClass.toString());
        if (ejb.getQueryUK() == null) {
            return null;
        }
        Query q = this.getEntityManager(this.getEntityId(dbLinkInfo)).createQuery(ejb.getQueryUK());
        for (Parameter param : q.getParameters()) {
            q.setParameter(param, ejb.getValue(param.getName()));
        }
        try {
            row = (IDataRow)q.getSingleResult();
            if (6 == this.tsr.getTransactionStatus()) {
                return (T)row;
            }
            List<Field> fields = DataInfo.getLazyMembers(row.getClass());
            if (!fields.isEmpty()) {
                for (Field field : fields) {
                    field.setAccessible(true);
                    List obj = (List)field.get(row);
                    obj.size();
                }
            }
        }
        catch (NoResultException exp) {
            row = null;
        }
        return (T)row;
    }

    public <T extends IDataRow> T findByQuery(Class<T> entityClass, IDBLinkInfo dbLinkInfo, String queryString, Map<String, Object> parameters) throws Exception {
        IDataRow result;
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"findByQuery");
        LOGGER.debug((Object)queryString);
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        Query query = em.createQuery(queryString);
        if (parameters != null && !parameters.isEmpty()) {
            this.populateQueryParameters(query, parameters, queryString);
        }
        try {
            List<Field> fields;
            result = (IDataRow)query.getSingleResult();
            if (6 != this.tsr.getTransactionStatus() && !(fields = DataInfo.getLazyMembers(result.getClass())).isEmpty()) {
                for (Field field : fields) {
                    field.setAccessible(true);
                    List obj = (List)field.get(result);
                    obj.size();
                }
            }
        }
        catch (NoResultException exp) {
            result = null;
        }
        LOGGER.debug((Object)"-RESULT-");
        LOGGER.debug((Object)result);
        return (T)result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public <T extends IDataRow> List<T> findListByQuery(IDBLinkInfo dbLinkInfo, String queryString, Map<String, Object> parameters) throws Exception {
        return this.findListByQuery(dbLinkInfo, queryString, parameters, 0, 0);
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public <T extends IDataRow> List<T> findListByQuery(IDBLinkInfo dbLinkInfo, String queryString, Map<String, Object> parameters, int first, int max) throws Exception {
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"findListByQuery");
        LOGGER.debug((Object)queryString);
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        Query query = em.createQuery(queryString);
        if (parameters != null && !parameters.isEmpty()) {
            this.populateQueryParameters(query, parameters, queryString);
        }
        query.setFirstResult(first);
        query.setMaxResults(max);
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public <T extends IDataRow> List<T> findListByQuery(IDBLinkInfo dbLinkInfo, String queryString, int first, int max) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.findListByQuery(dbLinkInfo, queryString, parameters, first, max);
    }

    public <T extends IDataRow> T findByNamedQuery(IDBLinkInfo dbLinkInfo, String namedQuery, Map<String, Object> parameters) throws Exception {
        IDataRow result;
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        Query query = em.createNamedQuery(namedQuery);
        if (parameters != null && !parameters.isEmpty()) {
            this.populateQueryParameters(query, parameters, null);
        }
        query.setMaxResults(1);
        try {
            List<Field> fields;
            result = (IDataRow)query.getSingleResult();
            if (6 != this.tsr.getTransactionStatus() && !(fields = DataInfo.getLazyMembers(result.getClass())).isEmpty()) {
                for (Field field : fields) {
                    field.setAccessible(true);
                    List obj = (List)field.get(result);
                    obj.size();
                }
            }
        }
        catch (NoResultException exp) {
            result = null;
        }
        return (T)result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public <T extends IDataRow> List<T> findListByNamedQuery(IDBLinkInfo dbLinkInfo, String namedQuery, Map<String, Object> parameters) throws Exception {
        return this.findListByNamedQuery(dbLinkInfo, namedQuery, parameters, 0, 0);
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public <T extends IDataRow> List<T> findListByNamedQuery(IDBLinkInfo dbLinkInfo, String namedQuery, int first, int max) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.findListByNamedQuery(dbLinkInfo, namedQuery, parameters, first, max);
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public <T extends IDataRow> List<T> findListByNamedQuery(IDBLinkInfo dbLinkInfo, String namedQuery, Map<String, Object> parameters, int first, int max) throws Exception {
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        Query query = em.createNamedQuery(namedQuery);
        if (parameters != null && !parameters.isEmpty()) {
            this.populateQueryParameters(query, parameters, null);
        }
        if (first > 0 && max > 0) {
            query.setFirstResult(first);
            query.setMaxResults(max);
        }
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public List<Object> findByNativeQuery(IDBLinkInfo dbLinkInfo, String queryString, Map<String, Object> parameters) throws Exception {
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"findByNativeQuery");
        String persistUnit = dbLinkInfo != null ? dbLinkInfo.getPersistUnit() : "PU1";
        queryString = Strings.textMerge((String)queryString, this.getQueryConstants(persistUnit));
        LOGGER.debug((Object)queryString);
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        Query query = em.createNativeQuery(queryString);
        if (parameters != null && !parameters.isEmpty()) {
            this.populateQueryParameters(query, parameters, queryString);
        }
        List result = query.getResultList();
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public List<Object> findByNativeQuery(IDBLinkInfo dbLinkInfo, String queryString, Map<String, Object> parameters, int first, int max) throws Exception {
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"findByNativeQuery");
        String persistUnit = dbLinkInfo != null ? dbLinkInfo.getPersistUnit() : "PU1";
        queryString = Strings.textMerge((String)queryString, this.getQueryConstants(persistUnit));
        LOGGER.debug((Object)queryString);
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        Query query = em.createNativeQuery(queryString);
        if (parameters != null && !parameters.isEmpty()) {
            this.populateQueryParameters(query, parameters, queryString);
        }
        query.setFirstResult(first);
        query.setMaxResults(max);
        List result = query.getResultList();
        return result;
    }

    public IErrorReg sqlExec(IDBLinkInfo dbLinkInfo, String sqlString, Map<String, Object> parameters) throws Exception {
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"sqlExec");
        String persistUnit = dbLinkInfo == null ? "PU1" : dbLinkInfo.getPersistUnit();
        sqlString = Strings.textMerge((String)sqlString, this.getQueryConstants(persistUnit));
        LOGGER.debug((Object)sqlString);
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        ErrorReg error = null;
        try {
            Query sql = em.createNativeQuery(sqlString);
            if (parameters != null && !parameters.isEmpty()) {
                this.populateQueryParameters(sql, parameters, sqlString);
            }
            sql.executeUpdate();
        }
        catch (Exception exp) {
            error = new ErrorReg();
            error.setMessage(exp.getLocalizedMessage());
        }
        return error;
    }

    public <T extends IDataRow> IDataResult update(IDBLinkInfo dbLinkInfo, T ejb) {
        ArrayList<T> ejbs = new ArrayList<T>();
        ejbs.add(ejb);
        return this.update(dbLinkInfo, ejbs);
    }

    public <T extends IDataRow> IDataResult update(IDBLinkInfo dbLinkInfo, IDataObject ejbs) {
        return this.update(dbLinkInfo, ejbs.getDataRows());
    }

    public <T extends IDataRow> IDataResult update(IDBLinkInfo dbLinkInfo, List<T> ejbs) {
        DataSet dataSet = new DataSet();
        dataSet.add("1", ejbs);
        return this.update(dbLinkInfo, dataSet);
    }

    public IDataResult update(IDBLinkInfo dbLinkInfo, IDataSet dataSet) {
        if (dataSet == null || dataSet.size() == 0) {
            return null;
        }
        String appUser = "";
        String sessionId = "";
        if (dbLinkInfo.getUserSession() != null) {
            sessionId = dbLinkInfo.getUserSession().getSessionId();
        }
        if (!Strings.isNullorEmpty((String)sessionId).booleanValue()) {
            appUser = this.getUserSession(sessionId).getUser().getPass();
        }
        DataResult dataResult = new DataResult();
        IDataRow lastEjb = null;
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        for (Map.Entry entry : dataSet.getMapListSet().entrySet()) {
            List ejbs = (List)entry.getValue();
            ArrayList<IDataRow> ejbsRes = new ArrayList<IDataRow>();
            try {
                Iterator iterator = ejbs.iterator();
                while (iterator.hasNext()) {
                    IDataRow ejb;
                    lastEjb = ejb = (IDataRow)iterator.next();
                    switch (ejb.getAction()) {
                        case 1: {
                            this.setAppUser(ejb, appUser);
                            ejbsRes.add(ejb);
                            em.persist((Object)ejb);
                            break;
                        }
                        case 2: {
                            this.setAppUser(ejb, appUser);
                            ejbsRes.add(ejb);
                            em.merge((Object)ejb);
                            break;
                        }
                        case 3: {
                            ejbsRes.add(ejb);
                            em.remove(em.merge((Object)ejb));
                            ejbsRes.remove(ejb);
                            break;
                        }
                    }
                    ejb.setErrors((Map)null);
                }
                em.flush();
                for (IDataRow ejb : ejbs) {
                    if (ejb.getAction() == 3) continue;
                    ejb.setAction(0);
                }
                dataResult.put((String)entry.getKey(), ejbsRes);
            }
            catch (Exception ex) {
                String msgError = ErrorManager.getStackCause((Throwable)ex);
                if (lastEjb != null) {
                    lastEjb.setErrors(msgError, "", 0);
                }
                dataResult.put((String)entry.getKey(), ejbsRes);
                dataResult.setSuccess(false);
                dataResult.setErrorMsg(msgError);
                this.dbManager.rollBack();
                ErrorManager.showError((Exception)ex, (Logger)LOGGER);
                break;
            }
        }
        return dataResult;
    }

    public <T extends IDataRow> IDataResult persist(IDBLinkInfo dbLinkInfo, T ejb) {
        ejb.setAction(1);
        return this.update(dbLinkInfo, ejb);
    }

    public <T extends IDataRow> IDataResult merge(IDBLinkInfo dbLinkInfo, T ejb) {
        ejb.setAction(2);
        return this.update(dbLinkInfo, ejb);
    }

    public <T extends IDataRow> IDataResult remove(IDBLinkInfo dbLinkInfo, T ejb) {
        ejb.setAction(3);
        return this.update(dbLinkInfo, ejb);
    }

    public <T extends IDataRow> List<T> getData(IDBLinkInfo dbLinkInfo, String queryString, int maxRows, boolean noCache) throws Exception {
        if (maxRows == 0) {
            return new ArrayList();
        }
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        Query q = em.createQuery(queryString);
        if (maxRows >= 0) {
            q.setMaxResults(maxRows);
        }
        List devolver = q.getResultList();
        return devolver;
    }

    public <T extends IDataRow> List<T> getData(Query query) throws Exception {
        return query.getResultList();
    }

    public <T extends IDataRow> T refreshRow(IDBLinkInfo dbLinkInfo, T row) throws Exception {
        row = this.find(row.getClass(), dbLinkInfo, DataInfo.getIdvalue(row));
        if (6 == this.tsr.getTransactionStatus()) {
            return (T)row;
        }
        List<Field> fields = DataInfo.getLazyMembers(row.getClass());
        if (!fields.isEmpty()) {
            for (Field field : fields) {
                field.setAccessible(true);
                List obj = (List)field.get(row);
                obj.size();
            }
        }
        return (T)row;
    }

    public <T extends IDataRow> List<T> refreshAll(IDBLinkInfo dbLinkInfo, List<T> rows) throws Exception {
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        for (int i = 0; i <= rows.size(); ++i) {
            em.refresh(rows.get(i));
        }
        return rows;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Long getCount(IDBLinkInfo dbLinkInfo, String queryString, Map<String, Object> parameters) throws Exception {
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"getCount");
        String persistUnit = dbLinkInfo.getPersistUnit();
        queryString = Strings.textMerge((String)queryString, this.getQueryConstants(persistUnit));
        int pos = Strings.findString((String)"from ", (String)queryString.toLowerCase());
        int pos2 = Strings.findString((String)" order by ", (String)queryString.toLowerCase());
        queryString = pos2 <= 0 ? "select count(*) " + queryString.substring(pos) : "select count(*) " + queryString.substring(pos, pos2);
        LOGGER.debug((Object)queryString);
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        Query query = em.createQuery(queryString);
        if (parameters != null && !parameters.isEmpty()) {
            this.populateQueryParameters(query, parameters, queryString);
        }
        Long result = ((Number)query.getSingleResult()).longValue();
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Long getCount2(IDBLinkInfo dbLinkInfo, String queryString, Map<String, Object> parameters) throws Exception {
        LOGGER.debug((Object)"---------------------------");
        LOGGER.debug((Object)"getCount2");
        String persistUnit = dbLinkInfo.getPersistUnit();
        queryString = Strings.textMerge((String)queryString, this.getQueryConstants(persistUnit));
        queryString = "select count(*) from (" + queryString + ") x";
        LOGGER.debug((Object)queryString);
        List<Object> result = this.findByNativeQuery(dbLinkInfo, queryString, parameters);
        return Long.parseLong(result.get(0).toString());
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Map<String, Object> getEntityManagerProp(String persistUnit) {
        EntityManager em = this.getEntityManager(this.getEntityId(persistUnit));
        if (em == null) {
            LOGGER.info((Object)"Entity Manager Nulo");
            return null;
        }
        return em.getProperties();
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public Map<String, Object> getPersistUnitProp(String persistUnit) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            EntityManager em = this.getEntityManager(this.getEntityId(persistUnit));
            if (em.getEntityManagerFactory() == null) {
                LOGGER.info((Object)"Entity Manager Factory Nulo");
                return null;
            }
            Map result2 = em.getEntityManagerFactory().getProperties();
            result2.entrySet().forEach(e -> {
                String object = e.getValue().toString();
                result.put((String)e.getKey(), object);
            });
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public String getDataEngine(String persistentUnit) {
        String result = (String)this.getPersistUnitProp(persistentUnit).get("jbs.dbengine");
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public String getSchema(String persistentUnit) {
        String schema = (String)this.getPersistUnitProp(persistentUnit).get("hibernate.default_schema");
        return schema;
    }

    public Connection getConnection(IDBLinkInfo dbLinkInfo) {
        Connection connection = (Connection)this.getEntityManager(this.getEntityId(dbLinkInfo)).unwrap(Connection.class);
        return connection;
    }

    public Connection getConnection(IDBLinkInfo dbLinkInfo, IDBConnectFactory conn) {
        EntityManager em = this.getEntityManager(this.getEntityId(dbLinkInfo));
        Connection result = conn.getConnection(em);
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    private void populateQueryParameters(Query query, Map<String, Object> parameters, String queryString) {
        parameters.entrySet().forEach(entry -> {
            if (queryString != null) {
                if (Strings.findString((String)(":" + (String)entry.getKey()), (String)queryString) >= 0) {
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
            } else {
                query.setParameter((String)entry.getKey(), entry.getValue());
            }
        });
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    private Map<String, String> getQueryConstants(String persistUnit) {
        LOGGER.debug((Object)"getQueryConstansts()");
        HashMap<String, String> queryConstants = new HashMap<String, String>();
        String schema = (String)this.getPersistUnitProp(persistUnit).get("hibernate.default_schema");
        queryConstants.put("schema", schema);
        String schemaCat = (String)this.getPersistUnitProp("PU1").get("hibernate.default_schema");
        queryConstants.put("schemacatalog", schemaCat);
        String motordatos = (String)this.getPersistUnitProp(persistUnit).get("jbs.dbengine");
        if ("POSTGRES".equals(motordatos)) {
            queryConstants.put("true", "true");
            queryConstants.put("false", "false");
        } else {
            queryConstants.put("true", "1");
            queryConstants.put("false", "0");
        }
        if (Fn.inList((String)motordatos, (String[])new String[]{"SQLSERVER", "Microsoft SQL Server", "SYBASE"})) {
            queryConstants.put("now", "getdate()");
            queryConstants.put("today", "CONVERT(date, GETDATE())");
        } else if (Fn.inList((String)motordatos, (String[])new String[]{"ORACLE", "ORACLE8"})) {
            queryConstants.put("now", "sysdate");
            queryConstants.put("today", "TRUNC(sysdate)");
        } else if ("POSTGRES".equals(motordatos)) {
            queryConstants.put("now", "now()");
            queryConstants.put("today", "date_trunc('day', now())");
        } else if ("DB2".equals(motordatos)) {
            queryConstants.put("now", "CURRENT_TIMESTAMP");
            queryConstants.put("today", "CURRENT DATE");
        }
        return queryConstants;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public IUserSession getUserSession(String sessionId) {
        return this.sessions.getUserSession(sessionId);
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    private void setAppUser(IDataRow ejb, String appUser) {
        if (DataInfo.isFieldExist(ejb.getClass(), "appuser")) {
            ejb.setValue("appuser", (Object)appUser);
        }
    }

    private String getEntityId(IDBLinkInfo dbLinkInfo) {
        String persistUnit;
        LOGGER.debug((Object)"getEntityId()");
        if (dbLinkInfo == null) {
            persistUnit = "PU1";
        } else {
            persistUnit = dbLinkInfo.getPersistUnit();
            LOGGER.debug((Object)dbLinkInfo.getPersistUnit());
        }
        String key = persistUnit + ":";
        if (this.dbManager.getEntityIdStrategic() == 1) {
            Long threadId = Thread.currentThread().getId();
            key = key + threadId.toString();
        } else {
            String sessionId = "";
            if (dbLinkInfo != null && dbLinkInfo.getUserSession() != null) {
                sessionId = dbLinkInfo.getUserSession().getSessionId();
            }
            key = key + sessionId;
        }
        LOGGER.debug((Object)key);
        return key;
    }

    private String getEntityId(String persistUnit) {
        LOGGER.debug((Object)"getEntityId()");
        if (Strings.isNullorEmpty((String)persistUnit).booleanValue()) {
            persistUnit = "PU1";
        }
        String key = persistUnit + ":";
        return key;
    }
}

