/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.javabeanstack.data.DBLinkInfo;
import org.javabeanstack.data.DataLink;
import org.javabeanstack.data.DataNativeQuery;
import org.javabeanstack.data.IDBConnectFactory;
import org.javabeanstack.data.IDBLinkInfo;
import org.javabeanstack.data.IDataLink;
import org.javabeanstack.data.IDataNativeQuery;
import org.javabeanstack.data.IDataResult;
import org.javabeanstack.data.IDataRow;
import org.javabeanstack.data.IDataSet;
import org.javabeanstack.data.IGenericDAO;
import org.javabeanstack.exceptions.SessionError;
import org.javabeanstack.model.IAppTablesRelation;
import org.javabeanstack.security.IUserSession;
import org.javabeanstack.services.IDataService;
import org.javabeanstack.util.Dates;
import org.javabeanstack.util.Strings;

public abstract class AbstractDataLink
implements IDataLink,
Serializable {
    private String persistUnit = "PU1";
    private IUserSession userSession;

    public abstract IGenericDAO getDao();

    public abstract <T extends IGenericDAO> void setDao(T var1);

    public abstract <T extends IDataService> T getDataService();

    public String getPersistUnit() {
        return this.persistUnit;
    }

    public <T extends IDataRow> IDataResult persist(T ejb) throws SessionError {
        ejb.setAction(1);
        return this.update(ejb);
    }

    public <T extends IDataRow> IDataResult persist(List<T> ejbs) throws SessionError {
        ejbs.forEach(ejb -> ejb.setAction(1));
        return this.update(ejbs);
    }

    public <T extends IDataRow> IDataResult merge(T ejb) throws SessionError {
        ejb.setAction(2);
        return this.update(ejb);
    }

    public <T extends IDataRow> IDataResult merge(List<T> ejbs) throws SessionError {
        ejbs.forEach(ejb -> ejb.setAction(2));
        return this.update(ejbs);
    }

    public <T extends IDataRow> IDataResult remove(T ejb) throws SessionError {
        ejb.setAction(3);
        return this.update(ejb);
    }

    public <T extends IDataRow> IDataResult remove(List<T> ejbs) throws SessionError {
        ejbs.forEach(ejb -> ejb.setAction(3));
        return this.update(ejbs);
    }

    public <T extends IDataRow> IDataResult update(T ejb) throws SessionError {
        this.checkUserSession();
        IDataResult dataResult = this.getDao().update(this.getDBLinkInfo(), ejb);
        dataResult.setRowsUpdated(ejb);
        return dataResult;
    }

    public <T extends IDataRow> IDataResult update(List<T> ejbs) throws SessionError {
        this.checkUserSession();
        List<T> ejbs2 = this.getRowsChanged(ejbs);
        IDataResult dataResult = this.getDao().update(this.getDBLinkInfo(), ejbs2);
        dataResult.setRowsUpdated(ejbs);
        if (dataResult.isSuccessFul().booleanValue()) {
            this.removeDeleted(ejbs);
            dataResult.setRemoveDeleted(Boolean.TRUE);
        }
        return dataResult;
    }

    public <T extends IDataRow> IDataResult update(IDataSet dataSet) throws SessionError {
        this.checkUserSession();
        IDataSet dataSetChanged = dataSet.getChanged();
        IDataResult dataResult = this.getDao().update(this.getDBLinkInfo(), dataSetChanged);
        dataResult.setRowsUpdated(dataSet);
        if (dataResult.isSuccessFul().booleanValue()) {
            for (Map.Entry entry : dataSet.getMapListSet().entrySet()) {
                List ejbs = (List)entry.getValue();
                this.removeDeleted(ejbs);
            }
            if (dataSet.getMapDataObject() != null && !dataSet.getMapDataObject().isEmpty()) {
                dataResult.setRemoveDeleted(Boolean.TRUE);
            }
        }
        return dataResult;
    }

    public <T extends IDataRow> T find(Class<T> entityClass, Object id) throws Exception, SessionError {
        this.checkUserSession();
        return (T)this.getDao().find(entityClass, this.getDBLinkInfo(), id);
    }

    public <T extends IDataRow> T findByUk(Class<T> entityClass, T ejb) throws Exception, SessionError {
        this.checkUserSession();
        return (T)this.getDao().findByUk(entityClass, this.getDBLinkInfo(), ejb);
    }

    public <T extends IDataRow> T findByQuery(Class<T> entityClass, String queryString, Map<String, Object> parameters) throws Exception, SessionError {
        this.checkUserSession();
        parameters = this.addParams(queryString, parameters);
        return (T)this.getDao().findByQuery(entityClass, this.getDBLinkInfo(), queryString, parameters);
    }

    public <T extends IDataRow> List<T> findListByQuery(String queryString, Map<String, Object> parameters) throws Exception, SessionError {
        this.checkUserSession();
        parameters = this.addParams(queryString, parameters);
        return this.getDao().findListByQuery(this.getDBLinkInfo(), queryString, parameters);
    }

    public <T extends IDataRow> List<T> findListByQuery(String queryString, Map<String, Object> parameters, int first, int max) throws Exception, SessionError {
        this.checkUserSession();
        parameters = this.addParams(queryString, parameters);
        return this.getDao().findListByQuery(this.getDBLinkInfo(), queryString, parameters, first, max);
    }

    public <T extends IDataRow> T findByNamedQuery(String namedQuery, Map<String, Object> parameters) throws Exception, SessionError {
        this.checkUserSession();
        return (T)this.getDao().findByNamedQuery(this.getDBLinkInfo(), namedQuery, parameters);
    }

    public <T extends IDataRow> List<T> findListByNamedQuery(String namedQuery, Map<String, Object> parameters) throws Exception, SessionError {
        this.checkUserSession();
        return this.getDao().findListByNamedQuery(this.getDBLinkInfo(), namedQuery, parameters);
    }

    public <T extends IDataRow> List<T> findListByNamedQuery(String namedQuery, Map<String, Object> parameters, int first, int max) throws Exception, SessionError {
        this.checkUserSession();
        return this.getDao().findListByNamedQuery(this.getDBLinkInfo(), namedQuery, parameters, first, max);
    }

    public List<Object> findByNativeQuery(String queryString, Map<String, Object> parameters) throws Exception, SessionError {
        this.checkUserSession();
        parameters = this.addParams(queryString, parameters);
        return this.getDao().findByNativeQuery(this.getDBLinkInfo(), queryString, parameters);
    }

    public List<Object> findByNativeQuery(String queryString, Map<String, Object> parameters, int first, int max) throws Exception, SessionError {
        this.checkUserSession();
        parameters = this.addParams(queryString, parameters);
        return this.getDao().findByNativeQuery(this.getDBLinkInfo(), queryString, parameters, first, max);
    }

    public <T extends IDataRow> List<T> getData(String queryString, int maxRows, boolean noCache) throws Exception, SessionError {
        this.checkUserSession();
        return this.getDao().getData(this.getDBLinkInfo(), queryString, maxRows, noCache);
    }

    public <T extends IDataRow> List<T> getData(Query query) throws Exception, SessionError {
        this.checkUserSession();
        return this.getDao().getData(query);
    }

    public <T extends IDataRow> T refreshRow(T row) throws Exception, SessionError {
        this.checkUserSession();
        return (T)this.getDao().refreshRow(this.getDBLinkInfo(), row);
    }

    public <T extends IDataRow> List<T> refreshAll(List<T> rows) throws Exception, SessionError {
        this.checkUserSession();
        return this.getDao().refreshAll(this.getDBLinkInfo(), rows);
    }

    public Long getCount(String queryString, Map<String, Object> parameters) throws Exception, SessionError {
        this.checkUserSession();
        parameters = this.addParams(queryString, parameters);
        return this.getDao().getCount(this.getDBLinkInfo(), queryString, parameters);
    }

    public Long getCount2(String queryString, Map<String, Object> parameters) throws Exception, SessionError {
        this.checkUserSession();
        parameters = this.addParams(queryString, parameters);
        return this.getDao().getCount2(this.getDBLinkInfo(), queryString, parameters);
    }

    public Map<String, Object> getEntityManagerProp() {
        return this.getDao().getEntityManagerProp(this.persistUnit);
    }

    public Map<String, Object> getPersistUnitProp() {
        return this.getDao().getPersistUnitProp(this.persistUnit);
    }

    public IUserSession getUserSession() {
        return this.userSession;
    }

    public void setUserSession(IUserSession userSession) throws SessionError {
        this.checkUserSession();
        this.userSession = userSession;
        this.persistUnit = userSession.getPersistenceUnit();
    }

    public IDataNativeQuery newDataNativeQuery() {
        DataNativeQuery result = new DataNativeQuery();
        result.setDataLink(this);
        return result;
    }

    public String getEntitiesRelation(String entities, String typeRela, String schema) throws Exception, SessionError {
        if (Strings.isNullorEmpty((String)entities).booleanValue()) {
            return "";
        }
        if (Strings.isNullorEmpty((String)schema).booleanValue()) {
            schema = this.getDao().getSchema(this.persistUnit);
        }
        entities = entities.toLowerCase().replace("{schema}.", "");
        if (Strings.isNullorEmpty((String)typeRela).booleanValue()) {
            typeRela = "INNER";
        }
        if ("FULL LEFT RIGHT".contains(typeRela = typeRela.toUpperCase()) && !"OUTER".contains(typeRela)) {
            typeRela = typeRela + " OUTER ";
        }
        typeRela = typeRela.trim() + " ";
        String[] analizar = entities.split("\\,");
        int len = analizar.length;
        String[][] entidades = new String[len][3];
        for (int i = 0; i < analizar.length; ++i) {
            String expr = analizar[i].trim();
            int xSpace = expr.indexOf(" ");
            if (xSpace >= 0) {
                entidades[i][0] = expr.substring(0, xSpace).trim();
                entidades[i][1] = expr.substring(xSpace).trim();
                continue;
            }
            entidades[i][0] = expr;
            entidades[i][1] = expr;
        }
        String expresion = schema + "." + entidades[0][0] + " " + entidades[0][1];
        AbstractDataLink dao = !this.getPersistUnit().equals("PU1") ? new DataLink(this.getDao()) : this;
        for (int i = 0; i < analizar.length; ++i) {
            if (i + 1 == analizar.length) continue;
            String leftEntidad = entidades[i][0].toLowerCase();
            String leftAlias = entidades[i][1].toLowerCase();
            for (int j = i + 1; j < analizar.length; ++j) {
                String expr2;
                String expr1;
                String rightEntidad = entidades[j][0].toLowerCase();
                String rightAlias = entidades[j][1].toLowerCase();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("entityPK", rightEntidad);
                params.put("entityFK", leftEntidad);
                List data = dao.findListByNamedQuery("AppTablesRelation.findByEntity", params);
                if (data.isEmpty()) {
                    params.put("entityPK", leftEntidad);
                    params.put("entityFK", rightEntidad);
                    data = dao.findListByNamedQuery("AppTablesRelation.findByEntity", params);
                }
                if (data.isEmpty()) continue;
                IAppTablesRelation row = (IAppTablesRelation)data.get(0);
                if (row.getFieldsFK().equals(leftEntidad)) {
                    expr1 = row.getFieldsFK().trim();
                    expr2 = row.getFieldsPK().trim();
                } else {
                    expr1 = row.getFieldsPK().trim();
                    expr2 = row.getFieldsFK().trim();
                }
                boolean circular = false;
                String variable = " JOIN " + schema + "." + rightEntidad.trim() + " ";
                if (expresion.contains(variable)) {
                    circular = true;
                }
                switch (row.getRelationType()) {
                    case 0: {
                        typeRela = "INNER";
                        break;
                    }
                    case 1: {
                        typeRela = "LEFT OUTER";
                        break;
                    }
                    case 2: {
                        typeRela = "RIGHT OUTER";
                        break;
                    }
                    case 3: {
                        typeRela = "FULL OUTER";
                    }
                }
                if (circular) continue;
                expresion = expresion + " " + typeRela + " JOIN " + schema + "." + rightEntidad + " " + rightAlias + " ON " + leftAlias + "." + expr1.trim() + " = " + rightAlias + "." + expr2.trim() + " ";
            }
        }
        return expresion;
    }

    public Connection getConnection() {
        return this.getDao().getConnection(this.getDBLinkInfo());
    }

    public Connection getConnection(IDBConnectFactory conn) {
        return this.getDao().getConnection(this.getDBLinkInfo(), conn);
    }

    private String checkUserSession() throws SessionError {
        if (this.getUserSession() != null) {
            IUserSession sesion = this.getDao().getUserSession(this.getUserSession().getSessionId());
            if (sesion == null) {
                throw new SessionError("El identificador de la sesi\u00f3n es inv\u00e1lido");
            }
            if (sesion.getError() != null) {
                throw new SessionError(sesion.getError().getMessage());
            }
            return this.getUserSession().getSessionId();
        }
        return "";
    }

    private Map<String, Object> addParams(String queryString, Map<String, Object> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        if (Strings.findString((String)":true", (String)queryString.toLowerCase()) >= 0) {
            parameters.put("true", true);
        }
        if (Strings.findString((String)":false", (String)queryString.toLowerCase()) >= 0) {
            parameters.put("false", false);
        }
        if (Strings.findString((String)":idempresa", (String)queryString.toLowerCase()) >= 0 && this.getUserSession() != null) {
            parameters.put("idempresa", this.getUserSession().getIdEmpresa());
        }
        if (Strings.findString((String)":idcompany", (String)queryString.toLowerCase()) >= 0 && this.getUserSession() != null) {
            parameters.put("idcompany", this.getUserSession().getIdCompany());
        }
        if (Strings.findString((String)":today", (String)queryString.toLowerCase()) >= 0) {
            parameters.put("today", Dates.today());
        }
        if (Strings.findString((String)":now", (String)queryString.toLowerCase()) >= 0) {
            parameters.put("now", Dates.now());
        }
        return parameters;
    }

    private <T extends IDataRow> List<T> getRowsChanged(List<T> dataRows) {
        LinkedList<T> dataRowsChanged = new LinkedList<T>();
        for (int i = 0; i < dataRows.size(); ++i) {
            if (((IDataRow)dataRows.get(i)).getAction() == 0) continue;
            dataRowsChanged.add(dataRows.get(i));
        }
        return dataRowsChanged;
    }

    private <T extends IDataRow> void removeDeleted(List<T> dataRows) {
        Iterator<T> i = dataRows.iterator();
        while (i.hasNext()) {
            IDataRow r = (IDataRow)i.next();
            if (r.getAction() != 3) continue;
            i.remove();
        }
    }

    private IDBLinkInfo getDBLinkInfo() {
        DBLinkInfo dbInfo = new DBLinkInfo();
        dbInfo.setUserSession(this.userSession);
        return dbInfo;
    }
}

