/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.javabeanstack.data.DBFilterElement;
import org.javabeanstack.data.DataInfo;
import org.javabeanstack.data.IDBFilter;
import org.javabeanstack.data.IDBFilterElement;
import org.javabeanstack.data.IDataRow;
import org.javabeanstack.util.Strings;

public class DBFilter
implements IDBFilter<DBFilterElement> {
    private final List<DBFilterElement> filter = new ArrayList<DBFilterElement>();
    private String modelPackagePath = "";

    public List<DBFilterElement> getFilter() {
        return this.filter;
    }

    public String getFilterExpr(Integer element) {
        return this.getFilterExpr(element, "");
    }

    public String getFilterExpr(Integer element, Integer group) {
        return this.getFilterExpr(element, group, "");
    }

    public String getFilterExpr(Integer element, String alias) {
        return this.getFilterExpr(element, null, alias);
    }

    public String getFilterExpr(Integer element, Integer group, String alias) {
        if (element == null || element >= this.filter.size()) {
            return "";
        }
        if (!Strings.isNullorEmpty((String)alias).booleanValue()) {
            alias = alias + ".";
        }
        String result = "";
        String field = this.filter.get(element).getFieldName();
        Object value = this.filter.get(element).getFieldValue();
        Integer group1 = this.filter.get(element).getFieldGroup();
        if (group != null && !Objects.equals(group, group1)) {
            return result;
        }
        if (value instanceof String) {
            result = "(" + alias + field + "='" + value + "'" + ")";
        } else if (value instanceof List) {
            if (((List)value).isEmpty()) {
                result = "";
            } else {
                result = "(" + alias + field + " IN(";
                String separador = "";
                for (Object e : (List)value) {
                    if (e instanceof String) {
                        result = result + separador + "'" + e.toString() + "'";
                        separador = ",";
                        continue;
                    }
                    result = result + separador + e.toString();
                    separador = ",";
                }
                result = result + "))";
            }
        } else {
            result = "(" + alias + field + "=" + value + ")";
        }
        return result;
    }

    public String getAllFilterExpr() {
        return this.getAllFilterExpr(null, "");
    }

    public String getAllFilterExpr(Integer group) {
        return this.getAllFilterExpr(group, "");
    }

    public String getAllFilterExpr(String alias) {
        return this.getAllFilterExpr(null, alias);
    }

    public String getAllFilterExpr(Integer group, String alias) {
        String result = "";
        String separador = "";
        for (int i = 0; i < this.filter.size(); ++i) {
            String expr = this.getFilterExpr(i, group, alias);
            if (expr.isEmpty()) continue;
            result = result + separador + expr;
            separador = " and ";
        }
        return result;
    }

    public void addFilter(String fieldName, Object fieldValue, Integer group) {
        DBFilterElement element = new DBFilterElement();
        element.setFieldName(fieldName);
        element.setFieldValue(fieldValue);
        element.setFieldGroup(group);
        this.filter.add(element);
    }

    public <T extends IDataRow> String getFilterExpr(Class<T> clazz, String alias) {
        String result = "";
        String separador = "";
        int c = 0;
        for (IDBFilterElement iDBFilterElement : this.filter) {
            String expr;
            if (DataInfo.isFieldExist(clazz, iDBFilterElement.getFieldName()) && !(expr = this.getFilterExpr((Integer)c, alias)).isEmpty()) {
                result = result + separador + expr;
                separador = " and ";
            }
            ++c;
        }
        return result;
    }

    public String getModelPackagePath() {
        return this.modelPackagePath;
    }

    public void setModelPackagePath(String modelPath) {
        this.modelPackagePath = modelPath;
    }
}

