/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.SessionContext;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.javabeanstack.data.IDBManager;
import org.javabeanstack.data.IDBManagerLocal;
import org.javabeanstack.data.IDBManagerRemote;
import org.javabeanstack.error.ErrorManager;
import org.javabeanstack.util.Dates;

@Startup
@Lock(value=LockType.READ)
public class DBManager
implements IDBManager,
IDBManagerLocal,
IDBManagerRemote {
    private static final Logger LOGGER = Logger.getLogger(DBManager.class);
    private int entityIdStrategic = 2;
    private Date lastPurge = new Date();
    private final Map<String, Data> entityManagers = new HashMap<String, Data>();
    @Resource
    SessionContext context;

    public int getEntityIdStrategic() {
        return this.entityIdStrategic;
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public EntityManager getEntityManager(String key) {
        try {
            EntityManager em;
            if (key == null || "".equals(key)) {
                return null;
            }
            if (this.entityManagers.containsKey(key)) {
                em = this.entityManagers.get((Object)key).em;
                this.entityManagers.get((Object)key).lastRef = Dates.now();
                LOGGER.debug((Object)("EntityManager ya existe: " + key));
            } else {
                em = this.createEntityManager(key);
            }
            this.purgeEntityManager();
            return em;
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
            return null;
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    @Lock(value=LockType.WRITE)
    public EntityManager createEntityManager(String key) {
        try {
            String persistentUnit = key.substring(0, key.indexOf(":")).toLowerCase();
            EntityManager em = (EntityManager)this.context.lookup("java:comp/env/persistence/" + persistentUnit);
            Data data = new Data();
            data.em = em;
            this.entityManagers.put(key, data);
            LOGGER.debug((Object)("--------- Se ha creado un nuevo EntityManager --------- " + key));
            return em;
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
            return null;
        }
    }

    protected void purgeEntityManager() {
        LOGGER.debug((Object)("purgeEntityManager() " + this.lastPurge));
        Date now = new Date();
        if (!this.lastPurge.before(DateUtils.addMinutes((Date)now, (int)-5))) {
            return;
        }
        now = DateUtils.addMinutes((Date)Dates.now(), (int)-5);
        Iterator<Map.Entry<String, Data>> it = this.entityManagers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Data> entry = it.next();
            if (!entry.getValue().lastRef.before(now)) continue;
            LOGGER.debug((Object)("Se elimino entityManager: " + entry.getKey()));
            it.remove();
        }
        this.lastPurge = new Date();
        LOGGER.debug((Object)("Se proceso purgeEntityManager " + this.lastPurge));
    }

    @Lock(value=LockType.WRITE)
    public void rollBack() {
        this.context.setRollbackOnly();
    }

    class Data {
        EntityManager em;
        Date lastRef = Dates.now();

        Data() {
        }
    }
}

