/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javabeanstack.data.IDataExpression;
import org.javabeanstack.util.Fn;
import org.javabeanstack.util.Strings;

public class DataExpression
implements IDataExpression {
    private List<ElementExpr> exprList = new ArrayList<ElementExpr>();
    private boolean openparenthesis = false;
    private Map<String, Object> sentenceParams = new HashMap<String, Object>();

    public final List<ElementExpr> getExpressionList() {
        return this.exprList;
    }

    public Map<String, Object> getSentenceParams() {
        return this.sentenceParams;
    }

    public void setSentenceParams(Map<String, Object> sentenceParams) {
        this.sentenceParams = sentenceParams;
    }

    public void addSentenceParam(String key, Object value) {
        this.sentenceParams.put(key, value);
    }

    public void clearExpressions() {
        this.exprList.clear();
    }

    public void openParenthesis() {
        ElementExpr element = new ElementExpr("", null, "(");
        this.exprList.add(element);
        this.openparenthesis = true;
    }

    public void closeParenthesis() {
        ElementExpr element = new ElementExpr("", null, ")");
        this.exprList.add(element);
        this.openparenthesis = false;
    }

    public void addOperator(String operator) {
        ElementExpr element = new ElementExpr("", null, operator);
        this.exprList.add(element);
    }

    public void addOperator(String operator, String group) {
        ElementExpr element = new ElementExpr("", null, operator, group);
        this.exprList.add(element);
    }

    public void addExpression(String expr, Map<String, String> keyParams) {
        this.addExpression(expr, keyParams, null);
    }

    public void addExpression(String expr, Map<String, String> keyParams, String operator) {
        ElementExpr element = new ElementExpr(expr, keyParams, operator);
        if (this.openparenthesis && Fn.inList((String)element.operador.toLowerCase(), (String[])new String[]{"and", "or"})) {
            element.operador = "";
        }
        this.exprList.add(element);
        this.openparenthesis = false;
    }

    public void addExpression(String expr, Map<String, String> keyParams, String operator, String group) {
        ElementExpr element = new ElementExpr(expr, keyParams, operator, group);
        if (this.openparenthesis && Fn.inList((String)element.operador.toLowerCase(), (String[])new String[]{"and", "or"})) {
            element.operador = "";
        }
        this.exprList.add(element);
        this.openparenthesis = false;
    }

    public void addExpression(String expr, Object ... keyParamList) {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        if (keyParamList != null && keyParamList.length >= 1) {
            do {
                String expr1 = keyParamList[i].toString();
                String expr2 = i + 1 < keyParamList.length ? keyParamList[i + 1].toString() : null;
                params.put(expr1, expr2);
            } while ((i += 2) < keyParamList.length);
        }
        this.addExpression(expr, params);
    }

    public void addExpressions(IDataExpression dataExpression) {
        ((DataExpression)dataExpression).getExpressionList().forEach(expr -> this.exprList.add((ElementExpr)expr));
        dataExpression.getSentenceParams().entrySet().forEach(element -> this.getSentenceParams().put((String)element.getKey(), element.getValue()));
    }

    public String getSentence() {
        return this.getSentence("");
    }

    public String getSentence(String group) {
        String devolver = "";
        String linefeed = "";
        for (int i = 0; i < this.exprList.size(); ++i) {
            ElementExpr e = this.exprList.get(i);
            if (!group.isEmpty() && !((String)Fn.nvl((Object)e.grupo, (Object)"")).equals(group)) continue;
            if (i == 0 && Fn.inList((String)e.operador.toLowerCase(), (String[])new String[]{"and", "or"})) {
                e.operador = "";
            }
            String expr = e.expresion;
            if (e.params != null) {
                expr = Strings.textMerge((String)expr, e.params);
            }
            if (!Strings.isNullorEmpty((String)e.expresion).booleanValue()) {
                expr = " (" + expr + ") ";
            }
            devolver = devolver + linefeed + e.operador + expr;
            linefeed = "\n";
        }
        return devolver;
    }

    public IDataExpression removeExpression(int elementNumber) {
        DataExpression dataExpr = new DataExpression();
        for (int i = 0; i < this.exprList.size(); ++i) {
            if (i == elementNumber) continue;
            ElementExpr element = this.exprList.get(i);
            dataExpr.addExpression(element.expresion, element.params, element.operador, element.grupo);
        }
        return dataExpr;
    }

    public IDataExpression removeExpression(String group) {
        DataExpression dataExpr = new DataExpression();
        for (ElementExpr element : this.exprList) {
            if (element.grupo.equalsIgnoreCase(group)) continue;
            dataExpr.addExpression(element.expresion, element.params, element.operador, element.grupo);
        }
        return dataExpr;
    }

    public final class ElementExpr {
        String operador = "and";
        String expresion;
        String grupo = "";
        Map<String, String> params;

        public ElementExpr(String expr, Map<String, String> params) {
            this.expresion = expr;
            this.params = params;
        }

        public ElementExpr(String expr, Map<String, String> params, String operator) {
            this.expresion = expr;
            this.params = params;
            if (!Strings.isNullorEmpty((String)operator).booleanValue()) {
                this.operador = operator;
            }
        }

        public ElementExpr(String expr, Map<String, String> params, String operator, String group) {
            this.expresion = expr;
            this.params = params;
            this.grupo = group;
            if (!Strings.isNullorEmpty((String)operator).booleanValue()) {
                this.operador = operator;
            }
        }
    }
}

