/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.javabeanstack.data.IDataRow;
import org.javabeanstack.error.ErrorManager;
import org.javabeanstack.util.Strings;

public class DataInfo {
    private static final Logger LOGGER = Logger.getLogger(DataInfo.class);

    public static <T extends IDataRow> boolean isPrimaryKey(Class<T> classType, String fieldname) {
        try {
            Field field = DataInfo.getDeclaredField(classType, fieldname);
            Id id = field.getAnnotation(Id.class);
            return id != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T extends IDataRow> boolean isUniqueKey(Class<T> classType, String fieldname) {
        try {
            String[] fields = DataInfo.getUniqueFields(classType);
            if (fields == null) {
                return false;
            }
            for (String field : fields) {
                if (!field.toLowerCase().equals(fieldname.toLowerCase())) continue;
                return true;
            }
            return false;
        }
        catch (Exception exp) {
            return false;
        }
    }

    public static <T extends IDataRow> boolean isForeignKey(Class<T> classType, String fieldname) {
        try {
            Field field = DataInfo.getDeclaredField(classType, fieldname);
            JoinColumn idforeignkey = field.getAnnotation(JoinColumn.class);
            return idforeignkey != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T extends IDataRow> boolean isFieldExist(Class<T> classType, String fieldname) {
        try {
            Field field = DataInfo.getDeclaredField(classType, fieldname);
            if (field != null) {
                return true;
            }
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
        return false;
    }

    public static <T extends IDataRow> boolean isLazyFetch(Class<T> classType, String fieldname) {
        try {
            Field field = DataInfo.getDeclaredField(classType, fieldname);
            OneToMany annotation = field.getAnnotation(OneToMany.class);
            return annotation.fetch() == FetchType.LAZY;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T extends IDataRow> List<Field> getLazyMembers(Class<T> classType) {
        try {
            Field[] fields = classType.getDeclaredFields();
            ArrayList<Field> lazyFields = new ArrayList<Field>();
            for (Field field : fields) {
                OneToMany annotation = field.getAnnotation(OneToMany.class);
                if (annotation == null || annotation.fetch() != FetchType.LAZY) continue;
                lazyFields.add(field);
            }
            return lazyFields;
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
            return null;
        }
    }

    public static <T extends IDataRow> String getTableName(Class<T> classType) {
        try {
            Table entity = classType.getAnnotation(Table.class);
            return entity.name();
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
            return "";
        }
    }

    public static String createQueryUkCommand(IDataRow ejb) {
        try {
            String command = "select o from " + ejb.getClass().getSimpleName() + " o ";
            if (!ejb.getIdFunctionFind().equals("")) {
                command = command + " where " + "o." + DataInfo.getIdFieldName(ejb.getClass()) + " = :" + ejb.getIdFunctionFind();
                return command;
            }
            String uniqueFilter = "";
            String separador = "";
            String[] uniqueList = DataInfo.getUniqueFields(ejb.getClass());
            if (uniqueList == null) {
                return null;
            }
            for (String fieldName : uniqueList) {
                uniqueFilter = uniqueFilter + separador + " o." + fieldName + " = :" + fieldName;
                separador = " and ";
            }
            command = command + " where " + uniqueFilter;
            return command;
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
            return null;
        }
    }

    public static <T extends IDataRow> String getIdFieldName(Class<T> classType) {
        try {
            Field[] fields;
            for (Field field : fields = classType.getDeclaredFields()) {
                Id id = field.getAnnotation(Id.class);
                if (id == null) continue;
                return field.getName();
            }
            return null;
        }
        catch (SecurityException ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
            return null;
        }
    }

    public static <T extends IDataRow> String[] getUniqueFields(Class<T> classType) {
        try {
            String[] uniqueConst = classType.getAnnotation(Table.class).uniqueConstraints()[0].columnNames();
            if (uniqueConst != null) {
                return uniqueConst;
            }
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
        return null;
    }

    public static Object getIdvalue(IDataRow ejb) {
        try {
            String field = DataInfo.getIdFieldName(ejb.getClass());
            if (field != null) {
                return ejb.getValue(field);
            }
            return null;
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
            return null;
        }
    }

    public static boolean setIdvalue(IDataRow ejb, Object value) {
        try {
            String field = DataInfo.getIdFieldName(ejb.getClass());
            if (field != null) {
                ejb.setValue(field, value);
                return true;
            }
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
        return false;
    }

    public static <T extends IDataRow> Object getDefaultValue(T ejb, String fieldname) {
        Object valor = null;
        Class<?> classObj = ejb.getClass();
        try {
            Field field = DataInfo.getDeclaredField(classObj, fieldname + "_default");
            field.setAccessible(true);
            valor = field.get(ejb);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
        return valor;
    }

    public static <T extends IDataRow> void setDefaultValue(T ejb, String fieldname) {
        Class<?> classObj = ejb.getClass();
        try {
            Field field = DataInfo.getDeclaredField(classObj, fieldname);
            field.setAccessible(true);
            Object valor = DataInfo.getDefaultValue(ejb, fieldname);
            if (valor != null) {
                field.set(ejb, valor);
                if (ejb.getAction() == 0) {
                    ejb.setAction(2);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
    }

    public static <T extends IDataRow> T getObjFk(T ejb, String objrelaName) {
        try {
            Field field;
            try {
                field = DataInfo.getDeclaredField(ejb.getClass(), objrelaName.toLowerCase());
            }
            catch (Exception ex) {
                field = null;
            }
            if (field == null) {
                field = DataInfo.getDeclaredField(ejb.getClass(), "id" + objrelaName.toLowerCase());
            }
            field.setAccessible(true);
            Object obj = field.get(ejb);
            if (obj instanceof IDataRow) {
                return (T)((IDataRow)obj);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
            return null;
        }
    }

    public static Field getDeclaredField(Class classType, String fieldname) {
        Field[] fields;
        Field field = null;
        try {
            if (fieldname.contains(".")) {
                String className = fieldname.substring(0, Strings.findString((String)".", (String)fieldname));
                Class<?> classMember = classType.getDeclaredField(className).getType();
                fieldname = fieldname.substring(Strings.findString((String)".", (String)fieldname) + 1);
                field = DataInfo.getDeclaredField(classMember, fieldname);
            } else {
                field = classType.getDeclaredField(fieldname);
            }
        }
        catch (NoSuchFieldException ex) {
            field = null;
        }
        catch (SecurityException ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
        if (field != null) {
            return field;
        }
        for (Field field1 : fields = classType.getDeclaredFields()) {
            if (!field1.getName().toLowerCase().equals(fieldname.toLowerCase())) continue;
            return field1;
        }
        return null;
    }

    public static Field[] getDeclaredFields(Class classType) {
        Field[] fields;
        try {
            fields = classType.getDeclaredFields();
        }
        catch (SecurityException ex) {
            return null;
        }
        return fields;
    }

    public static Class getFieldType(Class classType, String fieldname) {
        Class cls = null;
        try {
            if (fieldname.contains(".")) {
                String className = fieldname.substring(0, Strings.findString((String)".", (String)fieldname));
                Class<?> classMember = classType.getDeclaredField(className).getType();
                fieldname = fieldname.substring(Strings.findString((String)".", (String)fieldname) + 1);
                cls = DataInfo.getFieldType(classMember, fieldname);
            } else {
                cls = DataInfo.getDeclaredField(classType, fieldname).getType();
            }
        }
        catch (NoSuchFieldException ex) {
            cls = null;
        }
        catch (SecurityException ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
        return cls;
    }

    public static Object getFieldValue(Object ejb, String fieldname) {
        Object value;
        try {
            if (fieldname.contains(".")) {
                String memberName = fieldname.substring(0, Strings.findString((String)".", (String)fieldname));
                fieldname = fieldname.substring(Strings.findString((String)".", (String)fieldname) + 1);
                Field field = DataInfo.getDeclaredField(ejb.getClass(), memberName);
                field.setAccessible(true);
                Object parentValue = field.get(ejb);
                value = DataInfo.getFieldValue(parentValue, fieldname);
            } else {
                Field field = DataInfo.getDeclaredField(ejb.getClass(), fieldname);
                field.setAccessible(true);
                value = field.get(ejb);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            return null;
        }
        return value;
    }
}

