/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.javabeanstack.data.DataQueryModel;
import org.javabeanstack.data.IDBFilter;
import org.javabeanstack.data.IDataExpression;
import org.javabeanstack.data.IDataLink;
import org.javabeanstack.data.IDataNativeQuery;
import org.javabeanstack.data.IDataQueryModel;
import org.javabeanstack.error.ErrorManager;
import org.javabeanstack.exceptions.SessionError;
import org.javabeanstack.util.Dates;
import org.javabeanstack.util.Fn;
import org.javabeanstack.util.Strings;

public class DataNativeQuery
implements IDataNativeQuery {
    private static final Logger LOGGER = Logger.getLogger(DataNativeQuery.class);
    private boolean queryCreated;
    private String querySentence;
    private String columnExpr;
    private String[] columnList;
    private String entityExpr;
    private String fromEntity;
    private String[] entityList;
    private String filterExpr;
    private String[] filterExprList;
    private String orderExpr;
    private String[] orderList;
    private String groupExpr;
    private String[] groupList;
    private String filterGroupExpr;
    private String[] filterGroupList;
    private final LinkedList<JoinParam> joinParams = new LinkedList();
    private Map<String, Object> queryParams = new HashMap<String, Object>();
    private IDataLink dataLink;
    private final Map<String, String> queryConstants = new HashMap<String, String>();
    private int first;
    private int maxResult;
    private IDataNativeQuery subQueryFrom;
    private String subQueryFromSentence;
    private String subQueryAlias;
    private boolean applyDBQueryFilter = true;

    public IDataNativeQuery select(String columns) {
        this.columnExpr = columns;
        this.queryCreated = false;
        this.columnList = null;
        this.columnList = DataNativeQuery.setColumnLabel(this.columnExpr);
        return this;
    }

    public IDataNativeQuery from(String entities) {
        this.entityExpr = entities;
        this.fromEntity = entities;
        this.subQueryAlias = null;
        this.subQueryFrom = null;
        this.entityList = null;
        this.queryCreated = false;
        this.joinParams.clear();
        this.filterExpr = null;
        this.filterExprList = null;
        this.orderExpr = null;
        this.orderList = null;
        this.groupExpr = null;
        this.groupList = null;
        this.filterGroupExpr = null;
        this.filterGroupList = null;
        return this;
    }

    public IDataNativeQuery from(IDataNativeQuery query, String alias) {
        this.subQueryAlias = alias;
        this.subQueryFrom = query;
        this.entityExpr = "";
        this.entityList = null;
        this.fromEntity = null;
        this.joinParams.clear();
        this.queryCreated = false;
        return this;
    }

    public IDataNativeQuery from(String query, String alias) {
        this.subQueryAlias = alias;
        this.subQueryFromSentence = query;
        this.entityExpr = "";
        this.entityList = null;
        this.fromEntity = null;
        this.joinParams.clear();
        this.queryCreated = false;
        return this;
    }

    public IDataNativeQuery join(String entity, String joinExpr) {
        this.joinParams.add(new JoinParam(entity, joinExpr, "INNER JOIN"));
        this.queryCreated = false;
        return this;
    }

    public IDataNativeQuery join(IDataNativeQuery subquery, String alias, String joinExpr) {
        this.joinParams.add(new JoinParam(subquery, alias, joinExpr, "INNER JOIN"));
        this.queryCreated = false;
        return this;
    }

    public IDataNativeQuery leftJoin(String entity, String joinExpr) {
        this.joinParams.add(new JoinParam(entity, joinExpr, "LEFT OUTER JOIN"));
        this.queryCreated = false;
        return this;
    }

    public IDataNativeQuery where(String filterExpr) {
        this.filterExpr = filterExpr;
        this.filterExpr = this.filterExpr + this.getDBFilterExpr();
        this.filterExprList = null;
        this.queryCreated = false;
        return this;
    }

    public IDataNativeQuery where(String filterExpr, Map<String, Object> params) {
        this.filterExpr = filterExpr;
        this.filterExpr = this.filterExpr + this.getDBFilterExpr();
        this.filterExprList = null;
        this.queryCreated = false;
        this.addParams(params);
        return this;
    }

    public IDataNativeQuery where(IDataExpression dataExpr) {
        this.filterExpr = dataExpr.getSentence();
        this.filterExpr = this.filterExpr + this.getDBFilterExpr();
        this.filterExprList = null;
        this.queryCreated = false;
        if (!dataExpr.getSentenceParams().isEmpty()) {
            this.addParams(dataExpr.getSentenceParams());
        }
        return this;
    }

    public IDataNativeQuery where(IDataExpression dataExpr, Map<String, Object> params) {
        this.filterExpr = dataExpr.getSentence();
        this.filterExpr = this.filterExpr + this.getDBFilterExpr();
        this.filterExprList = null;
        this.queryCreated = false;
        this.addParams(params);
        return this;
    }

    private String getDBFilterExpr() {
        String result = "";
        if (this.getApplyDBFilter() && this.getDataLink() != null && this.getDataLink().getUserSession() != null && !this.getDataLink().getPersistUnit().equals("PU1")) {
            String operador = Strings.isNullorEmpty((String)this.filterExpr) != false ? "" : " and ";
            try {
                String filter;
                String entityExp = this.getEntityList()[0];
                int pos = entityExp.indexOf(" ") > 0 ? entityExp.indexOf(" ") : entityExp.length();
                String entity = entityExp.substring(0, pos);
                String entityAlias = Strings.substr((String)entityExp, (int)(pos + 1));
                IDBFilter dbFilter = this.getDataLink().getUserSession().getDBFilter();
                Class clazz = DataNativeQuery.getClassModel(dbFilter.getModelPackagePath(), entity);
                if (clazz != null && !Strings.isNullorEmpty((String)(filter = dbFilter.getFilterExpr(clazz, entityAlias.trim()))).booleanValue()) {
                    result = operador + filter;
                }
            }
            catch (Exception exp) {
                result = "";
            }
        }
        return result;
    }

    public static Class getClassModel(String packagePath, String entity) {
        String[] partes;
        String className = "";
        for (String parte : partes = entity.split("_")) {
            className = className + Strings.Capitalize((String)parte).trim();
        }
        if (packagePath == null) {
            return null;
        }
        String[] path = packagePath.split(";");
        Class<?> clazz = null;
        for (String packages : path) {
            String classPath = packages.trim() + "." + className;
            try {
                clazz = Class.forName(classPath);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return clazz;
    }

    public IDataNativeQuery orderBy(String columnOrder) {
        this.orderExpr = columnOrder;
        this.queryCreated = false;
        this.orderList = DataNativeQuery.setColumnLabel(this.orderExpr);
        return this;
    }

    public IDataNativeQuery groupBy(String columnGroup) {
        this.groupExpr = columnGroup;
        this.groupList = DataNativeQuery.setColumnLabel(this.groupExpr);
        this.queryCreated = false;
        return this;
    }

    public IDataNativeQuery having(String filterExpr) {
        this.filterGroupExpr = filterExpr;
        this.queryCreated = false;
        return this;
    }

    public IDataNativeQuery addParam(String key, Object value) {
        this.queryParams.put(key, value);
        return this;
    }

    public IDataNativeQuery addParams(Map<String, Object> params) {
        this.queryParams = params;
        return this;
    }

    public IDataNativeQuery setQueryParams(Map<String, Object> params) {
        this.queryParams = params;
        return this;
    }

    public void createQuery() {
        this.querySentence = "SELECT " + this.columnExpr + " \r\n";
        String fromExpr = this.getFromExpr();
        this.querySentence = this.querySentence + " FROM " + fromExpr + "\r\n";
        if (Strings.isNullorEmpty((String)this.filterExpr).booleanValue()) {
            this.filterExpr = this.getDBFilterExpr();
        }
        if (!Strings.isNullorEmpty((String)this.filterExpr).booleanValue()) {
            this.querySentence = this.querySentence + " WHERE " + this.filterExpr + " \r\n";
        }
        if (!Strings.isNullorEmpty((String)this.groupExpr).booleanValue()) {
            this.querySentence = this.querySentence + " GROUP BY " + this.groupExpr + " \r\n";
        }
        if (!Strings.isNullorEmpty((String)this.filterGroupExpr).booleanValue()) {
            this.querySentence = this.querySentence + " HAVING " + this.filterGroupExpr + " \r\n";
        }
        if (!Strings.isNullorEmpty((String)this.orderExpr).booleanValue()) {
            this.querySentence = this.querySentence + " ORDER BY " + this.orderExpr + " \r\n";
        }
        this.setQueryConstants();
        this.querySentence = Strings.textMerge((String)this.querySentence, this.queryConstants);
        this.setDefaultParams();
        this.queryCreated = true;
    }

    public final String getFromExpr() {
        String fromExpr = "";
        if (this.subQueryFrom != null) {
            this.subQueryFrom.createQuery();
            String subQuerySentence = this.subQueryFrom.getQuerySentence();
            fromExpr = "(" + subQuerySentence + ") " + this.subQueryAlias + " ";
            fromExpr = fromExpr + this.getJoinExpr();
            return fromExpr;
        }
        if (!Strings.isNullorEmpty((String)this.subQueryFromSentence).booleanValue()) {
            String subQuerySentence = this.subQueryFromSentence;
            fromExpr = "(" + subQuerySentence + ") " + this.subQueryAlias + " ";
            fromExpr = fromExpr + this.getJoinExpr();
            return fromExpr;
        }
        String schema = this.dataLink.getDao().getSchema(this.dataLink.getPersistUnit());
        String joinEntityExpr = this.getJoinEntityExpr();
        this.entityExpr = this.fromEntity + (String)Fn.iif((boolean)joinEntityExpr.isEmpty(), (Object)"", (Object)", ");
        if (this.joinParams.isEmpty() && this.getEntityList().length > 1) {
            try {
                fromExpr = this.dataLink.getEntitiesRelation(this.entityExpr, "", schema);
            }
            catch (Exception exp) {
                ErrorManager.showError((Exception)exp, (Logger)LOGGER);
            }
        } else if (!this.joinParams.isEmpty()) {
            fromExpr = this.getEntityWithSchema(this.fromEntity);
            fromExpr = fromExpr + this.getJoinExpr();
        } else {
            fromExpr = this.getEntityWithSchema(this.fromEntity);
        }
        return fromExpr;
    }

    protected final String getJoinExpr() {
        String result = "";
        for (JoinParam param : this.joinParams) {
            if (param.joinSubquery != null) {
                param.joinSubquery.createQuery();
                result = result + " \r\n" + param.joinType + " (" + param.joinSubquery.getQuerySentence() + ") " + param.joinSubqueryAlias + " on " + param.joinExpr;
                continue;
            }
            String entity = this.getEntityWithSchema(param.joinEntity);
            result = result + " \r\n" + param.joinType + " " + entity + " on " + param.joinExpr;
        }
        return result;
    }

    protected final String getEntityWithSchema(String entity) {
        if (Strings.occurs((String)".", (String)entity) == 0) {
            entity = "{schema}." + entity;
        }
        return entity;
    }

    public String createQuerySentence() {
        if (this.queryCreated) {
            return this.querySentence;
        }
        this.createQuery();
        return this.querySentence;
    }

    protected void setDefaultParams() {
        if (Strings.findString((String)":true", (String)this.querySentence.toLowerCase()) >= 0) {
            this.queryParams.put("true", true);
        }
        if (Strings.findString((String)":false", (String)this.querySentence.toLowerCase()) >= 0) {
            this.queryParams.put("false", false);
        }
        if (!this.queryParams.containsKey("idempresa") && Strings.findString((String)":idempresa", (String)this.querySentence.toLowerCase()) >= 0 && this.getDataLink().getUserSession() != null) {
            this.queryParams.put("idempresa", this.getDataLink().getUserSession().getIdEmpresa());
        }
        if (!this.queryParams.containsKey("idcompany") && Strings.findString((String)":idcompany", (String)this.querySentence.toLowerCase()) >= 0 && this.getDataLink().getUserSession() != null) {
            this.queryParams.put("idcompany", this.getDataLink().getUserSession().getIdCompany());
        }
        if (!this.queryParams.containsKey("today") && Strings.findString((String)":today", (String)this.querySentence.toLowerCase()) >= 0) {
            this.queryParams.put("today", Dates.today());
        }
        if (!this.queryParams.containsKey("now") && Strings.findString((String)":now", (String)this.querySentence.toLowerCase()) >= 0) {
            this.queryParams.put("now", Dates.now());
        }
    }

    private void setQueryConstants() {
        String schema = (String)this.dataLink.getPersistUnitProp().get("hibernate.default_schema");
        this.queryConstants.put("schema", schema);
        String schemaCat = (String)this.dataLink.getDao().getPersistUnitProp("PU1").get("hibernate.default_schema");
        this.queryConstants.put("schemacatalog", schemaCat);
        String motordatos = (String)this.dataLink.getPersistUnitProp().get("jbs.dbengine");
        if ("POSTGRES".equals(motordatos)) {
            this.queryConstants.put("true", "true");
            this.queryConstants.put("false", "false");
        } else {
            this.queryConstants.put("true", "1");
            this.queryConstants.put("false", "0");
        }
        if (Fn.inList((String)motordatos, (String[])new String[]{"SQLSERVER", "Microsoft SQL Server", "SYBASE"})) {
            this.queryConstants.put("now", "getdate()");
            this.queryConstants.put("today", "CONVERT(date, GETDATE())");
        } else if (Fn.inList((String)motordatos, (String[])new String[]{"ORACLE", "ORACLE8"})) {
            this.queryConstants.put("now", "sysdate");
            this.queryConstants.put("today", "TRUNC(sysdate)");
        } else if ("POSTGRES".equals(motordatos)) {
            this.queryConstants.put("now", "now()");
            this.queryConstants.put("today", "date_trunc('day', now())");
        } else if ("DB2".equals(motordatos)) {
            this.queryConstants.put("now", "CURRENT_TIMESTAMP");
            this.queryConstants.put("today", "CURRENT DATE");
        }
    }

    public List<IDataQueryModel> execQuery() throws SessionError {
        return this.execQuery(this.dataLink);
    }

    public List<IDataQueryModel> execQuery(int first, int maxResult) throws SessionError {
        this.first = first;
        this.maxResult = maxResult;
        return this.execQuery(this.dataLink);
    }

    public List<IDataQueryModel> execQuery(IDataLink dataLink) throws SessionError {
        List<IDataQueryModel> result = new ArrayList<IDataQueryModel>();
        try {
            if (!this.queryCreated) {
                this.createQuery();
            }
            List list = this.first > 0 || this.maxResult > 0 ? dataLink.findByNativeQuery(this.querySentence, this.queryParams, this.first, this.maxResult) : dataLink.findByNativeQuery(this.querySentence, this.queryParams);
            result = DataNativeQuery.converToNativeQuery(list, this.columnExpr);
            this.first = 0;
            this.maxResult = 0;
        }
        catch (SessionError ex) {
            throw new SessionError("La sesi\u00f3n expir\u00f3 o es inv\u00e1lida");
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)Logger.getLogger(DataNativeQuery.class));
        }
        return result;
    }

    public static final List<IDataQueryModel> converToNativeQuery(List<Object> source, String columns) {
        if (source == null) {
            return null;
        }
        return DataQueryModel.convertToDataQueryModel(source, columns);
    }

    protected static String[] setColumnLabel(String columns) {
        String regex = "\\(.*?\\)";
        String expr = columns;
        expr = Strings.varReplace((String)expr, (String)"()");
        expr = expr.replaceAll(regex, "()");
        String[] matrix = DataNativeQuery.convertToMatrix(expr, ",");
        for (int i = 0; i < matrix.length; ++i) {
            int pos = matrix[i].toLowerCase().indexOf(" as ");
            if (pos >= 0) {
                matrix[i] = matrix[i].substring(pos + 4).toLowerCase();
                continue;
            }
            pos = matrix[i].toLowerCase().lastIndexOf(".");
            if (pos >= 0) {
                matrix[i] = matrix[i].substring(pos + 1);
            }
            matrix[i] = matrix[i].toLowerCase();
        }
        return matrix;
    }

    protected static String[] convertToMatrix(String expr, String separator) {
        String[] exprList = expr.split("\\" + separator);
        for (int i = 0; i < exprList.length; ++i) {
            exprList[i] = exprList[i].trim();
        }
        return exprList;
    }

    protected void populateQueryParams(Map<String, Object> params) {
        params.entrySet().forEach(param -> this.queryParams.put((String)param.getKey(), param.getValue()));
    }

    public String getColumnExpr() {
        return this.columnExpr;
    }

    public String[] getColumnList() {
        return this.columnList;
    }

    public String getEntityExpr() {
        return this.entityExpr;
    }

    public String[] getEntityList() {
        if (this.entityList == null) {
            this.entityList = DataNativeQuery.convertToMatrix(this.entityExpr, ",");
        }
        return this.entityList;
    }

    public String getFilterExpr() {
        return this.filterExpr;
    }

    public String[] getFilterExprList() {
        if (this.filterExprList == null) {
            this.filterExprList = DataNativeQuery.convertToMatrix(this.filterExpr, ",");
        }
        return this.filterExprList;
    }

    public String getOrderExpr() {
        return this.orderExpr;
    }

    public String[] getOrderList() {
        return this.orderList;
    }

    public String getGroupExpr() {
        return this.groupExpr;
    }

    public String[] getGroupList() {
        if (this.groupList == null) {
            this.groupList = DataNativeQuery.convertToMatrix(this.groupExpr, ",");
        }
        return this.groupList;
    }

    public String getFilterGroupExpr() {
        return this.filterGroupExpr;
    }

    public String[] getFilterGroupExprList() {
        if (this.filterGroupList == null) {
            this.filterGroupList = DataNativeQuery.convertToMatrix(this.filterGroupExpr, ",");
        }
        return this.filterGroupList;
    }

    public String getQuerySentence() {
        return this.querySentence;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public IDataLink getDataLink() {
        return this.dataLink;
    }

    public void setDataLink(IDataLink dao) {
        this.dataLink = dao;
    }

    public Long getCount() throws Exception {
        String query = this.getQueryCount();
        return this.dataLink.getCount2(query, this.queryParams);
    }

    protected String getQueryCount() {
        String fromExpr = this.getFromExpr();
        String query = "select 1 as xx from   " + fromExpr + " \n";
        if (!Strings.isNullorEmpty((String)this.filterExpr).booleanValue()) {
            query = query + " where " + this.filterExpr + " \n";
        }
        if (!Strings.isNullorEmpty((String)this.groupExpr).booleanValue()) {
            query = query + " group by " + this.groupExpr + " \n";
        }
        if (!Strings.isNullorEmpty((String)this.filterGroupExpr).booleanValue()) {
            query = query + " having " + this.filterGroupExpr + " \n";
        }
        return query;
    }

    protected String getJoinEntityExpr() {
        if (this.joinParams.isEmpty()) {
            return "";
        }
        String devolver = "";
        for (JoinParam element : this.joinParams) {
            if (element.joinSubquery != null) continue;
            devolver = devolver + element.joinEntity + ", ";
        }
        if ((devolver = devolver.trim()).endsWith(",")) {
            devolver = devolver.substring(0, devolver.length() - 1);
        }
        return devolver;
    }

    public boolean getApplyDBFilter() {
        return this.applyDBQueryFilter;
    }

    public void setApplyDBFilter(boolean apply) {
        this.applyDBQueryFilter = apply;
    }

    class JoinParam {
        String joinEntity;
        String joinExpr;
        String joinType;
        IDataNativeQuery joinSubquery;
        String joinSubqueryAlias;

        JoinParam(String joinEntity, String joinExpr, String joinType) {
            this.joinEntity = joinEntity;
            this.joinExpr = joinExpr;
            this.joinType = joinType;
        }

        JoinParam(IDataNativeQuery joinSubquery, String alias, String joinExpr, String joinType) {
            this.joinSubquery = joinSubquery;
            this.joinSubqueryAlias = alias;
            this.joinEntity = "";
            this.joinExpr = joinExpr;
            this.joinType = joinType;
        }
    }
}

