/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.javabeanstack.data.IDataQueryModel;
import org.javabeanstack.util.Fn;
import org.javabeanstack.util.Strings;

public class DataQueryModel
implements IDataQueryModel {
    private Object columnId;
    private String[] columnList;
    private Object row;

    public Object getColumnId() {
        if (this.row == null) {
            return null;
        }
        if (this.columnId == null) {
            return this.getColumn(0);
        }
        return this.columnId;
    }

    public Object getColumn(int index) {
        if (this.row == null) {
            return null;
        }
        if (this.row instanceof Object[]) {
            Object[] colList = (Object[])this.row;
            if (colList.length <= index) {
                return null;
            }
            return colList[index];
        }
        return this.row;
    }

    public Object getColumn(String columnName) {
        if (!this.IsColumnMetaDataExist().booleanValue()) {
            return null;
        }
        int index = Fn.findInMatrix((String[])this.columnList, (String)columnName, (Boolean)false);
        if (index < 0) {
            return null;
        }
        return this.getColumn(index);
    }

    public String getColumnStr(String columnName) {
        if (!this.IsColumnMetaDataExist().booleanValue()) {
            return null;
        }
        int index = Fn.findInMatrix((String[])this.columnList, (String)columnName, (Boolean)false);
        if (index < 0) {
            return null;
        }
        return this.getColumn(index).toString();
    }

    public String getColumnName(int index) {
        if (!this.IsColumnMetaDataExist().booleanValue()) {
            return null;
        }
        if (this.columnList.length <= index) {
            return null;
        }
        return this.columnList[index].trim();
    }

    public String[] getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String[] columnList) {
        this.columnList = columnList;
    }

    public void setColumnId(int index) {
        this.columnId = this.getColumn(index);
    }

    public Object getRow() {
        return this.row;
    }

    public void setRow(Object row) {
        this.row = row;
    }

    public void setColumn(int index, Object value) {
        Object[] colList;
        if (this.row instanceof Object[] && (colList = (Object[])this.row).length > index) {
            colList[index] = value;
            return;
        }
        this.row = value;
    }

    public void setColumn(String columnName, Object value) {
        if (!this.IsColumnMetaDataExist().booleanValue()) {
            return;
        }
        int index = Fn.findInMatrix((String[])this.columnList, (String)columnName, (Boolean)false);
        if (index < 0) {
            return;
        }
        this.setColumn(index, value);
    }

    protected Boolean IsColumnMetaDataExist() {
        if (this.columnList == null) {
            return false;
        }
        if (this.columnList.length == 0) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + Objects.hashCode(this.getColumnId());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataQueryModel other = (DataQueryModel)obj;
        return Objects.equals(this.getColumnId(), other.getColumnId());
    }

    public static int searchById(List<IDataQueryModel> dataList, Object searchId) {
        if (dataList.isEmpty()) {
            return -1;
        }
        boolean castToString = false;
        if (searchId.getClass() != dataList.get(0).getColumnId().getClass()) {
            castToString = true;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            String expr2;
            String expr1;
            IDataQueryModel element = dataList.get(i);
            if (!(castToString ? (expr1 = element.getColumnId().toString()).equals(expr2 = searchId.toString()) : Objects.equals(element.getColumnId(), searchId))) continue;
            return i;
        }
        return -1;
    }

    public static final List<IDataQueryModel> convertToDataQueryModel(List<Object> source, String columns) {
        if (source == null) {
            return null;
        }
        ArrayList<IDataQueryModel> target = new ArrayList<IDataQueryModel>(source.size());
        for (int i = 0; i < source.size(); ++i) {
            target.add(DataQueryModel.convertToDataQueryModel(source.get(i), columns));
        }
        return target;
    }

    public static final IDataQueryModel convertToDataQueryModel(Object source, String columns) {
        if (source == null) {
            return null;
        }
        String[] columnsLabel = DataQueryModel.setColumnLabel(columns);
        DataQueryModel row = new DataQueryModel();
        row.setRow(source);
        row.setColumnList(columnsLabel);
        return row;
    }

    public static String[] setColumnLabel(String columns) {
        String regex = "\\(.*?\\)";
        String expr = columns;
        expr = Strings.varReplace((String)expr, (String)"()");
        expr = expr.replaceAll(regex, "()");
        String[] matrix = DataQueryModel.convertToMatrix(expr, ",");
        for (int i = 0; i < matrix.length; ++i) {
            int pos = matrix[i].toLowerCase().indexOf(" as ");
            if (pos >= 0) {
                matrix[i] = matrix[i].substring(pos + 4).toLowerCase();
                continue;
            }
            pos = matrix[i].toLowerCase().lastIndexOf(".");
            if (pos >= 0) {
                matrix[i] = matrix[i].substring(pos + 1);
            }
            matrix[i] = matrix[i].toLowerCase();
        }
        return matrix;
    }

    protected static String[] convertToMatrix(String expr, String separator) {
        String[] exprList = expr.split("\\" + separator);
        for (int i = 0; i < exprList.length; ++i) {
            exprList[i] = exprList[i].trim();
        }
        return exprList;
    }
}

