/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.javabeanstack.data.DataInfo;
import org.javabeanstack.data.IDataRow;
import org.javabeanstack.error.ErrorManager;
import org.javabeanstack.error.ErrorReg;
import org.javabeanstack.error.IErrorReg;

public class DataRow
implements IDataRow,
Serializable,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger(DataRow.class);
    private int action = 0;
    private String queryUK = "";
    private String idFunctionFind = "";
    private boolean rowChecked = false;
    private Map<String, Boolean> fieldChecked = null;
    private Map<String, IErrorReg> errors = null;

    public Object clone() {
        DataRow obj = null;
        try {
            obj = (DataRow)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
        return obj;
    }

    public int getAction() {
        return this.action;
    }

    public String getQueryUK() {
        if (this.queryUK == null || this.queryUK.equals("")) {
            this.queryUK = DataInfo.createQueryUkCommand(this);
        }
        return this.queryUK;
    }

    public String getIdFunctionFind() {
        return this.idFunctionFind;
    }

    public boolean isRowChecked() {
        return this.rowChecked;
    }

    public void setRowChecked(boolean checkrow) {
        this.rowChecked = checkrow;
    }

    public boolean isFieldChecked(String fieldName) {
        if (this.fieldChecked == null) {
            return true;
        }
        fieldName = "_" + fieldName.toLowerCase();
        if (this.fieldChecked.get(fieldName) == null) {
            return true;
        }
        return this.fieldChecked.get(fieldName);
    }

    public Map getFieldChecked() {
        return this.fieldChecked;
    }

    public void setFieldChecked(Map fieldChecked) {
        this.fieldChecked = fieldChecked;
    }

    public void setFieldChecked(String fieldName, boolean checkField) {
        if (this.fieldChecked != null && this.fieldChecked.get(fieldName = "_" + fieldName.toLowerCase()) != null) {
            this.fieldChecked.put(fieldName, checkField);
            if (!checkField) {
                this.setRowChecked(false);
            }
        }
    }

    public Map<String, IErrorReg> getErrors() {
        return this.errors;
    }

    public void setErrors(Map<String, IErrorReg> errorReg) {
        this.errors = errorReg;
    }

    public void setErrors(IErrorReg errorReg, String fieldName) {
        if (fieldName == null) {
            fieldName = "datageneric";
        }
        if (this.errors == null) {
            this.errors = new HashMap<String, IErrorReg>();
        }
        this.errors.put(fieldName.toLowerCase(), errorReg);
    }

    public void setErrors(String errorMsg, String fieldname, int errorNumber) {
        if (fieldname == null) {
            fieldname = "datageneric";
        }
        ErrorReg error = new ErrorReg();
        error.setMessage(errorMsg);
        error.setFieldName(fieldname);
        error.setErrorNumber(errorNumber);
        this.setErrors((IErrorReg)error, fieldname);
    }

    public void setAction(int action) {
        this.action = action;
    }

    public Object getId() {
        Object obj = DataInfo.getIdvalue(this);
        return obj;
    }

    public Object getRowkey() {
        Object obj = DataInfo.getIdvalue(this);
        if (obj == null) {
            return 0;
        }
        return obj;
    }

    public Object getValue(String fieldname) {
        Class<?> classObj = this.getClass();
        try {
            Object valor;
            if (fieldname.contains(".")) {
                valor = DataInfo.getFieldValue(this, fieldname);
            } else {
                Field field = DataInfo.getDeclaredField(classObj, fieldname);
                field.setAccessible(true);
                valor = field.get(this);
                if (valor instanceof IDataRow) {
                    IDataRow row = (IDataRow)valor;
                    return DataInfo.getIdvalue(row);
                }
            }
            return valor;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
            return null;
        }
    }

    public Class getFieldType(String fieldname) {
        return DataInfo.getFieldType(this.getClass(), fieldname);
    }

    public void setValue(String fieldname, Object value) {
        Class<?> classObj = this.getClass();
        try {
            Field field = DataInfo.getDeclaredField(classObj, fieldname);
            field.setAccessible(true);
            field.set(this, value);
            this.setFieldChecked(fieldname, false);
            if (this.action == 0) {
                this.action = 2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)LOGGER);
        }
    }

    public boolean delete() {
        if (this == null) {
            return false;
        }
        this.action = 3;
        return true;
    }

    public int hashCode() {
        int hash = 0;
        hash += this.getId() != null ? this.getId().hashCode() : 0;
        return hash *= this.getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            return false;
        }
        IDataRow other = (IDataRow)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public boolean equivalent(Object o) {
        throw new UnsupportedOperationException("Debe implementar el metodo equivalent en " + this.getClass().getName());
    }
}

