/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.javabeanstack.data.IDataObject;
import org.javabeanstack.data.IDataRow;
import org.javabeanstack.data.IDataSet;

public class DataSet
implements IDataSet {
    private Date lastProcess;
    private final Map<String, IDataObject> listDataObject = new LinkedHashMap<String, IDataObject>();
    private List<List<? extends IDataRow>> listSet = new LinkedList<List<? extends IDataRow>>();
    private final Map<String, List<? extends IDataRow>> mapSet = new LinkedHashMap<String, List<? extends IDataRow>>();

    public IDataSet getChanged() {
        DataSet dataSet = new DataSet();
        this.mapSet.entrySet().forEach(entry -> dataSet.add((String)entry.getKey(), this.getRowsChanged((List)entry.getValue())));
        return dataSet;
    }

    private List<IDataRow> getRowsChanged(List<IDataRow> rows) {
        ArrayList<IDataRow> rowsChanged = new ArrayList<IDataRow>();
        for (int i = 0; i < rows.size(); ++i) {
            IDataRow row = rows.get(i);
            if (row.getAction() == 0) continue;
            rowsChanged.add(row);
        }
        return rowsChanged;
    }

    public Date getLastProcess() {
        return this.lastProcess;
    }

    public void setLastProcess(Date date) {
        this.lastProcess = date;
    }

    public List<? extends IDataRow> get(String key) {
        return this.mapSet.get(key);
    }

    public List<? extends IDataRow> get(int setNumber) {
        if (setNumber >= 0 && this.listSet.size() > setNumber) {
            return this.listSet.get(setNumber);
        }
        return null;
    }

    public Map<String, IDataObject> getMapDataObject() {
        return this.listDataObject;
    }

    public Map<String, List<? extends IDataRow>> getMapListSet() {
        return this.mapSet;
    }

    public void add(String key, List<? extends IDataRow> set) {
        List<? extends IDataRow> old = this.mapSet.put(key, set);
        if (old == null) {
            this.listSet.add(set);
        } else {
            this.reCreateList();
        }
    }

    public void add(String key, IDataRow row) {
        ArrayList<IDataRow> newValue = new ArrayList<IDataRow>();
        newValue.add(row);
        List oldValue = this.mapSet.put(key, newValue);
        if (oldValue == null) {
            this.listSet.add(newValue);
        } else {
            this.reCreateList();
        }
    }

    public void addDataObject(String key, IDataObject dataObject) {
        this.listDataObject.put(key, dataObject);
        this.add(key, dataObject.getDataRows());
    }

    public int size() {
        return this.mapSet.size();
    }

    private void reCreateList() {
        this.listSet = new LinkedList<List<? extends IDataRow>>();
        this.mapSet.entrySet().forEach(entry -> this.listSet.add((List<? extends IDataRow>)entry.getValue()));
    }
}

