/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.javabeanstack.data.DataQueryModel;
import org.javabeanstack.data.IDataExpression;
import org.javabeanstack.data.IDataLink;
import org.javabeanstack.data.IDataNativeQuery;
import org.javabeanstack.data.IDataQueryModel;
import org.javabeanstack.error.ErrorManager;
import org.javabeanstack.util.Fn;
import org.javabeanstack.util.Strings;

public class DataReport {
    private static final Logger LOGGER = Logger.getLogger(DataReport.class);
    private IDataLink dataLink;
    private String entitiesToJoin = "";
    private String entitiesAlias = "";
    private String entityRoot;
    private String columnsGroup1;
    private String columnsGroup2;
    private String columnsGroup3;
    private String columns;
    private IDataExpression whereFilter;
    private String orderBy;
    private String groupBy;
    private String document;
    private Integer reportNumber = 0;
    private IDataNativeQuery query;
    private String sqlSentence;
    protected Map<String, Object> preference1;
    protected Map<String, Object> preference2;
    private int dateGroup = 0;

    public DataReport() {
    }

    public DataReport(IDataLink dao) {
        this.dataLink = dao;
    }

    public int getDateGroup() {
        return this.dateGroup;
    }

    public void setDateGroup(int dateGroup) {
        this.dateGroup = dateGroup;
    }

    public void init(Map<String, Object> preference1, Map<String, Object> preference2) {
        throw new UnsupportedOperationException("Debe implementar el metodo " + this.getClass().getName());
    }

    public final IDataLink getDataLink() {
        return this.dataLink;
    }

    public IDataNativeQuery getQuery() {
        return this.query;
    }

    protected void setQuery(IDataNativeQuery query) {
        this.query = query;
    }

    public final void setDataLink(IDataLink dataLink) {
        this.dataLink = dataLink;
    }

    public final String getColumnsGroup1() {
        return this.columnsGroup1;
    }

    public final void setColumnsGroup1(String columnsGroup1) {
        this.columnsGroup1 = columnsGroup1;
    }

    public final String getColumnsGroup2() {
        return this.columnsGroup2;
    }

    public final void setColumnsGroup2(String columnsGroup2) {
        this.columnsGroup2 = columnsGroup2;
    }

    public final String getColumnsGroup3() {
        return this.columnsGroup3;
    }

    public final void setColumnsGroup3(String columnsGroup3) {
        this.columnsGroup3 = columnsGroup3;
    }

    public final String getColumns() {
        return this.columns;
    }

    public final void setColumns(String columns) {
        this.columns = columns;
    }

    public final String getEntitiesToJoin() {
        return this.entitiesToJoin;
    }

    public final void setEntitiesToJoin(String entitiesToJoin) {
        this.entitiesToJoin = entitiesToJoin;
    }

    public final String getEntityRoot() {
        return this.entityRoot;
    }

    public final void setEntityRoot(String entityRoot) {
        this.entityRoot = entityRoot;
    }

    public final String getEntitiesAlias() {
        return this.entitiesAlias;
    }

    public final void setEntitiesAlias(String entitiesAlias) {
        this.entitiesAlias = entitiesAlias;
    }

    public final String getDocument() {
        return this.document;
    }

    public final void setDocument(String document) {
        this.document = document;
    }

    public final IDataExpression getWhereFilter() {
        return this.whereFilter;
    }

    public final void setWhereFilter(IDataExpression whereFilter) {
        this.whereFilter = whereFilter;
    }

    public final String getGroupBy() {
        return this.groupBy;
    }

    public final void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public final String getOrderBy() {
        return this.orderBy;
    }

    public final void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public final Integer getReportNumber() {
        return this.reportNumber;
    }

    public String getSqlSentence() {
        return this.sqlSentence;
    }

    protected void setSqlSentence(String sqlSentence) {
        this.sqlSentence = sqlSentence;
    }

    public Map<String, Object> getJasperParams() {
        throw new UnsupportedOperationException("Debe implementar el metodo getJasperParams " + this.getClass().getName());
    }

    protected void setProperties() {
        this.columnsGroup1 = ((String)Fn.nvl((Object)this.columnsGroup1, (Object)"")).trim();
        if (this.columnsGroup1.endsWith(",")) {
            this.columnsGroup1 = Strings.left((String)this.columnsGroup1, (int)(this.columnsGroup1.length() - 1));
        }
        this.columnsGroup2 = ((String)Fn.nvl((Object)this.columnsGroup2, (Object)"")).trim();
        if (this.columnsGroup2.endsWith(",")) {
            this.columnsGroup2 = Strings.left((String)this.columnsGroup2, (int)(this.columnsGroup2.length() - 1));
        }
        this.columnsGroup3 = ((String)Fn.nvl((Object)this.columnsGroup3, (Object)"")).trim();
        if (this.columnsGroup3.endsWith(",")) {
            this.columnsGroup3 = Strings.left((String)this.columnsGroup3, (int)(this.columnsGroup3.length() - 1));
        }
        this.columns = ((String)Fn.nvl((Object)this.columns, (Object)"")).trim();
        if (this.columns.endsWith(",")) {
            this.columns = Strings.left((String)this.columns, (int)(this.columns.length() - 1));
        }
        this.groupBy = (String)Fn.nvl((Object)this.groupBy, (Object)"");
        this.orderBy = (String)Fn.nvl((Object)this.orderBy, (Object)"");
    }

    protected void beforeCreateSentence() {
    }

    public void createSqlSentence() {
        this.beforeCreateSentence();
        this.setProperties();
        String select = (String)Fn.iif((Strings.isNullorEmpty((String)this.columnsGroup1) == false ? 1 : 0) != 0, (Object)(this.columnsGroup1 + ","), (Object)"") + (String)Fn.iif((Strings.isNullorEmpty((String)this.columnsGroup2) == false ? 1 : 0) != 0, (Object)(this.columnsGroup2 + ","), (Object)"") + (String)Fn.iif((Strings.isNullorEmpty((String)this.columnsGroup3) == false ? 1 : 0) != 0, (Object)(this.columnsGroup3 + ","), (Object)"") + (String)Fn.iif((Strings.isNullorEmpty((String)this.columns) == false ? 1 : 0) != 0, (Object)this.columns, (Object)"");
        select = select.trim();
        if (select.endsWith(",")) {
            select = select.substring(0, select.length() - 1);
        }
        EntitiesToRelation entityListRelations = new EntitiesToRelation();
        String sentenceSearch = select + " " + this.whereFilter.getSentence() + " " + this.orderBy;
        String entityExpr = entityListRelations.get(this.entityRoot, this.entitiesToJoin, this.entitiesAlias, sentenceSearch);
        this.query = this.dataLink.newDataNativeQuery();
        this.query.setApplyDBFilter(false);
        this.query.select(select).from(entityExpr).where(this.whereFilter).groupBy(this.groupBy).orderBy(this.orderBy);
        this.sqlSentence = this.query.createQuerySentence();
        LOGGER.debug((Object)this.sqlSentence);
        this.afterCreateSentence();
    }

    protected void afterCreateSentence() {
    }

    public IDataNativeQuery createDataNativeQuery(IDataNativeQuery query) {
        this.setProperties();
        String select = (String)Fn.iif((Strings.isNullorEmpty((String)this.columnsGroup1) == false ? 1 : 0) != 0, (Object)(this.columnsGroup1 + ","), (Object)"") + (String)Fn.iif((Strings.isNullorEmpty((String)this.columnsGroup2) == false ? 1 : 0) != 0, (Object)(this.columnsGroup2 + ","), (Object)"") + (String)Fn.iif((Strings.isNullorEmpty((String)this.columnsGroup3) == false ? 1 : 0) != 0, (Object)(this.columnsGroup3 + ","), (Object)"") + (String)Fn.iif((Strings.isNullorEmpty((String)this.columns) == false ? 1 : 0) != 0, (Object)this.columns, (Object)"");
        EntitiesToRelation entityListRelations = new EntitiesToRelation();
        String sentenceSearch = select + " " + this.whereFilter.getSentence() + " " + this.orderBy;
        String entityExpr = entityListRelations.get(this.entityRoot, this.entitiesToJoin, this.entitiesAlias, sentenceSearch);
        query = this.dataLink.newDataNativeQuery();
        query.setApplyDBFilter(false);
        query.select(select).from(entityExpr).where(this.whereFilter).groupBy(this.groupBy).orderBy(this.orderBy);
        query.createQuerySentence();
        LOGGER.debug((Object)query.getQuerySentence());
        return query;
    }

    protected void beforeExecuteSqlSentence() {
    }

    public List<IDataQueryModel> executeSqlSentence() throws Exception {
        this.beforeExecuteSqlSentence();
        List<IDataQueryModel> result = this.query.execQuery();
        result = this.afterExecuteSqlSentence(result);
        return result;
    }

    protected List<IDataQueryModel> afterExecuteSqlSentence(List<IDataQueryModel> result) {
        return result;
    }

    public final String createGroupBy(String columns) {
        List campos = Strings.stringToList((String)columns);
        String[] groupFunction = new String[]{"sum(", "count(", "max(", "min(", "avg("};
        String fieldsGroupBy = "";
        for (String campo : campos) {
            boolean existGroupFunction = false;
            for (String element : groupFunction) {
                if (!campo.toLowerCase().contains(element)) continue;
                existGroupFunction = true;
                break;
            }
            if (existGroupFunction || campo.contains("0.00000") || "".equals(campo)) continue;
            if (campo.toLowerCase().contains(" as ")) {
                fieldsGroupBy = fieldsGroupBy + ("".equals(fieldsGroupBy) ? "" : ",") + Strings.substring((String)campo, (int)0, (int)campo.toLowerCase().indexOf(" as "));
                continue;
            }
            fieldsGroupBy = fieldsGroupBy + ("".equals(fieldsGroupBy) ? "" : ",") + campo;
        }
        return fieldsGroupBy;
    }

    class EntitiesRelation {
        EntitiesRelation() {
        }

        List<IDataQueryModel> get(String entity, String relationType) throws Exception {
            List list;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("entity", entity);
            ArrayList<IDataQueryModel> result = new ArrayList<IDataQueryModel>();
            if (Strings.isNullorEmpty((String)relationType).booleanValue() || "*-1".equals(relationType)) {
                String select1 = "select entityPK as entity, fieldsPK as expr1, fieldsFK as expr2  from AppTablesRelation  where entityFK = :entity and included = true";
                list = DataReport.this.getDataLink().getDao().findListByQuery(null, select1, params);
                result.addAll(DataQueryModel.convertToDataQueryModel(list, "entity, expr1, expr2"));
            }
            if (Strings.isNullorEmpty((String)relationType).booleanValue() || "1-*".equals(relationType)) {
                String select2 = "select entityFK as entity, fieldsFK as expr1, fieldsPK as expr2  from AppTablesRelation  where entityPK = :entity and included = true";
                list = DataReport.this.getDataLink().getDao().findListByQuery(null, select2, params);
                result.addAll(DataQueryModel.convertToDataQueryModel(list, "entity, expr1, expr2"));
            }
            return result;
        }
    }

    class EntitiesToRelation {
        String entityList = "";
        String track = "";

        EntitiesToRelation() {
        }

        private String get(String mainEntity, String entities, String entityAlias, String sentence) {
            this.entityList = entities;
            return this.get(mainEntity, entityAlias, sentence, 0, "");
        }

        private String get(String mainEntity, String entityAlias, String sentence, int level, String processed) {
            if (level == 0) {
                this.track = "";
            }
            if (level == 10) {
                return this.entityList;
            }
            if (Strings.isNullorEmpty((String)processed).booleanValue()) {
                processed = "";
            }
            mainEntity = mainEntity.toLowerCase().trim();
            sentence = sentence.toLowerCase();
            this.track = this.track + mainEntity + ",";
            if (!Strings.isNullorEmpty((String)entityAlias).booleanValue()) {
                List tokenList = Strings.convertToList((String)entityAlias, (String)",");
                for (String token : tokenList) {
                    String entity = Strings.left((String)token, (int)token.indexOf(" ")).toLowerCase().trim();
                    String alias = Strings.substring((String)token, (int)(token.indexOf(" ") + 1)).toLowerCase().trim();
                    if (!Strings.inString((String)",( ", (String)alias, (String)".", (String)sentence) || Strings.inString((String)",( ", (String)entity, (String)"., *)", (String)this.entityList)) continue;
                    this.entityList = this.entityList + (String)Fn.iif((!this.entityList.isEmpty() ? 1 : 0) != 0, (Object)", ", (Object)"") + (String)entity + " " + alias;
                }
            }
            if (level == 0 && Strings.isNullorEmpty((String)this.entityList).booleanValue()) {
                this.entityList = mainEntity;
            }
            try {
                String entity;
                EntitiesRelation entityRela = new EntitiesRelation();
                List<IDataQueryModel> data = level > 0 ? entityRela.get(mainEntity, "*-1") : entityRela.get(mainEntity, "");
                for (IDataQueryModel row : data) {
                    entity = ((String)row.getColumn("entity")).toLowerCase().trim();
                    String xml = "<TABLA>" + entity + "</TABLA>";
                    if (Strings.findString((String)(entity + ","), (String)this.track) >= 0 || Strings.occurs((String)xml, (String)processed) > 0 || !Strings.inString((String)",( ", (String)entity, (String)".", (String)sentence) || Strings.inString((String)", ", (String)entity, (String)", *)", (String)this.entityList) || Strings.occurs((String)xml, (String)processed) != 0) continue;
                    this.entityList = this.entityList + "," + entity;
                }
                for (IDataQueryModel row : data) {
                    entity = ((String)row.getColumn("entity")).toLowerCase().trim();
                    boolean incluirEntity = true;
                    boolean recorrer = true;
                    String xml = "<TABLA>" + entity + "</TABLA>";
                    if (Strings.findString((String)(entity + ","), (String)this.track) >= 0) {
                        recorrer = false;
                    } else if (Strings.occurs((String)xml, (String)processed) > 0) {
                        recorrer = false;
                    }
                    if (Strings.inString((String)",( ", (String)entity, (String)".", (String)sentence) && !Strings.inString((String)", ", (String)entity, (String)", *)", (String)this.entityList) && Strings.occurs((String)xml, (String)processed) == 0) {
                        incluirEntity = false;
                    }
                    int lenLista = this.entityList.length();
                    if (!mainEntity.equals(entity) && recorrer) {
                        this.get(entity, "", sentence, level + 1, processed + xml);
                    }
                    if (lenLista == this.entityList.length() || !incluirEntity || Strings.inString((String)", ", (String)entity, (String)", *", (String)this.entityList)) continue;
                    this.entityList = Strings.left((String)this.entityList, (int)lenLista) + ", " + entity + "," + Strings.substr((String)this.entityList, (int)(lenLista + 1));
                }
            }
            catch (Exception exp) {
                ErrorManager.showError((Exception)exp, (Logger)LOGGER);
            }
            return this.entityList;
        }
    }
}

