/*
 * Decompiled with CFR 0.152.
 */
package org.javabeanstack.services;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.JoinColumn;
import org.apache.log4j.Logger;
import org.javabeanstack.annotation.CheckMethod;
import org.javabeanstack.data.AbstractDAO;
import org.javabeanstack.data.DBLinkInfo;
import org.javabeanstack.data.DataInfo;
import org.javabeanstack.data.DataResult;
import org.javabeanstack.data.IDBLinkInfo;
import org.javabeanstack.data.IDataResult;
import org.javabeanstack.data.IDataRow;
import org.javabeanstack.error.ErrorManager;
import org.javabeanstack.error.ErrorReg;
import org.javabeanstack.error.IErrorReg;
import org.javabeanstack.exceptions.SessionError;
import org.javabeanstack.security.IUserSession;
import org.javabeanstack.services.IDataService;
import org.javabeanstack.util.Fn;

public abstract class AbstractDataService
extends AbstractDAO
implements IDataService {
    private static final Logger LOGGER = Logger.getLogger(AbstractDataService.class);
    protected List<Method> methodList = this.setListCheckMethods();

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    protected final List<Method> setListCheckMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.getClass().getDeclaredMethods()) {
            String namePrefix = method.getName().toLowerCase().substring(0, 5);
            CheckMethod anotation = method.getAnnotation(CheckMethod.class);
            if (!"check".equals(namePrefix) && anotation == null) continue;
            methods.add(method);
        }
        return methods;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public <T extends IDataRow> T setListFieldCheck(T row) {
        if (row != null && row.getFieldChecked() == null) {
            HashMap<String, Boolean> fieldChecked = new HashMap<String, Boolean>();
            for (Method method : this.getClass().getDeclaredMethods()) {
                String namePrefix = method.getName().toLowerCase().substring(0, 5);
                CheckMethod anotation = method.getAnnotation(CheckMethod.class);
                if (!"check".equals(namePrefix) && anotation == null) continue;
                String fieldName = anotation == null ? method.getName().toLowerCase().substring(5) : anotation.fieldName().toLowerCase();
                String key = "_" + fieldName;
                fieldChecked.put(key, true);
            }
            row.setFieldChecked(fieldChecked);
        }
        return row;
    }

    public <T extends IDataRow> boolean checkUniqueKey(T row, String sessionId) {
        try {
            if (row.getQueryUK() == null) {
                return true;
            }
            IDataRow row2 = this.findByUk(IDataRow.class, this.getDBLinkInfo(sessionId), row);
            if (row2 != null) {
                if (row.getAction() == 1) {
                    return false;
                }
                if (row.hashCode() != row2.hashCode()) {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            ErrorManager.showError((Exception)ex, (Logger)Logger.getLogger(AbstractDataService.class));
        }
        return true;
    }

    public <T extends IDataRow> boolean checkForeignKey(T row, String fieldName, String sessionId) {
        boolean result = true;
        try {
            Class<?> clase = row.getClass();
            Field field = DataInfo.getDeclaredField(clase, fieldName);
            if (field == null) {
                result = true;
            } else if (!DataInfo.isForeignKey(row.getClass(), fieldName)) {
                result = true;
            } else {
                Boolean nullable = field.getAnnotation(JoinColumn.class).nullable();
                if (row.getValue(fieldName) == null && !nullable.booleanValue()) {
                    result = false;
                } else if (row.getValue(fieldName) != null) {
                    Class fieldType = row.getFieldType(fieldName);
                    Object id = row.getValue(fieldName);
                    Object fieldValue = this.find(fieldType, this.getDBLinkInfo(sessionId), id);
                    if (fieldValue == null) {
                        result = false;
                    }
                }
            }
        }
        catch (Exception exp) {
            result = false;
        }
        return result;
    }

    public <T extends IDataRow> Map<String, IErrorReg> checkDataRow(T row, String sessionId) {
        String fieldName;
        HashMap<String, IErrorReg> errors = new HashMap<String, IErrorReg>();
        int[] operacion = new int[]{1, 2};
        try {
            if (Fn.inList((Integer)row.getAction(), (int[])new int[]{1, 2}) && !this.checkUniqueKey(row, sessionId)) {
                errors.put("UNIQUEKEY", (IErrorReg)new ErrorReg("Este registro ya existe", 50001, DataInfo.getUniqueFields(row.getClass())));
                return errors;
            }
            if (Fn.inList((Integer)row.getAction(), (int[])new int[]{1, 2})) {
                for (Field field : DataInfo.getDeclaredFields(row.getClass())) {
                    fieldName = field.getName();
                    if (this.checkForeignKey(row, fieldName, sessionId)) continue;
                    errors.put(fieldName.toLowerCase(), (IErrorReg)new ErrorReg("Dejo en blanco este dato o no existe el registro", 50013, fieldName));
                }
            }
        }
        catch (Exception exp) {
            ErrorManager.showError((Exception)exp, (Logger)LOGGER);
        }
        for (Method method : this.methodList) {
            CheckMethod anotation = method.getAnnotation(CheckMethod.class);
            if (anotation == null) {
                fieldName = method.getName().toLowerCase().substring(5);
            } else {
                fieldName = anotation.fieldName();
                operacion = anotation.action();
            }
            if (errors.containsKey(fieldName.toLowerCase())) continue;
            try {
                IErrorReg result;
                method.setAccessible(true);
                if (!Fn.inList((Integer)row.getAction(), (int[])operacion) || (result = (IErrorReg)method.invoke((Object)this, row, sessionId)) == null || "".equals(result.getMessage())) continue;
                errors.put(fieldName.toLowerCase(), result);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                ErrorManager.showError((Exception)ex, (Logger)Logger.getLogger(AbstractDataService.class));
            }
        }
        row.setErrors(errors);
        row.setRowChecked(true);
        return errors;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    protected final void checkUserSession(String sessionId) throws SessionError {
        IUserSession userSession = this.getUserSession(sessionId);
        if (userSession == null || userSession.getUser() == null) {
            throw new SessionError("El identificador de la sesi\u00f3n es inv\u00e1lido");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    protected String getPersistentUnit(String sessionId) {
        IUserSession userSession = this.getUserSession(sessionId);
        if (userSession == null || userSession.getUser() == null) {
            return null;
        }
        return userSession.getPersistenceUnit();
    }

    protected final <T extends IDataRow> IDataResult checkDataResult(T row, String sessionId) {
        DataResult dataResult = new DataResult();
        dataResult.setSuccess(Boolean.TRUE);
        ArrayList<T> ejbsRes = new ArrayList<T>();
        Map<String, IErrorReg> errors = this.checkDataRow(row, sessionId);
        ejbsRes.add(row);
        if (!errors.isEmpty()) {
            dataResult.setSuccess(Boolean.FALSE);
            dataResult.setErrorsMap(errors);
        }
        dataResult.put("1", ejbsRes);
        return dataResult;
    }

    protected final <T extends IDataRow> IDataResult save(T row, String sessionId) throws SessionError {
        this.checkUserSession(sessionId);
        IDataResult dataResult = this.checkDataResult(row, sessionId);
        if (!dataResult.getErrorsMap().isEmpty()) {
            return dataResult;
        }
        dataResult = this.update(this.getDBLinkInfo(sessionId), row);
        return dataResult;
    }

    public <T extends IDataRow> IDataResult create(T row, String sessionId) throws SessionError {
        row.setAction(1);
        return this.save(row, sessionId);
    }

    public <T extends IDataRow> IDataResult edit(T row, String sessionId) throws SessionError {
        row.setAction(2);
        return this.save(row, sessionId);
    }

    public <T extends IDataRow> IDataResult remove(T row, String sessionId) throws SessionError {
        row.setAction(3);
        return this.save(row, sessionId);
    }

    private IDBLinkInfo getDBLinkInfo(String sessionId) {
        DBLinkInfo dbInfo = new DBLinkInfo();
        dbInfo.setUserSession(this.getUserSession(sessionId));
        return dbInfo;
    }
}

