/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.guided_tour;

import java.util.HashMap;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.listener.DefaultSimQueueListener;

class JobSojournTimeListenerWithReset
extends DefaultSimQueueListener {
    private final Map<SimJob, Double> jobArrTimes = new HashMap<SimJob, Double>();
    private int jobsPassed = 0;
    private double cumJobSojournTime = 0.0;

    JobSojournTimeListenerWithReset() {
    }

    public void notifyResetEntity(SimEntity entity) {
        super.notifyResetEntity(entity);
        this.jobArrTimes.clear();
        this.jobsPassed = 0;
        this.cumJobSojournTime = 0.0;
    }

    public void notifyArrival(double time, SimJob job, SimQueue queue) {
        if (this.jobArrTimes.containsKey(job)) {
            throw new IllegalStateException();
        }
        this.jobArrTimes.put(job, time);
    }

    public void notifyDeparture(double time, SimJob job, SimQueue queue) {
        if (!this.jobArrTimes.containsKey(job)) {
            throw new IllegalStateException();
        }
        double jobSojournTime = time - this.jobArrTimes.get(job);
        if (jobSojournTime < 0.0) {
            throw new IllegalStateException();
        }
        this.jobArrTimes.remove(job);
        ++this.jobsPassed;
        this.cumJobSojournTime += jobSojournTime;
    }

    public void notifyDrop(double time, SimJob job, SimQueue queue) {
        this.notifyDeparture(time, job, queue);
    }

    public double getAvgSojournTime() {
        if (this.jobsPassed == 0) {
            return Double.NaN;
        }
        return this.cumJobSojournTime / (double)this.jobsPassed;
    }
}

