/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntityListener;
import org.javades.jqueues.r5.entity.SimEntityOperation;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.listener.StdOutSimEntityListener;
import org.javades.jsimulation.r5.SimEventList;
import org.javades.jsimulation.r5.SimEventListResetListener;

public abstract class AbstractSimEntity
implements SimEntity {
    protected static final boolean USE_ARRAY_OPTIMIZATION = true;
    private static final Logger LOGGER = Logger.getLogger(AbstractSimEntity.class.getName());
    private final SimEventList eventList;
    private String name = null;
    private final Set<SimEntityOperation> registeredOperations = new LinkedHashSet<SimEntityOperation>();
    private final Map<SimEntityOperation, SimEntityOperation> delegatedOperations = new LinkedHashMap<SimEntityOperation, SimEntityOperation>();
    private SimEntity.UnknownOperationPolicy unknownOperationPolicy = SimEntity.UnknownOperationPolicy.ERROR;
    private final Map<SimEntitySimpleEventType.Member, Notifier> notificationMap = new LinkedHashMap<SimEntitySimpleEventType.Member, Notifier>();
    private SimEntity.UnknownNotificationTypePolicy unknownNotificationTypePolicy = SimEntity.UnknownNotificationTypePolicy.FIRE_AND_WARN;
    private final Set<PreNotificationHook> preNotificationHooks = new LinkedHashSet<PreNotificationHook>();
    private PreNotificationHook[] preNotificationHooksAsArray = new PreNotificationHook[0];
    private final List<SimEntity.Action> postNotificationActions = new ArrayList<SimEntity.Action>();
    private final List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> pendingNotifications = new ArrayList<Map<SimEntitySimpleEventType.Member, SimEntityEvent>>();
    private double pendingNotificationsTime = Double.NEGATIVE_INFINITY;
    private boolean pendingNotificationsLocked = true;
    private boolean firingPendingNotifications = false;
    private final Set<SimEntityListener> simEntityListeners = new LinkedHashSet<SimEntityListener>();
    private SimEntityListener[] simEntityListenersAsArray = new SimEntityListener[0];
    private final StdOutSimEntityListener stdOutSimEntityListener = new StdOutSimEntityListener();
    private boolean ignoreEventListReset = false;
    private double lastUpdateTime = Double.NEGATIVE_INFINITY;
    private final Set<DoubleConsumer> preUpdateHooks = new LinkedHashSet<DoubleConsumer>();
    private DoubleConsumer[] preUpdateHooksAsArray = new DoubleConsumer[0];
    private final Set<DoubleConsumer> preEventHooks = new LinkedHashSet<DoubleConsumer>();
    private DoubleConsumer[] preEventHooksAsArray = new DoubleConsumer[0];

    public AbstractSimEntity(SimEventList eventList, String name) {
        this.eventList = eventList;
        this.setName(name);
        this.registerOperation(SimEntityOperation.Reset.getInstance());
        this.registerOperation(SimEntityOperation.Update.getInstance());
        this.registerNotificationType(SimEntitySimpleEventType.RESET, this::fireReset);
        if (this.eventList != null) {
            this.lastUpdateTime = this.eventList.getTime();
            this.eventList.addListener((SimEventListResetListener)this);
        }
    }

    @Override
    public final SimEventList getEventList() {
        return this.eventList;
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public String toStringDefault() {
        return "AbstractSimEntity";
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.toStringDefault();
    }

    @Override
    public final Set<SimEntityOperation> getRegisteredOperations() {
        return Collections.unmodifiableSet(this.registeredOperations);
    }

    protected final void registerOperation(SimEntityOperation operation) {
        if (operation == null || this.registeredOperations.contains(operation)) {
            throw new IllegalArgumentException();
        }
        this.registeredOperations.add(operation);
    }

    public final Set<SimEntityOperation> getRegisteredDelegatedOperations() {
        return Collections.unmodifiableSet(this.delegatedOperations.keySet());
    }

    protected final void registerDelegatedOperation(SimEntityOperation operation, SimEntityOperation delegateOperation) {
        if (operation == null || this.registeredOperations.contains(operation) || delegateOperation == null) {
            throw new IllegalArgumentException();
        }
        if (this.delegatedOperations.containsKey(operation)) {
            throw new IllegalStateException();
        }
        this.registeredOperations.add(operation);
        this.delegatedOperations.put(operation, delegateOperation);
    }

    protected final void delegateOperation(SimEntityOperation operation, SimEntityOperation delegateOperation) {
        if (operation == null || !this.registeredOperations.contains(operation) || delegateOperation == null) {
            throw new IllegalArgumentException();
        }
        this.delegatedOperations.put(operation, delegateOperation);
    }

    protected final void removeDelegationForOperation(SimEntityOperation operation) {
        if (operation == null || !this.registeredOperations.contains(operation) || !this.delegatedOperations.containsKey(operation)) {
            throw new IllegalArgumentException();
        }
        this.delegatedOperations.remove(operation);
    }

    @Override
    public final SimEntity.UnknownOperationPolicy getUnknownOperationPolicy() {
        return this.unknownOperationPolicy;
    }

    @Override
    public final void setUnknownOperationPolicy(SimEntity.UnknownOperationPolicy unknownOperationPolicy) {
        if (unknownOperationPolicy == null) {
            throw new IllegalArgumentException();
        }
        this.unknownOperationPolicy = unknownOperationPolicy;
    }

    @Override
    public final <O extends SimEntityOperation, Req extends SimEntityOperation.Request, Rep extends SimEntityOperation.Reply> Rep doOperation(double time, Req request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        if (request.getOperation() == null) {
            throw new IllegalArgumentException();
        }
        if (request.getTargetEntity() != this) {
            throw new IllegalArgumentException();
        }
        if (request.getOperation() != SimEntityOperation.Reset.getInstance() && time < this.getLastUpdateTime()) {
            throw new IllegalArgumentException();
        }
        if (!this.registeredOperations.contains(request.getOperation())) {
            switch (this.unknownOperationPolicy) {
                case ERROR: {
                    throw new IllegalArgumentException();
                }
                case REPORT: {
                    System.err.println("Unknown operation on " + this + ": " + request.getOperation() + "!");
                    break;
                }
                case LOG_WARNING: {
                    LOGGER.log(Level.WARNING, "Unknown operation on {0}: {1}!", new Object[]{this, request.getOperation()});
                    break;
                }
                case LOG_INFO: {
                    LOGGER.log(Level.INFO, "Unknown operation on {0}: {1}!", new Object[]{this, request.getOperation()});
                    break;
                }
                case LOG_FINE: {
                    LOGGER.log(Level.FINE, "Unknown operation on {0}: {1}!", new Object[]{this, request.getOperation()});
                    break;
                }
                case IGNORE: {
                    return null;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        if (this.delegatedOperations.containsKey(request.getOperation())) {
            return this.delegatedOperations.get(request.getOperation()).doOperation(time, request);
        }
        return request.getOperation().doOperation(time, request);
    }

    protected final void registerNotificationType(SimEntitySimpleEventType.Member notificationType, Notifier notifier) {
        if (notificationType == null) {
            throw new IllegalArgumentException();
        }
        if (this.notificationMap.containsKey(notificationType)) {
            throw new IllegalArgumentException();
        }
        this.notificationMap.put(notificationType, notifier);
    }

    @Override
    public final Set<SimEntitySimpleEventType.Member> getRegisteredNotificationTypes() {
        return Collections.unmodifiableSet(new LinkedHashSet<SimEntitySimpleEventType.Member>(this.notificationMap.keySet()));
    }

    @Override
    public final SimEntity.UnknownNotificationTypePolicy getUnknownNotificationTypePolicy() {
        return this.unknownNotificationTypePolicy;
    }

    @Override
    public final void setUnknownNotificationTypePolicy(SimEntity.UnknownNotificationTypePolicy unknownNotificationTypePolicy) {
        if (unknownNotificationTypePolicy == null) {
            throw new IllegalArgumentException();
        }
        this.unknownNotificationTypePolicy = unknownNotificationTypePolicy;
    }

    protected final void registerPreNotificationHook(PreNotificationHook preNotificationHook) {
        if (preNotificationHook == null || this.preNotificationHooks.contains(preNotificationHook)) {
            throw new IllegalArgumentException();
        }
        this.preNotificationHooks.add(preNotificationHook);
        this.preNotificationHooksAsArray = this.preNotificationHooks.toArray(new PreNotificationHook[this.preNotificationHooks.size()]);
    }

    @Override
    public final void doAfterNotifications(SimEntity.Action action) {
        if (action == null) {
            throw new IllegalArgumentException();
        }
        if (!this.firingPendingNotifications) {
            action.execute();
        } else {
            this.postNotificationActions.add(action);
        }
    }

    protected final void addPendingNotification(Map<SimEntitySimpleEventType.Member, SimEntityEvent> notification) {
        if (notification == null || notification.size() != 1 || notification.containsKey(null) || notification.containsValue(null) || this.pendingNotifications.contains(notification) || !this.pendingNotifications.isEmpty() && this.getLastUpdateTime() != this.pendingNotificationsTime || this.pendingNotificationsLocked || this.firingPendingNotifications) {
            throw new IllegalArgumentException("notification: " + notification);
        }
        if (this.pendingNotifications.isEmpty()) {
            this.pendingNotificationsTime = this.getLastUpdateTime();
        }
        if (this.containsPendingNotification(notification)) {
            LOGGER.log(Level.WARNING, "Attempt to re-enter notification {0}@{1}!", new Object[]{notification, this});
        } else {
            this.pendingNotifications.add(notification);
        }
    }

    protected final void addPendingNotification(SimEntitySimpleEventType.Member notificationType, SimEntityEvent notification) {
        if (notificationType == null || notification == null) {
            throw new IllegalArgumentException();
        }
        this.addPendingNotification(Collections.singletonMap(notificationType, notification));
    }

    private boolean containsPendingNotification(Map<SimEntitySimpleEventType.Member, SimEntityEvent> notification) {
        if (notification == null || notification.size() != 1 || notification.containsKey(null)) {
            throw new IllegalArgumentException();
        }
        SimEntitySimpleEventType.Member eventType = notification.keySet().iterator().next();
        SimEntityEvent event = notification.values().iterator().next();
        for (Map<SimEntitySimpleEventType.Member, SimEntityEvent> member : this.pendingNotifications) {
            if (member.keySet().iterator().next() != eventType || member.values().iterator().next() != event) continue;
            return true;
        }
        return false;
    }

    private void clearAndUnlockPendingNotifications() {
        if (this.firingPendingNotifications) {
            throw new IllegalStateException();
        }
        this.pendingNotifications.clear();
        this.pendingNotificationsLocked = false;
    }

    protected final boolean clearAndUnlockPendingNotificationsIfLocked() {
        if (this.firingPendingNotifications) {
            throw new IllegalStateException();
        }
        boolean isLocked = this.pendingNotificationsLocked;
        if (isLocked) {
            this.clearAndUnlockPendingNotifications();
        }
        return isLocked;
    }

    protected final void fireAndLockPendingNotifications() {
        boolean isResetNotification;
        if (!this.pendingNotifications.isEmpty() && this.pendingNotificationsTime != this.getLastUpdateTime()) {
            throw new IllegalStateException();
        }
        if (this.firingPendingNotifications) {
            throw new IllegalStateException();
        }
        this.pendingNotificationsLocked = true;
        this.firingPendingNotifications = true;
        boolean bl = isResetNotification = this.pendingNotifications.size() == 1 && this.pendingNotifications.get(0).containsKey(SimEntitySimpleEventType.RESET);
        if (!isResetNotification) {
            for (PreNotificationHook preNotificationHook : this.preNotificationHooks) {
                preNotificationHook.hook(this.pendingNotifications);
            }
        }
        if (!this.pendingNotifications.isEmpty()) {
            SimEntitySimpleEventType.Member notificationType;
            double time = this.getLastUpdateTime();
            block6: for (Map<SimEntitySimpleEventType.Member, SimEntityEvent> map : this.pendingNotifications) {
                notificationType = map.keySet().iterator().next();
                if (this.notificationMap.containsKey(notificationType)) continue;
                switch (this.unknownNotificationTypePolicy) {
                    case FIRE_AND_WARN: {
                        LOGGER.log(Level.WARNING, "Unknown notification type {0}.", notificationType);
                        continue block6;
                    }
                    case FIRE_SILENTLY: {
                        continue block6;
                    }
                    case ERROR: {
                        throw new IllegalArgumentException();
                    }
                }
                throw new RuntimeException();
            }
            for (SimEntityListener simEntityListener : this.simEntityListeners) {
                simEntityListener.notifyStateChanged(time, this, this.pendingNotifications);
            }
            for (Map map : this.pendingNotifications) {
                notificationType = (SimEntitySimpleEventType.Member)map.keySet().iterator().next();
                SimEntityEvent notificationEvent = (SimEntityEvent)((Object)map.values().iterator().next());
                if (!this.notificationMap.containsKey(notificationType) || this.notificationMap.get(notificationType) == null) continue;
                this.notificationMap.get(notificationType).fire(notificationEvent);
            }
        }
        this.firingPendingNotifications = false;
        while (!this.postNotificationActions.isEmpty()) {
            this.postNotificationActions.remove(0).execute();
        }
    }

    @Override
    public final void registerSimEntityListener(SimEntityListener listener) {
        if (listener != null && !this.simEntityListeners.contains(listener)) {
            this.simEntityListeners.add(listener);
            this.simEntityListenersAsArray = this.simEntityListeners.toArray(new SimEntityListener[this.simEntityListeners.size()]);
        }
    }

    @Override
    public final void unregisterSimEntityListener(SimEntityListener listener) {
        if (this.simEntityListeners.contains(listener)) {
            this.simEntityListeners.remove(listener);
            this.simEntityListenersAsArray = this.simEntityListeners.toArray(new SimEntityListener[this.simEntityListeners.size()]);
        }
    }

    @Override
    public final Set<SimEntityListener> getSimEntityListeners() {
        return this.simEntityListeners;
    }

    public final void registerStdOutSimEntityListener() {
        this.registerSimEntityListener(this.stdOutSimEntityListener);
    }

    public final void unregisterStdOutSimEntityListener() {
        this.unregisterSimEntityListener(this.stdOutSimEntityListener);
    }

    protected void resetEntitySubClass() {
    }

    @Override
    public final void resetEntity() {
        this.lastUpdateTime = this.getEventList() != null ? this.getEventList().getTime() : Double.NEGATIVE_INFINITY;
        this.pendingNotifications.clear();
        this.pendingNotificationsLocked = true;
        this.firingPendingNotifications = false;
        this.postNotificationActions.clear();
        this.resetEntitySubClass();
        this.clearAndUnlockPendingNotifications();
        this.addPendingNotification(SimEntitySimpleEventType.RESET, new SimEntityEvent.Reset(this, this.lastUpdateTime));
        this.fireAndLockPendingNotifications();
    }

    @Override
    public final boolean isIgnoreEventListReset() {
        return this.ignoreEventListReset;
    }

    @Override
    public final void setIgnoreEventListReset(boolean ignoreEventListReset) {
        this.ignoreEventListReset = ignoreEventListReset;
    }

    public final void notifyEventListReset(SimEventList eventList) {
        if (!this.ignoreEventListReset) {
            this.resetEntity();
        }
    }

    private void fireReset(SimEntityEvent event) {
        if (event == null || !(event instanceof SimEntityEvent.Reset)) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.simEntityListeners) {
            l.notifyResetEntity(this);
        }
    }

    @Override
    public final double getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public final void update(double time) {
        if (time < this.lastUpdateTime) {
            LOGGER.log(Level.SEVERE, "Update in the past on {0}: {1} < {2}!", new Object[]{this, time, this.lastUpdateTime});
            throw new IllegalStateException("update in the past: " + time + " < " + this.lastUpdateTime + "!");
        }
        for (DoubleConsumer preEventHook : this.preEventHooksAsArray) {
            preEventHook.accept(time);
        }
        if (Double.isInfinite(time) || time > this.lastUpdateTime) {
            for (DoubleConsumer preUpdateHook : this.preUpdateHooksAsArray) {
                preUpdateHook.accept(time);
            }
            this.fireUpdate(time);
            this.lastUpdateTime = time;
        }
    }

    protected final void registerPreUpdateHook(DoubleConsumer preUpdateHook) {
        if (preUpdateHook == null) {
            throw new IllegalArgumentException();
        }
        if (!this.preUpdateHooks.contains(preUpdateHook)) {
            this.preUpdateHooks.add(preUpdateHook);
            this.preUpdateHooksAsArray = this.preUpdateHooks.toArray(new DoubleConsumer[this.preUpdateHooks.size()]);
        }
    }

    protected final void registerPreEventHook(DoubleConsumer preEventHook) {
        if (preEventHook == null) {
            throw new IllegalArgumentException();
        }
        if (!this.preEventHooks.contains(preEventHook)) {
            this.preEventHooks.add(preEventHook);
            this.preEventHooksAsArray = this.preEventHooks.toArray(new DoubleConsumer[this.preEventHooks.size()]);
        }
    }

    private void fireUpdate(double time) {
        for (SimEntityListener l : this.simEntityListenersAsArray) {
            l.notifyUpdate(time, this);
        }
    }

    @FunctionalInterface
    public static interface PreNotificationHook {
        public void hook(List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> var1);
    }

    @FunctionalInterface
    public static interface Notifier {
        public void fire(SimEntityEvent var1);
    }
}

