/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity;

import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jsimulation.r5.SimEventList;

public abstract class SimEntityEventScheduler {
    protected SimEntityEventScheduler() {
        throw new UnsupportedOperationException();
    }

    public static void scheduleE(SimEventList eventList, boolean reset, double resetTime, Set<SimEntityEvent> entityEvents) {
        if (eventList == null) {
            throw new IllegalArgumentException();
        }
        if (entityEvents != null && entityEvents.contains(null)) {
            throw new IllegalArgumentException();
        }
        if (reset) {
            eventList.reset(resetTime);
        }
        if (entityEvents != null) {
            for (SimEntityEvent event : entityEvents) {
                SimEntityEventScheduler.scheduleE(eventList, event);
            }
        }
    }

    public static void scheduleE(SimEventList eventList, SimEntityEvent entityEvent) {
        if (eventList == null || entityEvent == null) {
            throw new IllegalArgumentException();
        }
        double eventListTime = eventList.getTime();
        double eventTime = entityEvent.getTime();
        if (eventTime < eventListTime) {
            throw new IllegalArgumentException();
        }
        eventList.add((Object)entityEvent);
    }

    public static void scheduleResetEntity(SimEventList eventList, SimEntity entity, double resetTime) {
        if (eventList == null || entity == null || eventList.getTime() > resetTime || entity.getEventList() != null && entity.getEventList() != eventList) {
            throw new IllegalArgumentException();
        }
        SimEntityEventScheduler.scheduleE(eventList, new SimEntityEvent.Reset(entity, resetTime));
    }

    public static void scheduleUpdate(SimEventList eventList, SimEntity entity, double updateTime) {
        if (eventList == null || entity == null || eventList.getTime() > updateTime || entity.getEventList() != null && entity.getEventList() != eventList) {
            throw new IllegalArgumentException();
        }
        SimEntityEventScheduler.scheduleE(eventList, new SimEntityEvent.Update(entity, updateTime));
    }
}

