/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity;

import org.javades.jqueues.r5.entity.SimEntity;

public interface SimEntityOperation<O extends SimEntityOperation, Req extends Request, Rep extends Reply> {
    public String getName();

    public Class<Req> getOperationRequestClass();

    public Class<Rep> getOperationReplyClass();

    public Rep doOperation(double var1, Req var3);

    public static final class UpdateReply
    implements Reply<Update, UpdateRequest, UpdateReply> {
        private final UpdateRequest request;

        public UpdateReply(UpdateRequest request) {
            if (request == null) {
                throw new IllegalArgumentException();
            }
            this.request = request;
        }

        @Override
        public final Update getOperation() {
            return Update.INSTANCE;
        }

        @Override
        public final UpdateRequest getRequest() {
            return this.request;
        }
    }

    public static final class UpdateRequest
    extends RequestE<Update, UpdateRequest> {
        public UpdateRequest(SimEntity entity) {
            super(entity);
        }

        @Override
        public final Update getOperation() {
            return Update.INSTANCE;
        }

        @Override
        public final UpdateRequest forTargetEntity(SimEntity newTargetEntity) {
            if (newTargetEntity == null) {
                throw new IllegalArgumentException();
            }
            return new UpdateRequest(newTargetEntity);
        }
    }

    public static final class Update
    implements SimEntityOperation<Update, UpdateRequest, UpdateReply> {
        private static final Update INSTANCE = new Update();

        private Update() {
        }

        public final Object clone() throws CloneNotSupportedException {
            super.clone();
            throw new CloneNotSupportedException();
        }

        public static Update getInstance() {
            return INSTANCE;
        }

        @Override
        public final String getName() {
            return "Update";
        }

        @Override
        public final Class<UpdateRequest> getOperationRequestClass() {
            return UpdateRequest.class;
        }

        @Override
        public final Class<UpdateReply> getOperationReplyClass() {
            return UpdateReply.class;
        }

        @Override
        public final UpdateReply doOperation(double time, UpdateRequest request) {
            if (request == null || request.getTargetEntity() == null || request.getOperation() != Update.getInstance()) {
                throw new IllegalArgumentException();
            }
            request.getTargetEntity().update(time);
            return new UpdateReply(request);
        }
    }

    public static final class ResetReply
    implements Reply<Reset, ResetRequest, ResetReply> {
        private final ResetRequest request;

        public ResetReply(ResetRequest request) {
            if (request == null) {
                throw new IllegalArgumentException();
            }
            this.request = request;
        }

        @Override
        public final Reset getOperation() {
            return Reset.INSTANCE;
        }

        @Override
        public final ResetRequest getRequest() {
            return this.request;
        }
    }

    public static final class ResetRequest
    extends RequestE<Reset, ResetRequest> {
        public ResetRequest(SimEntity entity) {
            super(entity);
        }

        @Override
        public final Reset getOperation() {
            return Reset.INSTANCE;
        }

        @Override
        public final ResetRequest forTargetEntity(SimEntity newTargetEntity) {
            if (newTargetEntity == null) {
                throw new IllegalArgumentException();
            }
            return new ResetRequest(newTargetEntity);
        }
    }

    public static final class Reset
    implements SimEntityOperation<Reset, ResetRequest, ResetReply> {
        private static final Reset INSTANCE = new Reset();

        private Reset() {
        }

        public final Object clone() throws CloneNotSupportedException {
            super.clone();
            throw new CloneNotSupportedException();
        }

        public static Reset getInstance() {
            return INSTANCE;
        }

        @Override
        public final String getName() {
            return "Reset";
        }

        @Override
        public final Class<ResetRequest> getOperationRequestClass() {
            return ResetRequest.class;
        }

        @Override
        public final Class<ResetReply> getOperationReplyClass() {
            return ResetReply.class;
        }

        @Override
        public final ResetReply doOperation(double time, ResetRequest request) {
            if (request == null || request.getTargetEntity() == null || request.getOperation() != Reset.getInstance()) {
                throw new IllegalArgumentException();
            }
            request.getTargetEntity().resetEntity();
            return new ResetReply(request);
        }
    }

    public static abstract class RequestE<O extends SimEntityOperation, Req extends Request>
    implements Request<O, Req> {
        private final SimEntity entity;

        public RequestE(SimEntity entity) {
            if (entity == null) {
                throw new IllegalArgumentException();
            }
            this.entity = entity;
        }

        @Override
        public final SimEntity getTargetEntity() {
            return this.entity;
        }
    }

    public static interface Reply<O extends SimEntityOperation, Req extends Request, Rep extends Reply> {
        public O getOperation();

        public Req getRequest();
    }

    public static interface Request<O extends SimEntityOperation, Req extends Request> {
        public O getOperation();

        public SimEntity getTargetEntity();

        public Req forTargetEntity(SimEntity var1);
    }
}

