/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq;

import java.util.logging.Logger;
import org.javades.jqueues.r5.entity.AbstractSimEntity;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntityListener;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQListener;
import org.javades.jqueues.r5.entity.jq.SimJQSimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimQoS;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jsimulation.r5.SimEventList;

public abstract class AbstractSimJQ<J extends SimJob, Q extends SimQueue>
extends AbstractSimEntity
implements SimQoS<J, Q> {
    private static final Logger LOGGER = Logger.getLogger(AbstractSimJQ.class.getName());

    public AbstractSimJQ(SimEventList eventList, String name) {
        super(eventList, name);
        if (!(this instanceof SimJob) && !(this instanceof SimQueue)) {
            throw new IllegalArgumentException("AbstractSimJQ must be SimJob or a SimQueue");
        }
        if (this instanceof SimJob && this instanceof SimQueue) {
            throw new IllegalArgumentException("AbstractSimJQ cannot be both a SimJob and a SimQueue");
        }
        this.registerNotificationType(SimJQSimpleEventType.ARRIVAL, this::fireArrival);
        this.registerNotificationType(SimJQSimpleEventType.DROP, this::fireDrop);
        this.registerNotificationType(SimJQSimpleEventType.REVOCATION, this::fireRevocation);
        this.registerNotificationType(SimJQSimpleEventType.AUTO_REVOCATION, this::fireAutoRevocation);
        this.registerNotificationType(SimJQSimpleEventType.START, this::fireStart);
        this.registerNotificationType(SimJQSimpleEventType.DEPARTURE, this::fireDeparture);
    }

    public AbstractSimJQ(SimEventList eventList) {
        this(eventList, null);
    }

    @Override
    protected void resetEntitySubClass() {
        super.resetEntitySubClass();
    }

    private void fireArrival(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimJQEvent.Arrival)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time) {
            throw new IllegalArgumentException();
        }
        Object queue = ((SimJQEvent)event).getQueue();
        Object job = ((SimJQEvent)event).getJob();
        if (queue == null || job == null) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimJQListener)) continue;
            ((SimJQListener)l).notifyArrival(time, job, queue);
        }
        if (this instanceof SimQueue) {
            for (SimEntityListener l : job.getSimEntityListeners()) {
                if (!(l instanceof SimJQListener)) continue;
                ((SimJQListener)l).notifyArrival(time, job, queue);
            }
        }
    }

    private void fireDrop(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimJQEvent.Drop)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time) {
            throw new IllegalArgumentException();
        }
        Object queue = ((SimJQEvent)event).getQueue();
        Object job = ((SimJQEvent)event).getJob();
        if (queue == null || job == null) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimJQListener)) continue;
            ((SimJQListener)l).notifyDrop(time, job, queue);
        }
        if (this instanceof SimQueue) {
            for (SimEntityListener l : job.getSimEntityListeners()) {
                if (!(l instanceof SimJQListener)) continue;
                ((SimJQListener)l).notifyDrop(time, job, queue);
            }
        }
    }

    private void fireRevocation(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimJQEvent.Revocation)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time) {
            throw new IllegalArgumentException();
        }
        Object queue = ((SimJQEvent)event).getQueue();
        Object job = ((SimJQEvent)event).getJob();
        if (queue == null || job == null) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimJQListener)) continue;
            ((SimJQListener)l).notifyRevocation(time, job, queue);
        }
        if (this instanceof SimQueue) {
            for (SimEntityListener l : job.getSimEntityListeners()) {
                if (!(l instanceof SimJQListener)) continue;
                ((SimJQListener)l).notifyRevocation(time, job, queue);
            }
        }
    }

    private void fireAutoRevocation(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimJQEvent.AutoRevocation)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time) {
            throw new IllegalArgumentException();
        }
        Object queue = ((SimJQEvent)event).getQueue();
        Object job = ((SimJQEvent)event).getJob();
        if (queue == null || job == null) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimJQListener)) continue;
            ((SimJQListener)l).notifyAutoRevocation(time, job, queue);
        }
        if (this instanceof SimQueue) {
            for (SimEntityListener l : job.getSimEntityListeners()) {
                if (!(l instanceof SimJQListener)) continue;
                ((SimJQListener)l).notifyAutoRevocation(time, job, queue);
            }
        }
    }

    private void fireStart(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimJQEvent.Start)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time) {
            throw new IllegalArgumentException();
        }
        Object queue = ((SimJQEvent)event).getQueue();
        Object job = ((SimJQEvent)event).getJob();
        if (queue == null || job == null) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimJQListener)) continue;
            ((SimJQListener)l).notifyStart(time, job, queue);
        }
        if (this instanceof SimQueue) {
            for (SimEntityListener l : job.getSimEntityListeners()) {
                if (!(l instanceof SimJQListener)) continue;
                ((SimJQListener)l).notifyStart(time, job, queue);
            }
        }
    }

    private void fireDeparture(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimJQEvent.Departure)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time) {
            throw new IllegalArgumentException();
        }
        Object queue = ((SimJQEvent)event).getQueue();
        Object job = ((SimJQEvent)event).getJob();
        if (queue == null || job == null) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimJQListener)) continue;
            ((SimJQListener)l).notifyDeparture(time, job, queue);
        }
        if (this instanceof SimQueue) {
            for (SimEntityListener l : job.getSimEntityListeners()) {
                if (!(l instanceof SimJQListener)) continue;
                ((SimJQListener)l).notifyDeparture(time, job, queue);
            }
        }
    }
}

