/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq;

import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jsimulation.r5.SimEventAction;

public abstract class SimJQEvent<J extends SimJob, Q extends SimQueue>
extends SimEntityEvent {
    private final Q queue;
    private final J job;

    protected SimJQEvent(String name, double time, Q queue, J job, SimEventAction<? extends SimEntity> action) {
        super(name, time, (SimEntity)(queue != null ? queue : job), action);
        this.queue = queue;
        this.job = job;
    }

    public abstract SimJQEvent<J, Q> copyForQueueAndJob(Q var1, J var2);

    public final Q getQueue() {
        return this.queue;
    }

    public final J getJob() {
        return this.job;
    }

    public static final class Departure<J extends SimJob, Q extends SimQueue>
    extends SimJQEvent<J, Q> {
        public Departure(J job, Q queue, double departureTime, SimEventAction<J> action) {
            super("Dep[" + job + "]@" + queue, departureTime, queue, job, action);
            if (action == null) {
                throw new IllegalArgumentException();
            }
        }

        public Departure(J job, Q queue, double departureTime) {
            super("Dep[" + job + "]@" + queue, departureTime, queue, job, null);
        }

        @Override
        public Departure<J, Q> copyForQueueAndJob(Q newQueue, J newJob) {
            if (this.getEventAction() != null && (newQueue != null && newQueue != this.getQueue() || newJob != null && newJob != this.getJob())) {
                throw new UnsupportedOperationException();
            }
            if (this.getEventAction() != null) {
                return new Departure<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.getEventAction());
            }
            return new Departure<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime());
        }
    }

    public static final class Start<J extends SimJob, Q extends SimQueue>
    extends SimJQEvent<J, Q> {
        public Start(J job, Q queue, double startTime, SimEventAction<J> action) {
            super("Start[" + job + "]@" + queue, startTime, queue, job, action);
            if (action == null) {
                throw new IllegalArgumentException();
            }
        }

        public Start(J job, Q queue, double startTime) {
            super("Start[" + job + "]@" + queue, startTime, queue, job, null);
        }

        @Override
        public Start<J, Q> copyForQueueAndJob(Q newQueue, J newJob) {
            if (this.getEventAction() != null && (newQueue != null && newQueue != this.getQueue() || newJob != null && newJob != this.getJob())) {
                throw new UnsupportedOperationException();
            }
            if (this.getEventAction() != null) {
                return new Start<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.getEventAction());
            }
            return new Start<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime());
        }
    }

    public static final class AutoRevocation<J extends SimJob, Q extends SimQueue>
    extends SimJQEvent<J, Q> {
        public AutoRevocation(J job, Q queue, double revocationTime, SimEventAction<J> action) {
            super("AutoRev[" + job + "]@" + queue, revocationTime, queue, job, action);
            if (action == null) {
                throw new IllegalArgumentException();
            }
        }

        public AutoRevocation(J job, Q queue, double revocationTime) {
            super("AutoRev[" + job + "]@" + queue, revocationTime, queue, job, null);
        }

        @Override
        public AutoRevocation<J, Q> copyForQueueAndJob(Q newQueue, J newJob) {
            if (this.getEventAction() != null && (newQueue != null && newQueue != this.getQueue() || newJob != null && newJob != this.getJob())) {
                throw new UnsupportedOperationException();
            }
            if (this.getEventAction() != null) {
                return new AutoRevocation<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.getEventAction());
            }
            return new AutoRevocation<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime());
        }
    }

    public static final class Revocation<J extends SimJob, Q extends SimQueue>
    extends SimJQEvent<J, Q> {
        private final boolean interruptService;

        private static <J extends SimJob, Q extends SimQueue> SimEventAction<J> createAction(J job, Q queue, boolean interruptService) {
            if (job == null || queue == null) {
                throw new IllegalArgumentException();
            }
            return event -> queue.revoke(event.getTime(), job, interruptService);
        }

        public Revocation(J job, Q queue, double revocationTime, boolean interruptService) {
            super("Rev[" + job + "]@" + queue, revocationTime, queue, job, Revocation.createAction(job, queue, interruptService));
            this.interruptService = interruptService;
        }

        @Override
        public Revocation<J, Q> copyForQueueAndJob(Q newQueue, J newJob) {
            return new Revocation<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.isInterruptService());
        }

        public final boolean isInterruptService() {
            return this.interruptService;
        }
    }

    public static final class Drop<J extends SimJob, Q extends SimQueue>
    extends SimJQEvent<J, Q> {
        public Drop(J job, Q queue, double dropTime, SimEventAction<J> action) {
            super("Drop[" + job + "]@" + queue, dropTime, queue, job, action);
            if (action == null) {
                throw new IllegalArgumentException();
            }
        }

        public Drop(J job, Q queue, double dropTime) {
            super("Drop[" + job + "]@" + queue, dropTime, queue, job, null);
        }

        @Override
        public Drop<J, Q> copyForQueueAndJob(Q newQueue, J newJob) {
            if (this.getEventAction() != null && (newQueue != null && newQueue != this.getQueue() || newJob != null && newJob != this.getJob())) {
                throw new UnsupportedOperationException();
            }
            if (this.getEventAction() != null) {
                return new Drop<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.getEventAction());
            }
            return new Drop<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime());
        }
    }

    public static final class Arrival<J extends SimJob, Q extends SimQueue>
    extends SimJQEvent<J, Q> {
        private static <J extends SimJob, Q extends SimQueue> SimEventAction<J> createAction(J job, Q queue) {
            if (job == null || queue == null) {
                throw new IllegalArgumentException();
            }
            return event -> queue.arrive(event.getTime(), job);
        }

        public Arrival(J job, Q queue, double arrivalTime) {
            super("Arr[" + job + "]@" + queue, arrivalTime, queue, job, Arrival.createAction(job, queue));
        }

        @Override
        public Arrival<J, Q> copyForQueueAndJob(Q newQueue, J newJob) {
            return new Arrival<J, Q>(newJob != null ? newJob : this.getJob(), newQueue != null ? newQueue : this.getQueue(), this.getTime());
        }
    }
}

