/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq;

import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntityEventScheduler;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jsimulation.r5.SimEventList;

public abstract class SimJQEventScheduler
extends SimEntityEventScheduler {
    protected SimJQEventScheduler() {
        throw new UnsupportedOperationException();
    }

    public static <J extends SimJob, Q extends SimQueue> void scheduleJQ(SimEventList eventList, boolean reset, double resetTime, Set<SimJQEvent<J, Q>> queueEvents) {
        if (eventList == null) {
            throw new IllegalArgumentException();
        }
        if (queueEvents != null && queueEvents.contains(null)) {
            throw new IllegalArgumentException();
        }
        if (reset) {
            eventList.reset(resetTime);
        }
        if (queueEvents != null) {
            for (SimJQEvent<J, Q> event : queueEvents) {
                SimJQEventScheduler.scheduleJQ(eventList, event);
            }
        }
    }

    public static <J extends SimJob, Q extends SimQueue> void scheduleJQ(SimEventList eventList, SimJQEvent<J, Q> queueEvent) {
        if (eventList == null || queueEvent == null) {
            throw new IllegalArgumentException();
        }
        double eventListTime = eventList.getTime();
        double eventTime = queueEvent.getTime();
        if (eventTime < eventListTime) {
            throw new IllegalArgumentException();
        }
        J job = queueEvent.getJob();
        if (job != null && job.getEventList() != null && job.getEventList() != eventList) {
            throw new IllegalArgumentException();
        }
        Q queue = queueEvent.getQueue();
        if (queue != null && queue.getEventList() != null && queue.getEventList() != eventList) {
            throw new IllegalArgumentException();
        }
        eventList.add(queueEvent);
    }

    public static <J extends SimJob, Q extends SimQueue> void scheduleJobArrival(J job, Q queue, double arrivalTime) {
        if (job == null || queue == null || queue.getEventList() == null) {
            throw new IllegalArgumentException();
        }
        SimJQEventScheduler.scheduleJQ(queue.getEventList(), new SimJQEvent.Arrival<J, Q>(job, queue, arrivalTime));
    }

    public static <J extends SimJob, Q extends SimQueue> void scheduleJobRevocation(J job, Q queue, double revocationTime, boolean interruptService) {
        if (job == null || queue == null || queue.getEventList() == null) {
            throw new IllegalArgumentException();
        }
        SimJQEventScheduler.scheduleJQ(queue.getEventList(), new SimJQEvent.Revocation<J, Q>(job, queue, revocationTime, interruptService));
    }
}

