/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq;

import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityOperation;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;

public interface SimJQOperation<J extends SimJob, Q extends SimQueue, O extends SimEntityOperation, Req extends SimEntityOperation.Request, Rep extends SimEntityOperation.Reply>
extends SimEntityOperation<O, Req, Rep> {

    public static final class RevocationReply
    implements SimEntityOperation.Reply<Revocation, RevocationRequest, RevocationReply> {
        private final boolean success;
        private final RevocationRequest request;

        public RevocationReply(RevocationRequest request, boolean success) {
            if (request == null) {
                throw new IllegalArgumentException();
            }
            this.request = request;
            this.success = success;
        }

        public final boolean isSuccess() {
            return this.success;
        }

        @Override
        public final Revocation getOperation() {
            return Revocation.INSTANCE;
        }

        @Override
        public final RevocationRequest getRequest() {
            return this.request;
        }
    }

    public static final class RevocationRequest
    extends RequestJQ<Revocation, RevocationRequest>
    implements SimEntityOperation.Request<Revocation, RevocationRequest> {
        private final boolean interruptService;

        public RevocationRequest(SimJob job, SimQueue queue, boolean interruptService) {
            super(job, queue);
            this.interruptService = interruptService;
        }

        public final boolean isInterruptService() {
            return this.interruptService;
        }

        @Override
        public final Revocation getOperation() {
            return Revocation.INSTANCE;
        }

        @Override
        public RevocationRequest forJob(SimJob job) {
            if (job == null) {
                throw new IllegalArgumentException();
            }
            return new RevocationRequest(job, this.getQueue(), this.isInterruptService());
        }

        @Override
        public RevocationRequest forQueue(SimQueue queue) {
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            return new RevocationRequest(this.getJob(), queue, this.isInterruptService());
        }

        @Override
        public RevocationRequest forJobAndQueue(SimJob job, SimQueue queue) {
            if (job == null || queue == null) {
                throw new IllegalArgumentException();
            }
            return new RevocationRequest(job, queue, this.isInterruptService());
        }
    }

    public static final class Revocation
    implements SimEntityOperation<Revocation, RevocationRequest, RevocationReply> {
        private static final Revocation INSTANCE = new Revocation();

        private Revocation() {
        }

        public final Object clone() throws CloneNotSupportedException {
            super.clone();
            throw new CloneNotSupportedException();
        }

        public static Revocation getInstance() {
            return INSTANCE;
        }

        @Override
        public final String getName() {
            return "Revocation";
        }

        @Override
        public final Class<RevocationRequest> getOperationRequestClass() {
            return RevocationRequest.class;
        }

        @Override
        public final Class<RevocationReply> getOperationReplyClass() {
            return RevocationReply.class;
        }

        @Override
        public final RevocationReply doOperation(double time, RevocationRequest request) {
            if (request == null || request.getJob() == null || request.getQueue() == null || request.getOperation() != Revocation.getInstance()) {
                throw new IllegalArgumentException();
            }
            boolean success = request.getQueue().revoke(time, request.getJob(), request.isInterruptService());
            return new RevocationReply(request, success);
        }
    }

    public static final class ArrivalReply
    implements SimEntityOperation.Reply<Arrival, ArrivalRequest, ArrivalReply> {
        private final ArrivalRequest request;

        public ArrivalReply(ArrivalRequest request) {
            if (request == null) {
                throw new IllegalArgumentException();
            }
            this.request = request;
        }

        @Override
        public final Arrival getOperation() {
            return Arrival.INSTANCE;
        }

        @Override
        public final ArrivalRequest getRequest() {
            return this.request;
        }
    }

    public static final class ArrivalRequest
    extends RequestJQ<Arrival, ArrivalRequest>
    implements SimEntityOperation.Request<Arrival, ArrivalRequest> {
        public ArrivalRequest(SimJob job, SimQueue queue) {
            super(job, queue);
        }

        @Override
        public final Arrival getOperation() {
            return Arrival.INSTANCE;
        }

        @Override
        public ArrivalRequest forJob(SimJob job) {
            if (job == null) {
                throw new IllegalArgumentException();
            }
            return new ArrivalRequest(job, this.getQueue());
        }

        @Override
        public ArrivalRequest forQueue(SimQueue queue) {
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            return new ArrivalRequest(this.getJob(), queue);
        }

        @Override
        public ArrivalRequest forJobAndQueue(SimJob job, SimQueue queue) {
            if (job == null || queue == null) {
                throw new IllegalArgumentException();
            }
            return new ArrivalRequest(job, queue);
        }
    }

    public static final class Arrival
    implements SimEntityOperation<Arrival, ArrivalRequest, ArrivalReply> {
        private static final Arrival INSTANCE = new Arrival();

        private Arrival() {
        }

        public final Object clone() throws CloneNotSupportedException {
            super.clone();
            throw new CloneNotSupportedException();
        }

        public static Arrival getInstance() {
            return INSTANCE;
        }

        @Override
        public final String getName() {
            return "Arrival";
        }

        @Override
        public final Class<ArrivalRequest> getOperationRequestClass() {
            return ArrivalRequest.class;
        }

        @Override
        public final Class<ArrivalReply> getOperationReplyClass() {
            return ArrivalReply.class;
        }

        @Override
        public final ArrivalReply doOperation(double time, ArrivalRequest request) {
            if (request == null || request.getJob() == null || request.getQueue() == null || request.getOperation() != Arrival.getInstance()) {
                throw new IllegalArgumentException();
            }
            request.getQueue().arrive(time, request.getJob());
            return new ArrivalReply(request);
        }
    }

    public static abstract class RequestJQ<O extends SimEntityOperation, Req extends RequestJQ>
    extends RequestJAndOrQ<O, Req> {
        public RequestJQ(SimJob job, SimQueue queue, boolean jobIsTarget) {
            super(job, queue, jobIsTarget);
            if (job == null || queue == null) {
                throw new IllegalArgumentException();
            }
        }

        public RequestJQ(SimJob job, SimQueue queue) {
            this(job, queue, false);
        }
    }

    public static abstract class RequestQ<O extends SimEntityOperation, Req extends RequestQ>
    extends RequestJAndOrQ<O, Req> {
        public RequestQ(SimQueue queue) {
            super(null, queue);
        }
    }

    public static abstract class RequestJ<O extends SimEntityOperation, Req extends RequestJ>
    extends RequestJAndOrQ<O, Req> {
        public RequestJ(SimJob job) {
            super(job, null);
        }
    }

    public static abstract class RequestJAndOrQ<O extends SimEntityOperation, Req extends RequestJAndOrQ>
    extends SimEntityOperation.RequestE<O, Req> {
        private final SimJob job;
        private final SimQueue queue;

        public RequestJAndOrQ(SimJob job, SimQueue queue, boolean jobIsTarget) {
            super((SimEntity)((Object)(jobIsTarget ? job : queue)));
            this.job = job;
            this.queue = queue;
        }

        public RequestJAndOrQ(SimJob job, SimQueue queue) {
            this(job, queue, queue == null);
        }

        public final SimJob getJob() {
            return this.job;
        }

        public final SimQueue getQueue() {
            return this.queue;
        }

        public abstract Req forJob(SimJob var1);

        public abstract Req forQueue(SimQueue var1);

        public abstract Req forJobAndQueue(SimJob var1, SimQueue var2);

        @Override
        public final Req forTargetEntity(SimEntity newTargetEntity) {
            if (newTargetEntity == null) {
                throw new IllegalArgumentException();
            }
            if (this.getTargetEntity() == null) {
                throw new IllegalStateException();
            }
            if (this.getTargetEntity() instanceof SimJob) {
                if (!(newTargetEntity instanceof SimJob)) {
                    throw new IllegalArgumentException();
                }
                if (this.getQueue() != null) {
                    return this.forJobAndQueue((SimJob)newTargetEntity, this.getQueue());
                }
                return this.forJob((SimJob)newTargetEntity);
            }
            if (this.getTargetEntity() instanceof SimQueue) {
                if (!(newTargetEntity instanceof SimQueue)) {
                    throw new IllegalArgumentException();
                }
                if (this.getJob() != null) {
                    return this.forJobAndQueue(this.getJob(), (SimQueue)newTargetEntity);
                }
                return this.forQueue((SimQueue)newTargetEntity);
            }
            throw new IllegalArgumentException();
        }
    }
}

