/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.job;

import java.util.HashMap;
import java.util.Map;
import org.javades.jqueues.r5.entity.jq.job.AbstractSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jsimulation.r5.SimEventList;

public class DefaultSimJob<J extends DefaultSimJob, Q extends SimQueue>
extends AbstractSimJob<J, Q>
implements SimJob<J, Q> {
    private final Map<Q, Double> requestedServiceTimeMap;
    public static final double DEFAULT_FALLBACK_REQUESTED_SERIVE_TIME = 1.0;
    private double fallbackRequestedServiceTime = 1.0;

    public DefaultSimJob(SimEventList eventList, String name, Map<Q, Double> requestedServiceTimeMap) {
        super(eventList, name);
        this.requestedServiceTimeMap = requestedServiceTimeMap != null ? new HashMap<Q, Double>(requestedServiceTimeMap) : new HashMap<Q, Double>();
    }

    public DefaultSimJob(SimEventList eventList, String name, double requestedServiceTime) {
        this(eventList, name, null);
        this.setFallbackRequestedServiceTime(requestedServiceTime);
    }

    public final double getFallbackRequestedServiceTime() {
        return this.fallbackRequestedServiceTime;
    }

    public final void setFallbackRequestedServiceTime(double fallbackRequestedServiceTime) {
        if (fallbackRequestedServiceTime < 0.0) {
            throw new IllegalArgumentException();
        }
        this.fallbackRequestedServiceTime = fallbackRequestedServiceTime;
    }

    @Override
    public double getServiceTime(Q queue) {
        if (queue == null) {
            if (this.getQueue() != null) {
                return this.getServiceTime(this.getQueue());
            }
            return 0.0;
        }
        if (this.requestedServiceTimeMap != null && this.requestedServiceTimeMap.containsKey(queue)) {
            return this.requestedServiceTimeMap.get(queue);
        }
        if (this.requestedServiceTimeMap != null && this.requestedServiceTimeMap.containsKey(null)) {
            return this.requestedServiceTimeMap.get(null);
        }
        return this.fallbackRequestedServiceTime;
    }

    public void setRequestedServiceTimeMappingForQueue(Q queue, double serviceTime) {
        if (queue == null || serviceTime < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.getQueue() == queue) {
            throw new IllegalStateException();
        }
        this.requestedServiceTimeMap.put(queue, serviceTime);
    }
}

