/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.job.visitslogging;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.selflistening.DefaultSelfListeningSimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jsimulation.r5.SimEventList;

public class DefaultVisitsLoggingSimJob<J extends DefaultVisitsLoggingSimJob, Q extends SimQueue>
extends DefaultSelfListeningSimJob<J, Q> {
    private final TreeMap<Double, TreeMap<Integer, JobQueueVisitLog>> visitLogs = new TreeMap();

    public DefaultVisitsLoggingSimJob(SimEventList eventList, String name, Map<Q, Double> requestedServiceTimeMap) {
        super(eventList, name, requestedServiceTimeMap);
    }

    public DefaultVisitsLoggingSimJob(SimEventList eventList, String name, double requestedServiceTime) {
        super(eventList, name, requestedServiceTime);
    }

    public final TreeMap<Double, TreeMap<Integer, JobQueueVisitLog>> getVisitLogs() {
        return new TreeMap<Double, TreeMap<Integer, JobQueueVisitLog>>((SortedMap<Double, TreeMap<Integer, JobQueueVisitLog>>)this.visitLogs);
    }

    public final void reset() {
        this.visitLogs.clear();
    }

    @Override
    public final void notifyResetEntity(SimEntity entity) {
    }

    @Override
    public final void notifyUpdate(double time, SimEntity entity) {
    }

    @Override
    public final void notifyStateChanged(double time, SimEntity entity, List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> notifications) {
    }

    @Override
    public final void notifyArrival(double time, J job, Q queue) {
        if (job == this) {
            double arrivalTime = time;
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            if (!this.visitLogs.containsKey(arrivalTime)) {
                this.visitLogs.put(arrivalTime, new TreeMap());
            }
            int newSeqKey = this.visitLogs.get(arrivalTime).isEmpty() ? 0 : this.visitLogs.get(arrivalTime).lastKey() + 1;
            JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q> visitLog = new JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q>(this, queue, true, arrivalTime, newSeqKey, false, Double.NaN, false, Double.NaN, false, Double.NaN, false, Double.NaN);
            this.visitLogs.get(arrivalTime).put(newSeqKey, visitLog);
        }
    }

    @Override
    public final void notifyStart(double time, J job, Q queue) {
        if (job == this) {
            double startTime = time;
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            if (this.visitLogs.isEmpty()) {
                throw new IllegalStateException();
            }
            if (this.visitLogs.lastEntry().getValue().isEmpty()) {
                throw new IllegalStateException();
            }
            Map.Entry<Integer, JobQueueVisitLog> oldVisitLogEntry = this.visitLogs.lastEntry().getValue().lastEntry();
            int oldVisitLogSequenceNumber = oldVisitLogEntry.getKey();
            JobQueueVisitLog oldVisitLog = oldVisitLogEntry.getValue();
            if (!oldVisitLog.arrived || oldVisitLog.started || startTime < oldVisitLog.arrivalTime || oldVisitLog.dropped || oldVisitLog.revoked || oldVisitLog.departed || oldVisitLog.queue != queue || oldVisitLog.job != this) {
                throw new IllegalStateException();
            }
            double arrivalTime = oldVisitLog.arrivalTime;
            int seqNo = oldVisitLog.sequenceNumber;
            JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q> visitLog = new JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q>(this, queue, true, arrivalTime, seqNo, true, startTime, false, Double.NaN, false, Double.NaN, false, Double.NaN);
            this.visitLogs.lastEntry().getValue().put(oldVisitLogSequenceNumber, visitLog);
        }
    }

    @Override
    public final void notifyDrop(double time, J job, Q queue) {
        if (job == this) {
            double dropTime = time;
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            if (this.visitLogs.isEmpty()) {
                throw new IllegalStateException();
            }
            if (this.visitLogs.lastEntry().getValue().isEmpty()) {
                throw new IllegalStateException();
            }
            Map.Entry<Integer, JobQueueVisitLog> oldVisitLogEntry = this.visitLogs.lastEntry().getValue().lastEntry();
            int oldVisitLogSequenceNumber = oldVisitLogEntry.getKey();
            JobQueueVisitLog oldVisitLog = oldVisitLogEntry.getValue();
            if (!oldVisitLog.arrived || dropTime < oldVisitLog.arrivalTime || oldVisitLog.dropped || oldVisitLog.revoked || oldVisitLog.departed || oldVisitLog.queue != queue || oldVisitLog.job != this) {
                throw new IllegalStateException();
            }
            double arrivalTime = oldVisitLog.arrivalTime;
            int seqNo = oldVisitLog.sequenceNumber;
            boolean started = oldVisitLog.started;
            double startTime = oldVisitLog.startTime;
            JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q> visitLog = new JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q>(this, queue, true, arrivalTime, seqNo, started, startTime, true, dropTime, false, Double.NaN, false, Double.NaN);
            this.visitLogs.lastEntry().getValue().put(oldVisitLogSequenceNumber, visitLog);
        }
    }

    @Override
    public final void notifyRevocation(double time, J job, Q queue) {
        if (job == this) {
            double revocationTime = time;
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            if (this.visitLogs.isEmpty()) {
                throw new IllegalStateException();
            }
            if (this.visitLogs.lastEntry().getValue().isEmpty()) {
                throw new IllegalStateException();
            }
            Map.Entry<Integer, JobQueueVisitLog> oldVisitLogEntry = this.visitLogs.lastEntry().getValue().lastEntry();
            int oldVisitLogSequenceNumber = oldVisitLogEntry.getKey();
            JobQueueVisitLog oldVisitLog = oldVisitLogEntry.getValue();
            if (!oldVisitLog.arrived || revocationTime < oldVisitLog.arrivalTime || oldVisitLog.dropped || oldVisitLog.revoked || oldVisitLog.departed || oldVisitLog.queue != queue || oldVisitLog.job != this) {
                throw new IllegalStateException();
            }
            double arrivalTime = oldVisitLog.arrivalTime;
            int seqNo = oldVisitLog.sequenceNumber;
            boolean started = oldVisitLog.started;
            double startTime = oldVisitLog.startTime;
            JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q> visitLog = new JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q>(this, queue, true, arrivalTime, seqNo, started, startTime, false, Double.NaN, true, revocationTime, false, Double.NaN);
            this.visitLogs.lastEntry().getValue().put(oldVisitLogSequenceNumber, visitLog);
        }
    }

    @Override
    public final void notifyAutoRevocation(double time, J job, Q queue) {
        this.notifyRevocation(time, job, queue);
    }

    @Override
    public final void notifyDeparture(double time, J job, Q queue) {
        if (job == this) {
            double departureTime = time;
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            if (this.visitLogs.isEmpty()) {
                throw new IllegalStateException();
            }
            if (this.visitLogs.lastEntry().getValue().isEmpty()) {
                throw new IllegalStateException();
            }
            Map.Entry<Integer, JobQueueVisitLog> oldVisitLogEntry = this.visitLogs.lastEntry().getValue().lastEntry();
            int oldVisitLogSequenceNumber = oldVisitLogEntry.getKey();
            JobQueueVisitLog oldVisitLog = oldVisitLogEntry.getValue();
            if (!oldVisitLog.arrived || departureTime < oldVisitLog.arrivalTime || oldVisitLog.dropped || oldVisitLog.revoked || oldVisitLog.departed || oldVisitLog.queue != queue || oldVisitLog.job != this) {
                throw new IllegalStateException();
            }
            double arrivalTime = oldVisitLog.arrivalTime;
            int seqNo = oldVisitLog.sequenceNumber;
            boolean started = oldVisitLog.started;
            double startTime = oldVisitLog.startTime;
            JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q> visitLog = new JobQueueVisitLog<DefaultVisitsLoggingSimJob, Q>(this, queue, true, arrivalTime, seqNo, started, startTime, false, Double.NaN, false, Double.NaN, true, departureTime);
            this.visitLogs.lastEntry().getValue().put(oldVisitLogSequenceNumber, visitLog);
        }
    }
}

