/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.job.visitslogging;

import java.io.PrintStream;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;

public class JobQueueVisitLog<J extends SimJob, Q extends SimQueue> {
    public final J job;
    public final Q queue;
    public final boolean arrived;
    public final double arrivalTime;
    public final int sequenceNumber;
    public final boolean started;
    public final double startTime;
    public final boolean dropped;
    public final double dropTime;
    public final boolean revoked;
    public final double revocationTime;
    public final boolean departed;
    public final double departureTime;

    public JobQueueVisitLog(J job, Q queue, boolean arrived, double arrivalTime, int sequenceNumber, boolean started, double startTime, boolean dropped, double dropTime, boolean revoked, double revocationTime, boolean departed, double departureTime) {
        if (job == null || queue == null) {
            throw new IllegalArgumentException();
        }
        if (!arrived && (started || dropped || revoked || departed)) {
            throw new IllegalArgumentException();
        }
        if (arrived && (dropped && revoked || dropped && departed || revoked && departed)) {
            throw new IllegalArgumentException();
        }
        if (arrived && started && startTime < arrivalTime) {
            throw new IllegalArgumentException();
        }
        if (arrived && dropped && dropTime < arrivalTime) {
            throw new IllegalArgumentException();
        }
        if (arrived && revoked && revocationTime < arrivalTime) {
            throw new IllegalArgumentException();
        }
        if (arrived && departed && departureTime < arrivalTime) {
            throw new IllegalArgumentException();
        }
        if (arrived && started && dropped && dropTime < startTime) {
            throw new IllegalArgumentException();
        }
        if (arrived && started && revoked && revocationTime < startTime) {
            throw new IllegalArgumentException();
        }
        if (arrived && started && departed && departureTime < startTime) {
            throw new IllegalArgumentException();
        }
        if (sequenceNumber < 0) {
            throw new IllegalArgumentException();
        }
        this.job = job;
        this.queue = queue;
        this.arrived = arrived;
        this.arrivalTime = arrivalTime;
        this.sequenceNumber = sequenceNumber;
        this.started = started;
        this.startTime = startTime;
        this.dropped = dropped;
        this.dropTime = dropTime;
        this.revoked = revoked;
        this.revocationTime = revocationTime;
        this.departed = departed;
        this.departureTime = departureTime;
    }

    public <R extends SimQueue> JobQueueVisitLog<J, R> copyForQueue(R destQueue) {
        if (destQueue == null) {
            throw new IllegalArgumentException();
        }
        return new JobQueueVisitLog<J, R>(this.job, destQueue, this.arrived, this.arrivalTime, this.sequenceNumber, this.started, this.startTime, this.dropped, this.dropTime, this.revoked, this.revocationTime, this.departed, this.departureTime);
    }

    public boolean equals(JobQueueVisitLog object, double accuracy) {
        if (accuracy < 0.0) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.job != object.job) {
            return false;
        }
        if (this.queue != object.queue) {
            return false;
        }
        if (this.arrived != object.arrived) {
            return false;
        }
        if (this.arrived && Math.abs(this.arrivalTime - object.arrivalTime) > accuracy) {
            return false;
        }
        if (this.sequenceNumber != object.sequenceNumber) {
            return false;
        }
        if (this.started != object.started) {
            return false;
        }
        if (this.started && Math.abs(this.startTime - object.startTime) > accuracy) {
            return false;
        }
        if (this.dropped != object.dropped) {
            return false;
        }
        if (this.dropped && Math.abs(this.dropTime - object.dropTime) > accuracy) {
            return false;
        }
        if (this.revoked != object.revoked) {
            return false;
        }
        if (this.revoked && Math.abs(this.revocationTime - object.revocationTime) > accuracy) {
            return false;
        }
        if (this.departed != object.departed) {
            return false;
        }
        return !this.departed || !(Math.abs(this.departureTime - object.departureTime) > accuracy);
    }

    public void print(PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        out.println("Visit Log: job=" + this.job + "@queue=" + this.queue + ":");
        out.println("  Arrived : " + this.arrived + (this.arrived ? "@" + Double.toString(this.arrivalTime) : "") + ".");
        out.println("  SeqNo   : " + this.sequenceNumber + ".");
        out.println("  Started : " + this.started + (this.started ? "@" + Double.toString(this.startTime) : "") + ".");
        out.println("  Dropped : " + this.dropped + (this.dropped ? "@" + Double.toString(this.dropTime) : "") + ".");
        out.println("  Revoked : " + this.revoked + (this.revoked ? "@" + Double.toString(this.revocationTime) : "") + ".");
        out.println("  Departed: " + this.departed + (this.departed ? "@" + Double.toString(this.departureTime) : "") + ".");
    }

    public static <J extends SimJob, Q extends SimQueue> void addDroppedJob(Set<JobQueueVisitLog<J, Q>> visitLogs, Q queue, J job, double arrivalTime, boolean started, double startTime, double dropTime) {
        if (visitLogs == null || queue == null || job == null || dropTime < arrivalTime || started && startTime < arrivalTime || started && dropTime < startTime) {
            throw new IllegalArgumentException();
        }
        visitLogs.add(new JobQueueVisitLog<J, Q>(job, queue, true, arrivalTime, 0, started, startTime, true, dropTime, false, Double.NaN, false, Double.NaN));
    }

    public static <J extends SimJob, Q extends SimQueue> void addRevokedJob(Set<JobQueueVisitLog<J, Q>> visitLogs, Q queue, J job, double arrivalTime, boolean started, double startTime, double revocationTime) {
        if (visitLogs == null || queue == null || job == null || revocationTime < arrivalTime || started && startTime < arrivalTime || started && revocationTime < startTime) {
            throw new IllegalArgumentException();
        }
        visitLogs.add(new JobQueueVisitLog<J, Q>(job, queue, true, arrivalTime, 0, started, startTime, false, Double.NaN, true, revocationTime, false, Double.NaN));
    }

    public static <J extends SimJob, Q extends SimQueue> void addDepartedJob(Set<JobQueueVisitLog<J, Q>> visitLogs, Q queue, J job, double arrivalTime, boolean started, double startTime, double departureTime) {
        if (visitLogs == null || queue == null || job == null || departureTime < arrivalTime || started && startTime < arrivalTime || started && startTime > departureTime) {
            throw new IllegalArgumentException();
        }
        visitLogs.add(new JobQueueVisitLog<J, Q>(job, queue, true, arrivalTime, 0, started, startTime, false, Double.NaN, false, Double.NaN, true, departureTime));
    }

    public static <J extends SimJob, Q extends SimQueue> void addStickyJob(Set<JobQueueVisitLog<J, Q>> visitLogs, Q queue, J job, double arrivalTime, boolean started, double startTime) {
        if (visitLogs == null || queue == null || job == null || started && startTime < arrivalTime) {
            throw new IllegalArgumentException();
        }
        visitLogs.add(new JobQueueVisitLog<J, Q>(job, queue, true, arrivalTime, 0, started, startTime, false, Double.NaN, false, Double.NaN, false, Double.NaN));
    }
}

