/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntityListener;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.AbstractSimJQ;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQEventScheduler;
import org.javades.jqueues.r5.entity.jq.SimJQOperation;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueListener;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueOperation;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.listener.StdOutSimQueueListener;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventList;

public abstract class AbstractSimQueue<J extends SimJob, Q extends AbstractSimQueue>
extends AbstractSimJQ<J, Q>
implements SimQueue<J, Q> {
    protected static final boolean SANITY = true;
    private final StdOutSimQueueListener<J, Q> stdOutSimQueueListener = new StdOutSimQueueListener();
    private SimQueue.AutoRevocationPolicy autoRevocationPolicy = SimQueue.AutoRevocationPolicy.NONE;
    private final Set<J> jobs = new LinkedHashSet<J>();
    private final Set<J> jobsInWaitingArea = new LinkedHashSet<J>();
    private final Set<J> jobsInServiceArea = new LinkedHashSet<J>();
    protected final Set<SimEvent> eventsScheduled = new HashSet<SimEvent>();
    private boolean previousStartArmedSet = false;
    private boolean previousStartArmed = false;
    private boolean isQueueAccessVacation = false;
    private int serverAccessCredits = Integer.MAX_VALUE;
    private boolean previousSacAvailability = true;

    protected AbstractSimQueue(SimEventList eventList) {
        super(eventList);
        this.registerOperation(SimQueueOperation.QueueAccessVacation.getInstance());
        this.registerOperation(SimJQOperation.Arrival.getInstance());
        this.registerOperation(SimJQOperation.Revocation.getInstance());
        this.registerOperation(SimQueueOperation.ServerAccessCredits.getInstance());
        this.registerPreEventHook(this::setInitStartArmed);
        this.registerPreNotificationHook(this::serverAccessCreditsPreNotificationHook);
        this.registerPreNotificationHook(this::startArmedPreNotificationHook);
        this.registerNotificationType(SimQueueSimpleEventType.QAV_START, this::fireStartQueueAccessVacation);
        this.registerNotificationType(SimQueueSimpleEventType.QAV_END, this::fireStopQueueAccessVacation);
        this.registerNotificationType(SimQueueSimpleEventType.OUT_OF_SAC, this::fireOutOfServerAccessCredits);
        this.registerNotificationType(SimQueueSimpleEventType.REGAINED_SAC, this::fireRegainedServerAccessCredits);
        this.registerNotificationType(SimQueueSimpleEventType.STA_FALSE, this::fireLostStartArmed);
        this.registerNotificationType(SimQueueSimpleEventType.STA_TRUE, this::fireRegainedStartArmed);
    }

    @Override
    public String toStringDefault() {
        return "AbstractSimQueue";
    }

    public final void registerStdOutSimQueueListener() {
        this.registerSimEntityListener(this.stdOutSimQueueListener);
    }

    public final void unregisterStdOutSimQueueListener() {
        this.unregisterSimEntityListener(this.stdOutSimQueueListener);
    }

    @Override
    public final SimQueue.AutoRevocationPolicy getAutoRevocationPolicy() {
        return this.autoRevocationPolicy;
    }

    @Override
    public final void setAutoRevocationPolicy(SimQueue.AutoRevocationPolicy autoRevocationPolicy) {
        if (autoRevocationPolicy == null) {
            throw new IllegalArgumentException();
        }
        this.autoRevocationPolicy = autoRevocationPolicy;
    }

    @Override
    public final Set<J> getJobs() {
        return this.jobs;
    }

    @Override
    public final int getNumberOfJobs() {
        return this.jobs.size();
    }

    @Override
    public final boolean isJob(SimJob job) {
        return job != null && this.jobs.contains(job);
    }

    protected final boolean hasJobs() {
        return !this.jobs.isEmpty();
    }

    protected final J getFirstJob() {
        if (this.jobs.isEmpty()) {
            return null;
        }
        return (J)((SimJob)this.jobs.iterator().next());
    }

    @Override
    public final Set<J> getJobsInWaitingArea() {
        return this.jobsInWaitingArea;
    }

    @Override
    public final int getNumberOfJobsInWaitingArea() {
        return this.jobsInWaitingArea.size();
    }

    @Override
    public final boolean isJobInWaitingArea(SimJob job) {
        return job != null && this.jobsInWaitingArea.contains(job);
    }

    protected final boolean hasJobsInWaitingArea() {
        return !this.jobsInWaitingArea.isEmpty();
    }

    protected final J getFirstJobInWaitingArea() {
        if (this.jobsInWaitingArea.isEmpty()) {
            return null;
        }
        return (J)((SimJob)this.jobsInWaitingArea.iterator().next());
    }

    @Override
    public final Set<J> getJobsInServiceArea() {
        return this.jobsInServiceArea;
    }

    @Override
    public final int getNumberOfJobsInServiceArea() {
        return this.jobsInServiceArea.size();
    }

    @Override
    public final boolean isJobInServiceArea(SimJob job) {
        return job != null && this.jobsInServiceArea.contains(job);
    }

    protected final boolean hasJobsInServiceArea() {
        return !this.jobsInServiceArea.isEmpty();
    }

    protected final J getFirstJobInServiceArea() {
        if (this.jobsInServiceArea.isEmpty()) {
            return null;
        }
        return (J)((SimJob)this.jobsInServiceArea.iterator().next());
    }

    @Override
    protected void resetEntitySubClass() {
        super.resetEntitySubClass();
        for (SimJob j : this.jobs) {
            j.setQueue(null);
        }
        this.jobs.clear();
        this.jobsInWaitingArea.clear();
        this.jobsInServiceArea.clear();
        for (SimEvent e : this.eventsScheduled) {
            this.getEventList().remove((Object)e);
        }
        this.eventsScheduled.clear();
        this.previousStartArmedSet = false;
        this.isQueueAccessVacation = false;
        this.serverAccessCredits = Integer.MAX_VALUE;
        this.previousSacAvailability = true;
    }

    private void setInitStartArmed(double newTime) {
        if (!this.previousStartArmedSet) {
            this.previousStartArmedSet = true;
            this.previousStartArmed = this.isStartArmed();
        }
    }

    private void startArmedPreNotificationHook(List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> pendingNotifications) {
        if (pendingNotifications == null) {
            throw new IllegalArgumentException();
        }
        if (!this.previousStartArmedSet) {
            this.setInitStartArmed(this.getLastUpdateTime());
        }
        boolean startArmed = this.isStartArmed();
        Iterator<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> i_pendingNotifications = pendingNotifications.iterator();
        boolean hasStaNotification = false;
        while (i_pendingNotifications.hasNext()) {
            SimEntitySimpleEventType.Member notificationType = i_pendingNotifications.next().keySet().iterator().next();
            if (notificationType != SimQueueSimpleEventType.STA_FALSE && notificationType != SimQueueSimpleEventType.STA_TRUE) continue;
            if (notificationType == SimQueueSimpleEventType.STA_TRUE != startArmed) {
                throw new IllegalArgumentException();
            }
            i_pendingNotifications.remove();
            hasStaNotification = true;
        }
        if (hasStaNotification || startArmed != this.previousStartArmed) {
            double time = this.getLastUpdateTime();
            if (startArmed) {
                pendingNotifications.add(Collections.singletonMap(SimQueueSimpleEventType.STA_TRUE, new SimQueueEvent.StartArmed(this, time, true)));
            } else {
                pendingNotifications.add(Collections.singletonMap(SimQueueSimpleEventType.STA_FALSE, new SimQueueEvent.StartArmed(this, time, false)));
            }
        }
        this.previousStartArmed = startArmed;
    }

    protected final void triggerPotentialNewStartArmed(double time) {
        boolean isTopLevel;
        boolean startArmed = this.isStartArmed();
        if ((!this.previousStartArmedSet || startArmed != this.previousStartArmed) && (isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked())) {
            this.update(time);
            this.previousStartArmedSet = true;
            this.previousStartArmed = startArmed;
            this.addPendingNotification(startArmed ? SimQueueSimpleEventType.STA_TRUE : SimQueueSimpleEventType.STA_FALSE, null);
            this.fireAndLockPendingNotifications();
        }
    }

    @Override
    public final void arrive(double time, J job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (job.getQueue() != null) {
            throw new IllegalArgumentException();
        }
        if (this.isJob((SimJob)job) || this.isJobInWaitingArea((SimJob)job) || this.isJobInServiceArea((SimJob)job)) {
            throw new RuntimeException();
        }
        this.update(time);
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        if (!isTopLevel) {
            throw new IllegalStateException();
        }
        this.addPendingNotification(SimQueueSimpleEventType.ARRIVAL, new SimJQEvent.Arrival<J, AbstractSimQueue>(job, this, time));
        if (this.isQueueAccessVacation) {
            this.addPendingNotification(SimQueueSimpleEventType.DROP, new SimJQEvent.Drop<J, AbstractSimQueue>(job, this, time));
            this.queueAccessVacationDropSubClass(time, job);
        } else {
            this.insertJobInQueueUponArrival(job, time);
            this.jobs.add(job);
            this.jobsInWaitingArea.add(job);
            job.setQueue((AbstractSimQueue)this);
            this.rescheduleAfterArrival(job, time);
            if (!this.isJob((SimJob)job) && (this.isJobInWaitingArea((SimJob)job) || this.isJobInServiceArea((SimJob)job) || job.getQueue() == this)) {
                throw new IllegalStateException();
            }
            if (this.isJob((SimJob)job) && this.isJobInWaitingArea((SimJob)job) == this.isJobInServiceArea((SimJob)job)) {
                throw new IllegalStateException();
            }
        }
        this.fireAndLockPendingNotifications();
    }

    protected abstract void insertJobInQueueUponArrival(J var1, double var2);

    protected abstract void rescheduleAfterArrival(J var1, double var2);

    public final void scheduleJobArrival(double time, J job) {
        if (time < this.getLastUpdateTime() || time < this.getEventList().getTime() || job == null) {
            throw new IllegalArgumentException();
        }
        SimJQEventScheduler.scheduleJobArrival(job, this, time);
    }

    @Override
    public final boolean isQueueAccessVacation() {
        return this.isQueueAccessVacation;
    }

    @Override
    public final void setQueueAccessVacation(double time, boolean start) {
        if (this.isQueueAccessVacation != start) {
            this.update(time);
            boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
            if (!isTopLevel) {
                throw new IllegalStateException();
            }
            this.isQueueAccessVacation = start;
            if (this.isQueueAccessVacation) {
                this.addPendingNotification(SimQueueSimpleEventType.QAV_START, new SimQueueEvent.QueueAccessVacation(this, time, true));
            } else {
                this.addPendingNotification(SimQueueSimpleEventType.QAV_END, new SimQueueEvent.QueueAccessVacation(this, time, false));
            }
            this.fireAndLockPendingNotifications();
        }
    }

    protected void queueAccessVacationDropSubClass(double time, J job) {
    }

    protected final void drop(J job, double time) {
        if (job == null || job.getQueue() != this || !this.isJob((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        if (this.isJobInWaitingArea((SimJob)job) == this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalStateException();
        }
        if (time != this.getLastUpdateTime()) {
            throw new IllegalStateException();
        }
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        if (isTopLevel) {
            throw new IllegalStateException();
        }
        this.removeJobFromQueueUponDrop(job, time);
        this.jobs.remove(job);
        this.jobsInWaitingArea.remove(job);
        this.jobsInServiceArea.remove(job);
        job.setQueue(null);
        this.addPendingNotification(SimQueueSimpleEventType.DROP, new SimJQEvent.Drop<J, AbstractSimQueue>(job, this, time));
        this.rescheduleAfterDrop(job, time);
    }

    protected abstract void removeJobFromQueueUponDrop(J var1, double var2);

    protected abstract void rescheduleAfterDrop(J var1, double var2);

    @Override
    public final boolean revoke(double time, J job, boolean interruptService) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job)) {
            if (job.getQueue() == this) {
                throw new IllegalStateException();
            }
            return false;
        }
        if (this.isJobInWaitingArea((SimJob)job) == this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalStateException();
        }
        if (!interruptService && this.isJobInServiceArea((SimJob)job)) {
            return false;
        }
        this.update(time);
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        if (!isTopLevel) {
            throw new IllegalStateException();
        }
        this.removeJobFromQueueUponRevokation(job, time, false);
        this.jobs.remove(job);
        this.jobsInWaitingArea.remove(job);
        this.jobsInServiceArea.remove(job);
        job.setQueue(null);
        this.addPendingNotification(SimQueueSimpleEventType.REVOCATION, new SimJQEvent.Revocation<J, AbstractSimQueue>(job, this, time, interruptService));
        this.rescheduleAfterRevokation(job, time, false);
        this.fireAndLockPendingNotifications();
        return true;
    }

    @Override
    public final void revoke(double time, J job) {
        SimQueue.super.revoke(time, job);
    }

    protected final void autoRevoke(double time, J job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job) && job.getQueue() == this) {
            throw new IllegalStateException();
        }
        if (time != this.getLastUpdateTime()) {
            throw new IllegalStateException();
        }
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        if (isTopLevel) {
            throw new IllegalStateException();
        }
        this.removeJobFromQueueUponRevokation(job, time, true);
        this.jobs.remove(job);
        this.jobsInWaitingArea.remove(job);
        this.jobsInServiceArea.remove(job);
        job.setQueue(null);
        this.addPendingNotification(SimQueueSimpleEventType.AUTO_REVOCATION, new SimJQEvent.AutoRevocation<J, AbstractSimQueue>(job, this, time));
        this.rescheduleAfterRevokation(job, time, true);
    }

    protected abstract void removeJobFromQueueUponRevokation(J var1, double var2, boolean var4);

    protected abstract void rescheduleAfterRevokation(J var1, double var2, boolean var4);

    @Override
    public final int getServerAccessCredits() {
        return this.serverAccessCredits;
    }

    @Override
    public final void setServerAccessCredits(double time, int credits) {
        if (credits < 0) {
            throw new IllegalArgumentException();
        }
        int oldCredits = this.serverAccessCredits;
        if (oldCredits != credits) {
            boolean needsNotification;
            this.update(time);
            this.serverAccessCredits = credits;
            boolean lostCredits = oldCredits > 0 && this.serverAccessCredits == 0;
            boolean regainedCredits = oldCredits == 0 && this.serverAccessCredits > 0;
            boolean bl = needsNotification = lostCredits || regainedCredits;
            if (needsNotification) {
                boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
                if (!isTopLevel) {
                    throw new IllegalStateException();
                }
                if (regainedCredits) {
                    this.rescheduleForNewServerAccessCredits(time);
                }
                this.setServerAccessCreditsSubClass();
                this.fireAndLockPendingNotifications();
            } else {
                this.setServerAccessCreditsSubClass();
            }
        }
    }

    protected final boolean hasServerAcccessCredits() {
        return this.serverAccessCredits > 0;
    }

    protected final void takeServerAccessCredit() {
        if (this.serverAccessCredits <= 0) {
            throw new IllegalStateException("queue=" + this + ", t=" + this.getLastUpdateTime() + ", sac=" + this.serverAccessCredits + ".");
        }
        if (this.serverAccessCredits < Integer.MAX_VALUE) {
            --this.serverAccessCredits;
        }
    }

    protected abstract void rescheduleForNewServerAccessCredits(double var1);

    protected void setServerAccessCreditsSubClass() {
    }

    private void serverAccessCreditsPreNotificationHook(List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> pendingNotifications) {
        if (pendingNotifications == null) {
            throw new IllegalArgumentException();
        }
        for (Map<SimEntitySimpleEventType.Member, SimEntityEvent> entry : pendingNotifications) {
            SimEntitySimpleEventType.Member notificationType = entry.keySet().iterator().next();
            if (notificationType != SimQueueSimpleEventType.OUT_OF_SAC && notificationType != SimQueueSimpleEventType.REGAINED_SAC) continue;
            throw new IllegalArgumentException();
        }
        boolean sacAvailability = this.hasServerAcccessCredits();
        if (sacAvailability != this.previousSacAvailability) {
            double time = this.getLastUpdateTime();
            int sac = this.getServerAccessCredits();
            if (sacAvailability) {
                pendingNotifications.add(Collections.singletonMap(SimQueueSimpleEventType.REGAINED_SAC, new SimQueueEvent.ServerAccessCredits(this, time, sac)));
            } else {
                pendingNotifications.add(Collections.singletonMap(SimQueueSimpleEventType.OUT_OF_SAC, new SimQueueEvent.ServerAccessCredits(this, time, sac)));
            }
        }
        this.previousSacAvailability = sacAvailability;
    }

    protected final void start(double time, J job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (job.getQueue() != this) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job)) {
            throw new RuntimeException();
        }
        if (!this.isJobInWaitingArea((SimJob)job)) {
            throw new RuntimeException();
        }
        if (this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalStateException();
        }
        if (time != this.getLastUpdateTime()) {
            throw new IllegalStateException();
        }
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        if (isTopLevel) {
            throw new IllegalStateException();
        }
        this.takeServerAccessCredit();
        if (this.autoRevocationPolicy == SimQueue.AutoRevocationPolicy.UPON_START) {
            this.addPendingNotification(SimQueueSimpleEventType.START, new SimJQEvent.Start<J, AbstractSimQueue>(job, this, time));
            this.autoRevoke(time, job);
        } else {
            this.insertJobInQueueUponStart(job, time);
            this.jobsInWaitingArea.remove(job);
            this.jobsInServiceArea.add(job);
            this.addPendingNotification(SimQueueSimpleEventType.START, new SimJQEvent.Start<J, AbstractSimQueue>(job, this, time));
            this.rescheduleAfterStart(job, time);
        }
    }

    protected abstract void insertJobInQueueUponStart(J var1, double var2);

    protected abstract void rescheduleAfterStart(J var1, double var2);

    protected double getServiceTimeForJob(J job) {
        return job.getServiceTime((AbstractSimQueue)this);
    }

    protected final void departureFromEventList(SimJQEvent.Departure<J, Q> event) {
        if (event == null) {
            throw new RuntimeException();
        }
        if (!this.eventsScheduled.contains(event)) {
            throw new IllegalStateException();
        }
        this.eventsScheduled.remove(event);
        double time = event.getTime();
        this.update(time);
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        if (!isTopLevel) {
            throw new IllegalStateException();
        }
        Object job = event.getJob();
        this.depart(time, job);
        this.fireAndLockPendingNotifications();
    }

    protected final void depart(double time, J job) {
        if (!this.isJob((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        if (job.getQueue() != this) {
            throw new IllegalStateException();
        }
        if (time != this.getLastUpdateTime()) {
            throw new IllegalStateException();
        }
        if (this.isJobInWaitingArea((SimJob)job) == this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalStateException();
        }
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        if (isTopLevel) {
            throw new IllegalStateException();
        }
        this.removeJobFromQueueUponDeparture(job, time);
        this.jobs.remove(job);
        this.jobsInWaitingArea.remove(job);
        this.jobsInServiceArea.remove(job);
        job.setQueue(null);
        this.addPendingNotification(SimQueueSimpleEventType.DEPARTURE, new SimJQEvent.Departure<J, AbstractSimQueue>(job, this, time));
        this.rescheduleAfterDeparture(job, time);
    }

    protected abstract void removeJobFromQueueUponDeparture(J var1, double var2);

    protected abstract void rescheduleAfterDeparture(J var1, double var2);

    protected final SimJQEvent.Departure<J, Q> scheduleDepartureEvent(double time, J job) {
        if (time < this.getLastUpdateTime() || job == null || job.getQueue() != this) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        SimJQEvent.Departure<J, AbstractSimQueue> event = new SimJQEvent.Departure<J, AbstractSimQueue>(job, this, time, e -> this.departureFromEventList((SimJQEvent.Departure)e));
        SimJQEventScheduler.scheduleJQ(this.getEventList(), event);
        this.eventsScheduled.add((SimEvent)event);
        return event;
    }

    protected final void cancelDepartureEvent(SimJQEvent.Departure<J, Q> event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!this.getEventList().contains(event)) {
            throw new IllegalArgumentException();
        }
        if (!this.eventsScheduled.contains(event)) {
            throw new IllegalArgumentException();
        }
        this.eventsScheduled.remove(event);
        this.getEventList().remove(event);
    }

    protected final void cancelDepartureEvent(J job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        Set<SimJQEvent.Departure> set = this.getDepartureEvents(job);
        if (set == null || set.size() != 1) {
            throw new IllegalArgumentException();
        }
        this.cancelDepartureEvent((J)((Object)set.iterator().next()));
    }

    protected final Set<SimJQEvent.Departure> getDepartureEvents() {
        LinkedHashSet<SimJQEvent.Departure> set = new LinkedHashSet<SimJQEvent.Departure>();
        for (SimEvent e : this.eventsScheduled) {
            if (e == null) {
                throw new IllegalStateException();
            }
            if (!SimJQEvent.Departure.class.isAssignableFrom(e.getClass())) continue;
            set.add((SimJQEvent.Departure)e);
        }
        return set;
    }

    protected final Set<SimJQEvent.Departure> getDepartureEvents(J job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<SimJQEvent.Departure> set = new LinkedHashSet<SimJQEvent.Departure>();
        for (SimEvent e : this.eventsScheduled) {
            if (e == null) {
                throw new IllegalStateException();
            }
            if (!SimJQEvent.Departure.class.isAssignableFrom(e.getClass()) || ((SimJQEvent.Departure)e).getJob() != job) continue;
            set.add((SimJQEvent.Departure)e);
        }
        return set;
    }

    private void fireStartQueueAccessVacation(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimQueueEvent.QueueAccessVacation)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time || !((SimQueueEvent.QueueAccessVacation)event).getVacation()) {
            throw new IllegalArgumentException();
        }
        AbstractSimQueue queue = (AbstractSimQueue)((SimJQEvent)event).getQueue();
        if (queue == null || queue != this) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimQueueListener)) continue;
            ((SimQueueListener)l).notifyStartQueueAccessVacation(time, this);
        }
    }

    private void fireStopQueueAccessVacation(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimQueueEvent.QueueAccessVacation)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time || ((SimQueueEvent.QueueAccessVacation)event).getVacation()) {
            throw new IllegalArgumentException();
        }
        AbstractSimQueue queue = (AbstractSimQueue)((SimJQEvent)event).getQueue();
        if (queue == null || queue != this) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimQueueListener)) continue;
            ((SimQueueListener)l).notifyStopQueueAccessVacation(time, this);
        }
    }

    private void fireOutOfServerAccessCredits(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimQueueEvent.ServerAccessCredits)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time || ((SimQueueEvent.ServerAccessCredits)event).getCredits() > 0) {
            throw new IllegalArgumentException();
        }
        AbstractSimQueue queue = (AbstractSimQueue)((SimJQEvent)event).getQueue();
        if (queue == null || queue != this) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimQueueListener)) continue;
            ((SimQueueListener)l).notifyOutOfServerAccessCredits(time, this);
        }
    }

    private void fireRegainedServerAccessCredits(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimQueueEvent.ServerAccessCredits)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time || ((SimQueueEvent.ServerAccessCredits)event).getCredits() == 0) {
            throw new IllegalArgumentException();
        }
        AbstractSimQueue queue = (AbstractSimQueue)((SimJQEvent)event).getQueue();
        if (queue == null || queue != this) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimQueueListener)) continue;
            ((SimQueueListener)l).notifyRegainedServerAccessCredits(time, this);
        }
    }

    private void fireLostStartArmed(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimQueueEvent.StartArmed)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time || ((SimQueueEvent.StartArmed)event).isStartArmed()) {
            throw new IllegalArgumentException();
        }
        AbstractSimQueue queue = (AbstractSimQueue)((SimJQEvent)event).getQueue();
        if (queue == null || queue != this) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimQueueListener)) continue;
            ((SimQueueListener)l).notifyNewStartArmed(time, this, false);
        }
    }

    private void fireRegainedStartArmed(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimQueueEvent.StartArmed)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time || !((SimQueueEvent.StartArmed)event).isStartArmed()) {
            throw new IllegalArgumentException();
        }
        AbstractSimQueue queue = (AbstractSimQueue)((SimJQEvent)event).getQueue();
        if (queue == null || queue != this) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimQueueListener)) continue;
            ((SimQueueListener)l).notifyNewStartArmed(time, this, true);
        }
    }
}

