/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue;

import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityOperation;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQOperation;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jsimulation.r5.SimEventAction;

public abstract class SimQueueEvent<J extends SimJob, Q extends SimQueue>
extends SimJQEvent<J, Q> {
    protected SimQueueEvent(String name, double time, Q queue, SimEventAction<? extends SimEntity> action) {
        super(name, time, queue, null, action);
        if (queue == null) {
            throw new IllegalArgumentException();
        }
    }

    public static final class ServerAccessCredits<J extends SimJob, Q extends SimQueue>
    extends SimQueueEvent<J, Q> {
        private final int credits;

        private static <J extends SimJob, Q extends SimQueue> SimEventAction<Q> createAction(Q queue, int credits) {
            if (queue == null || credits < 0) {
                throw new IllegalArgumentException();
            }
            return event -> queue.setServerAccessCredits(event.getTime(), credits);
        }

        public ServerAccessCredits(Q queue, double time, int credits) {
            super("SAC[" + credits + "]@" + queue, time, queue, ServerAccessCredits.createAction(queue, credits));
            this.credits = credits;
        }

        @Override
        public ServerAccessCredits<J, Q> copyForQueueAndJob(Q newQueue, J newJob) {
            if (newJob != null) {
                throw new IllegalArgumentException();
            }
            return new ServerAccessCredits<J, Q>(newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.getCredits());
        }

        public final int getCredits() {
            return this.credits;
        }
    }

    public static final class StartArmed<J extends SimJob, Q extends SimQueue>
    extends SimQueueEvent<J, Q> {
        final boolean startArmed;

        public StartArmed(Q queue, double time, boolean startArmed, SimEventAction<Q> action) {
            super("StartArmed[" + startArmed + "]@" + queue, time, queue, action);
            if (action == null) {
                throw new IllegalArgumentException();
            }
            this.startArmed = startArmed;
        }

        public StartArmed(Q queue, double time, boolean startArmed) {
            super("StartArmed[" + startArmed + "]@" + queue, time, queue, null);
            this.startArmed = startArmed;
        }

        @Override
        public StartArmed<J, Q> copyForQueueAndJob(Q newQueue, J newJob) {
            if (newJob != null) {
                throw new IllegalArgumentException();
            }
            if (this.getEventAction() != null && newQueue != null && newQueue != this.getQueue()) {
                throw new UnsupportedOperationException();
            }
            if (this.getEventAction() != null) {
                return new StartArmed<J, Q>(newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.isStartArmed(), this.getEventAction());
            }
            return new StartArmed<J, Q>(newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.isStartArmed());
        }

        public final boolean isStartArmed() {
            return this.startArmed;
        }
    }

    public static final class QueueAccessVacation<J extends SimJob, Q extends SimQueue>
    extends SimQueueEvent<J, Q> {
        final boolean vacation;

        private static <J extends SimJob, Q extends SimQueue> SimEventAction<J> createAction(Q queue, boolean vacation) {
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            return event -> queue.setQueueAccessVacation(event.getTime(), vacation);
        }

        public QueueAccessVacation(Q queue, double time, boolean vacation) {
            super("QAV[" + vacation + "]@" + queue, time, queue, QueueAccessVacation.createAction(queue, vacation));
            this.vacation = vacation;
        }

        @Override
        public QueueAccessVacation<J, Q> copyForQueueAndJob(Q newQueue, J newJob) {
            if (newJob != null) {
                throw new IllegalArgumentException();
            }
            return new QueueAccessVacation<J, Q>(newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.getVacation());
        }

        public final boolean getVacation() {
            return this.vacation;
        }
    }

    public static final class Operation<J extends SimJob, Q extends SimQueue>
    extends SimQueueEvent<J, Q> {
        private final SimEntityOperation.Request request;

        private static <J extends SimJob, Q extends SimQueue> SimEventAction<J> createAction(Q queue, SimEntityOperation.Request request) {
            if (queue == null || request == null) {
                throw new IllegalArgumentException();
            }
            return event -> queue.doOperation(event.getTime(), request);
        }

        public Operation(Q queue, double time, SimEntityOperation.Request request) {
            super("Op[" + request + "]@" + queue, time, queue, Operation.createAction(queue, request));
            this.request = request;
        }

        public Operation copyForQueueAndJob(Q newQueue, J newJob) {
            Object cRequest;
            if (this.request == null) {
                throw new IllegalStateException();
            }
            if (!(this.request instanceof SimJQOperation.RequestJAndOrQ)) {
                throw new UnsupportedOperationException();
            }
            SimJQOperation.RequestJAndOrQ rRequest = (SimJQOperation.RequestJAndOrQ)this.request;
            if (rRequest instanceof SimJQOperation.RequestJ) {
                cRequest = rRequest.forJob((SimJob)(newJob != null ? newJob : rRequest.getJob()));
            } else if (rRequest instanceof SimJQOperation.RequestQ) {
                cRequest = rRequest.forQueue((SimQueue)(newQueue != null ? newQueue : rRequest.getQueue()));
            } else if (rRequest instanceof SimJQOperation.RequestJQ) {
                cRequest = rRequest.forJobAndQueue((SimJob)(newJob != null ? newJob : rRequest.getJob()), (SimQueue)(newQueue != null ? newQueue : rRequest.getQueue()));
            } else {
                throw new UnsupportedOperationException();
            }
            return new Operation<J, Q>(newQueue, this.getTime(), (SimEntityOperation.Request)cRequest);
        }

        public final SimEntityOperation.Request getRequest() {
            return this.request;
        }
    }
}

