/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue;

import org.javades.jqueues.r5.entity.SimEntityOperation;
import org.javades.jqueues.r5.entity.jq.SimJQOperation;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;

public interface SimQueueOperation<J extends SimJob, Q extends SimQueue, O extends SimEntityOperation, Req extends SimEntityOperation.Request, Rep extends SimEntityOperation.Reply>
extends SimJQOperation<J, Q, O, Req, Rep> {

    public static final class ServerAccessCreditsReply
    implements SimEntityOperation.Reply<ServerAccessCredits, ServerAccessCreditsRequest, ServerAccessCreditsReply> {
        private final ServerAccessCreditsRequest request;

        public ServerAccessCreditsReply(ServerAccessCreditsRequest request) {
            if (request == null) {
                throw new IllegalArgumentException();
            }
            this.request = request;
        }

        @Override
        public final ServerAccessCredits getOperation() {
            return ServerAccessCredits.INSTANCE;
        }

        @Override
        public final ServerAccessCreditsRequest getRequest() {
            return this.request;
        }
    }

    public static final class ServerAccessCreditsRequest
    extends SimJQOperation.RequestQ<ServerAccessCredits, ServerAccessCreditsRequest> {
        private final int credits;

        public ServerAccessCreditsRequest(SimQueue queue, int credits) {
            super(queue);
            if (credits < 0) {
                throw new IllegalArgumentException();
            }
            this.credits = credits;
        }

        @Override
        public final ServerAccessCredits getOperation() {
            return ServerAccessCredits.INSTANCE;
        }

        public final int getCredits() {
            return this.credits;
        }

        @Override
        public ServerAccessCreditsRequest forJob(SimJob job) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServerAccessCreditsRequest forQueue(SimQueue queue) {
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            return new ServerAccessCreditsRequest(queue, this.getCredits());
        }

        @Override
        public ServerAccessCreditsRequest forJobAndQueue(SimJob job, SimQueue queue) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ServerAccessCredits
    implements SimEntityOperation<ServerAccessCredits, ServerAccessCreditsRequest, ServerAccessCreditsReply> {
        private static final ServerAccessCredits INSTANCE = new ServerAccessCredits();

        private ServerAccessCredits() {
        }

        public final Object clone() throws CloneNotSupportedException {
            super.clone();
            throw new CloneNotSupportedException();
        }

        public static ServerAccessCredits getInstance() {
            return INSTANCE;
        }

        @Override
        public final String getName() {
            return "ServerAccessCredits";
        }

        @Override
        public final Class<ServerAccessCreditsRequest> getOperationRequestClass() {
            return ServerAccessCreditsRequest.class;
        }

        @Override
        public final Class<ServerAccessCreditsReply> getOperationReplyClass() {
            return ServerAccessCreditsReply.class;
        }

        @Override
        public final ServerAccessCreditsReply doOperation(double time, ServerAccessCreditsRequest request) {
            if (request == null || request.getQueue() == null || request.getOperation() != ServerAccessCredits.getInstance()) {
                throw new IllegalArgumentException();
            }
            request.getQueue().setServerAccessCredits(time, request.getCredits());
            return new ServerAccessCreditsReply(request);
        }
    }

    public static final class QueueAccessVacationReply
    implements SimEntityOperation.Reply<QueueAccessVacation, QueueAccessVacationRequest, QueueAccessVacationReply> {
        private final QueueAccessVacationRequest request;

        public QueueAccessVacationReply(QueueAccessVacationRequest request) {
            if (request == null) {
                throw new IllegalArgumentException();
            }
            this.request = request;
        }

        @Override
        public final QueueAccessVacation getOperation() {
            return QueueAccessVacation.INSTANCE;
        }

        @Override
        public final QueueAccessVacationRequest getRequest() {
            return this.request;
        }
    }

    public static final class QueueAccessVacationRequest
    extends SimJQOperation.RequestQ<QueueAccessVacation, QueueAccessVacationRequest> {
        private final boolean start;

        public QueueAccessVacationRequest(SimQueue queue, boolean start) {
            super(queue);
            this.start = start;
        }

        @Override
        public final QueueAccessVacation getOperation() {
            return QueueAccessVacation.INSTANCE;
        }

        public final boolean isStart() {
            return this.start;
        }

        @Override
        public QueueAccessVacationRequest forJob(SimJob job) {
            throw new UnsupportedOperationException();
        }

        @Override
        public QueueAccessVacationRequest forQueue(SimQueue queue) {
            if (queue == null) {
                throw new IllegalArgumentException();
            }
            return new QueueAccessVacationRequest(queue, this.isStart());
        }

        @Override
        public QueueAccessVacationRequest forJobAndQueue(SimJob job, SimQueue queue) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class QueueAccessVacation
    implements SimEntityOperation<QueueAccessVacation, QueueAccessVacationRequest, QueueAccessVacationReply> {
        private static final QueueAccessVacation INSTANCE = new QueueAccessVacation();

        private QueueAccessVacation() {
        }

        public final Object clone() throws CloneNotSupportedException {
            super.clone();
            throw new CloneNotSupportedException();
        }

        public static QueueAccessVacation getInstance() {
            return INSTANCE;
        }

        @Override
        public final String getName() {
            return "QueueAccessVacation";
        }

        @Override
        public final Class<QueueAccessVacationRequest> getOperationRequestClass() {
            return QueueAccessVacationRequest.class;
        }

        @Override
        public final Class<QueueAccessVacationReply> getOperationReplyClass() {
            return QueueAccessVacationReply.class;
        }

        @Override
        public final QueueAccessVacationReply doOperation(double time, QueueAccessVacationRequest request) {
            if (request == null || request.getQueue() == null || request.getOperation() != QueueAccessVacation.getInstance()) {
                throw new IllegalArgumentException();
            }
            request.getQueue().setQueueAccessVacation(time, request.isStart());
            return new QueueAccessVacationReply(request);
        }
    }
}

