/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntityListener;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.AbstractSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.DefaultDelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueComposite;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueSelector;
import org.javades.jqueues.r5.listener.MultiSimQueueNotificationProcessor;
import org.javades.jsimulation.r5.SimEventList;

public abstract class AbstractSimQueueComposite<DJ extends SimJob, DQ extends SimQueue, J extends SimJob, Q extends AbstractSimQueueComposite>
extends AbstractSimQueue<J, Q>
implements SimQueueComposite<DJ, DQ, J, Q>,
SimEntityListener,
SimQueueSelector<J, DQ> {
    private final Set<DQ> queues;
    private final SimQueueSelector<J, DQ> simQueueSelector;
    private DelegateSimJobFactory<? extends DJ, DQ, J, Q> delegateSimJobFactory;
    private final Map<J, DJ> delegateSimJobMap = new HashMap<J, DJ>();
    private final Map<DJ, J> realSimJobMap = new HashMap<DJ, J>();
    protected final RealDelegateJobMapper realDelegateJobMapper = new RealDelegateJobMapper<J, DJ>(){

        @Override
        public final DJ getDelegateJob(J realJob) {
            return AbstractSimQueueComposite.this.getDelegateJob(realJob);
        }

        @Override
        public final J getRealJob(DJ delegateJob) {
            return AbstractSimQueueComposite.this.getRealJob(delegateJob);
        }
    };

    protected AbstractSimQueueComposite(SimEventList eventList, Set<DQ> queues, SimQueueSelector<J, DQ> simQueueSelector, DelegateSimJobFactory delegateSimJobFactory) {
        super(eventList);
        if (queues == null || queues.contains(null) || queues.contains(this)) {
            throw new IllegalArgumentException();
        }
        this.queues = queues;
        this.simQueueSelector = simQueueSelector;
        this.delegateSimJobFactory = delegateSimJobFactory == null ? new DefaultDelegateSimJobFactory() : delegateSimJobFactory;
        for (SimQueue q : this.queues) {
            q.setIgnoreEventListReset(true);
            q.registerSimEntityListener(this);
        }
        MultiSimQueueNotificationProcessor subQueueEventProcessor = new MultiSimQueueNotificationProcessor(this.getQueues());
        subQueueEventProcessor.setProcessor(this::processSubQueueNotifications);
        this.resetEntitySubClassLocal();
    }

    @Override
    public final Set<DQ> getQueues() {
        return this.queues;
    }

    public static <DQ extends SimQueue> int getIndex(Set<DQ> queues, DQ queue) {
        if (queues == null || queue == null || !queues.contains(queue)) {
            throw new IllegalArgumentException();
        }
        Iterator<DQ> iterator = queues.iterator();
        for (int q = 0; q < queues.size(); ++q) {
            if (iterator.next() != queue) continue;
            return q;
        }
        throw new IllegalArgumentException();
    }

    protected final int getIndex(DQ queue) {
        return AbstractSimQueueComposite.getIndex(this.getQueues(), queue);
    }

    public static <DQ extends SimQueue> DQ getQueue(Set<DQ> queues, int q) {
        if (queues == null || q < 0 || q >= queues.size()) {
            throw new IllegalArgumentException();
        }
        Iterator<DQ> iterator = queues.iterator();
        SimQueue dq = (SimQueue)iterator.next();
        for (int i = 0; i < q; ++i) {
            dq = (SimQueue)iterator.next();
        }
        return (DQ)dq;
    }

    protected final DQ getQueue(int q) {
        return AbstractSimQueueComposite.getQueue(this.getQueues(), q);
    }

    public static Set<SimQueue> getCopySimQueues(Set<SimQueue> queues) throws UnsupportedOperationException {
        if (queues == null || queues.contains(null)) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<SimQueue> set = new LinkedHashSet<SimQueue>();
        for (SimQueue q : queues) {
            set.add(q.getCopySimQueue());
        }
        return set;
    }

    protected final Set<DQ> getCopySubSimQueues() throws UnsupportedOperationException {
        LinkedHashSet set = new LinkedHashSet();
        for (SimQueue dq : this.getQueues()) {
            set.add(dq.getCopySimQueue());
        }
        return set;
    }

    @Override
    public final SimQueueSelector<J, DQ> getSimQueueSelector() {
        return this.simQueueSelector;
    }

    @Override
    public final void resetSimQueueSelector() {
    }

    @Override
    public final DQ selectFirstQueue(double time, J job) {
        if (this.simQueueSelector != null && this.simQueueSelector != this) {
            return this.simQueueSelector.selectFirstQueue(time, job);
        }
        return null;
    }

    @Override
    public final DQ selectNextQueue(double time, J job, DQ previousQueue) {
        if (this.simQueueSelector != null && this.simQueueSelector != this) {
            return this.simQueueSelector.selectNextQueue(time, job, previousQueue);
        }
        return null;
    }

    @Override
    public final DelegateSimJobFactory<? extends DJ, DQ, J, Q> getDelegateSimJobFactory() {
        return this.delegateSimJobFactory;
    }

    @Override
    public final void setDelegateSimJobFactory(DelegateSimJobFactory<? extends DJ, DQ, J, Q> delegateSimJobFactory) {
        if (delegateSimJobFactory == null) {
            throw new IllegalArgumentException();
        }
        this.delegateSimJobFactory = delegateSimJobFactory;
    }

    protected final boolean isRealJob(J realJob) {
        if (realJob == null) {
            return false;
        }
        if (this.isJob((SimJob)realJob)) {
            SimJob delegateJob = (SimJob)this.delegateSimJobMap.get(realJob);
            if (delegateJob == null) {
                throw new IllegalStateException();
            }
            if (this.realSimJobMap.get(delegateJob) != realJob) {
                throw new IllegalStateException();
            }
            return true;
        }
        return false;
    }

    protected final boolean isDelegateJob(DJ delegateJob) {
        if (delegateJob == null) {
            return false;
        }
        if (this.realSimJobMap.containsKey(delegateJob)) {
            SimJob realJob = (SimJob)this.realSimJobMap.get(delegateJob);
            if (realJob == null) {
                throw new IllegalStateException();
            }
            if (this.delegateSimJobMap.get(realJob) != delegateJob) {
                throw new IllegalStateException();
            }
            if (!this.isJob(realJob)) {
                throw new IllegalStateException();
            }
            return true;
        }
        return false;
    }

    protected final DJ getDelegateJob(J realJob) {
        if (realJob == null) {
            throw new IllegalStateException();
        }
        if (!this.isJob((SimJob)realJob)) {
            throw new IllegalStateException();
        }
        SimJob delegateJob = (SimJob)this.delegateSimJobMap.get(realJob);
        if (delegateJob == null) {
            throw new IllegalStateException();
        }
        if (this.realSimJobMap.get(delegateJob) != realJob) {
            throw new IllegalStateException();
        }
        return (DJ)delegateJob;
    }

    protected final DJ getDelegateJobMild(J realJob) {
        if (realJob == null) {
            throw new IllegalStateException();
        }
        SimJob delegateJob = (SimJob)this.delegateSimJobMap.get(realJob);
        if (delegateJob == null) {
            throw new IllegalStateException();
        }
        if (this.realSimJobMap.get(delegateJob) != realJob) {
            throw new IllegalStateException();
        }
        return (DJ)delegateJob;
    }

    protected final J getRealJob(DJ delegateJob, DQ queue) {
        if (delegateJob == null || queue != null && !this.getQueues().contains(queue)) {
            throw new IllegalStateException();
        }
        SimJob realJob = (SimJob)this.realSimJobMap.get(delegateJob);
        if (realJob == null) {
            throw new IllegalStateException();
        }
        if (this.delegateSimJobMap.get(realJob) != delegateJob) {
            throw new IllegalStateException();
        }
        if (!this.isJob(realJob)) {
            throw new IllegalStateException();
        }
        if (queue == null) {
            for (SimQueue subQueue : this.getQueues()) {
                if (!subQueue.getJobs().contains(delegateJob)) continue;
                throw new IllegalStateException();
            }
        } else if (!queue.getJobs().contains(delegateJob)) {
            throw new IllegalStateException();
        }
        return (J)realJob;
    }

    protected final J getRealJob(DJ delegateJob) {
        if (delegateJob == null) {
            throw new IllegalStateException();
        }
        SimJob realJob = (SimJob)this.realSimJobMap.get(delegateJob);
        if (realJob == null) {
            throw new IllegalStateException();
        }
        if (this.delegateSimJobMap.get(realJob) != delegateJob) {
            throw new IllegalStateException();
        }
        if (!this.isJob(realJob)) {
            throw new IllegalStateException();
        }
        return (J)realJob;
    }

    protected final void addRealJobLocal(J realJob) {
        if (realJob == null) {
            throw new IllegalArgumentException();
        }
        if (this.isJob((SimJob)realJob) || this.isJobInServiceArea((SimJob)realJob)) {
            throw new IllegalArgumentException();
        }
        if (this.delegateSimJobMap.containsKey(realJob)) {
            throw new IllegalStateException();
        }
        if (this.realSimJobMap.containsValue(realJob)) {
            throw new IllegalStateException();
        }
        DJ delegateSimJob = this.delegateSimJobFactory.newInstance(this.getLastUpdateTime(), realJob, this);
        if (delegateSimJob == null) {
            throw new IllegalArgumentException();
        }
        this.delegateSimJobMap.put(realJob, delegateSimJob);
        this.realSimJobMap.put(delegateSimJob, realJob);
    }

    protected final void removeJobsFromQueueLocal(J realJob, DJ delegateJob) {
        this.delegateSimJobMap.remove(realJob);
        if (delegateJob != null) {
            this.realSimJobMap.remove(delegateJob);
        }
    }

    @Override
    protected void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.resetEntitySubClassLocal();
    }

    private void resetEntitySubClassLocal() {
        this.simQueueSelector.resetSimQueueSelector();
        this.delegateSimJobMap.clear();
        this.realSimJobMap.clear();
        for (SimQueue q : this.getQueues()) {
            q.resetEntity();
        }
    }

    protected abstract void processSubQueueNotifications(List<MultiSimQueueNotificationProcessor.Notification<DJ, DQ>> var1);

    @Override
    public final void notifyUpdate(double time, SimEntity entity) {
        if (entity == null || !this.getQueues().contains((SimQueue)entity)) {
            throw new IllegalArgumentException();
        }
        this.update(time);
    }

    @Override
    public final void notifyResetEntity(SimEntity entity) {
    }

    @Override
    public final void notifyStateChanged(double time, SimEntity entity, List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> notifications) {
    }

    public static interface RealDelegateJobMapper<J extends SimJob, DJ extends SimJob> {
        public DJ getDelegateJob(J var1);

        public J getRealJob(DJ var1);
    }
}

