/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.collector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQSimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.AbstractSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite_LocalStart;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.collector.CollectorSimQueueSelector;
import org.javades.jqueues.r5.listener.MultiSimQueueNotificationProcessor;
import org.javades.jsimulation.r5.SimEventList;

public abstract class AbstractCollectorSimQueue<DJ extends AbstractSimJob, DQ extends SimQueue, J extends SimJob, Q extends AbstractCollectorSimQueue>
extends AbstractSimQueueComposite_LocalStart<DJ, DQ, J, Q> {
    private final boolean collectDrops;
    private final boolean collectAutoRevocations;
    private final boolean collectDepartures;

    private static Set<SimQueue> createQueuesSet(SimQueue mainQueue, SimQueue collectorQueue) {
        if (mainQueue == null || collectorQueue == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<SimQueue> set = new LinkedHashSet<SimQueue>();
        set.add(mainQueue);
        set.add(collectorQueue);
        return set;
    }

    public AbstractCollectorSimQueue(SimEventList eventList, SimQueue<DJ, DQ> mainQueue, SimQueue<DJ, DQ> collectorQueue, boolean collectDrops, boolean collectAutoRevocations, boolean collectDepartures, DelegateSimJobFactory delegateSimJobFactory) {
        super(eventList, AbstractCollectorSimQueue.createQueuesSet(mainQueue, collectorQueue), new CollectorSimQueueSelector(mainQueue, collectorQueue), delegateSimJobFactory);
        this.collectDrops = collectDrops;
        this.collectAutoRevocations = collectAutoRevocations;
        this.collectDepartures = collectDepartures;
    }

    protected final DQ getMainQueue() {
        Iterator iterator = this.getQueues().iterator();
        return (DQ)((SimQueue)iterator.next());
    }

    protected final DQ getCollectorQueue() {
        Iterator iterator = this.getQueues().iterator();
        SimQueue firstQueue = (SimQueue)iterator.next();
        if (!iterator.hasNext()) {
            return (DQ)firstQueue;
        }
        return (DQ)((SimQueue)iterator.next());
    }

    public final boolean isCollectDrops() {
        return this.collectDrops;
    }

    public final boolean isCollectAutoRevocations() {
        return this.collectAutoRevocations;
    }

    public final boolean isCollectDepartures() {
        return this.collectDepartures;
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
    }

    @Override
    protected final void processSubQueueNotifications(List<MultiSimQueueNotificationProcessor.Notification<DJ, DQ>> notifications) {
        if (notifications == null || notifications.isEmpty()) {
            super.processSubQueueNotifications(notifications);
            return;
        }
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        ArrayList<AbstractSimJob> exitJobs = new ArrayList<AbstractSimJob>();
        Iterator<MultiSimQueueNotificationProcessor.Notification<DJ, DQ>> i_not = notifications.iterator();
        while (i_not.hasNext()) {
            MultiSimQueueNotificationProcessor.Notification<DJ, DQ> notification = i_not.next();
            if (notification.getTime() != this.getLastUpdateTime()) {
                throw new IllegalStateException();
            }
            if (notification.getQueue() != this.getMainQueue()) continue;
            Iterator<Map<SimEntitySimpleEventType.Member, SimJQEvent<DJ, DQ>>> i_sub = notification.getSubNotifications().iterator();
            while (i_sub.hasNext()) {
                AbstractSimJob job;
                Map<SimEntitySimpleEventType.Member, SimJQEvent<DJ, DQ>> subNotification = i_sub.next();
                if (subNotification.size() != 1) {
                    throw new IllegalArgumentException();
                }
                if (this.isCollectDrops() && subNotification.containsKey(SimJQSimpleEventType.DROP)) {
                    if (subNotification.get(SimJQSimpleEventType.DROP).getTime() != this.getLastUpdateTime()) {
                        throw new IllegalArgumentException();
                    }
                    job = (AbstractSimJob)subNotification.get(SimJQSimpleEventType.DROP).getJob();
                    exitJobs.add(job);
                    i_sub.remove();
                    continue;
                }
                if (this.isCollectAutoRevocations() && subNotification.containsKey(SimJQSimpleEventType.AUTO_REVOCATION)) {
                    if (subNotification.get(SimJQSimpleEventType.AUTO_REVOCATION).getTime() != this.getLastUpdateTime()) {
                        throw new IllegalArgumentException();
                    }
                    job = (AbstractSimJob)subNotification.get(SimJQSimpleEventType.AUTO_REVOCATION).getJob();
                    exitJobs.add(job);
                    i_sub.remove();
                    continue;
                }
                if (!this.isCollectDepartures() || !subNotification.containsKey(SimJQSimpleEventType.DEPARTURE)) continue;
                if (subNotification.get(SimJQSimpleEventType.DEPARTURE).getTime() != this.getLastUpdateTime()) {
                    throw new IllegalArgumentException();
                }
                job = (AbstractSimJob)subNotification.get(SimJQSimpleEventType.DEPARTURE).getJob();
                exitJobs.add(job);
                i_sub.remove();
            }
            if (!notification.getSubNotifications().isEmpty()) continue;
            i_not.remove();
        }
        for (AbstractSimJob job : exitJobs) {
            this.getCollectorQueue().arrive(this.getLastUpdateTime(), (AbstractSimJob)job);
        }
        if (!notifications.isEmpty()) {
            super.processSubQueueNotifications(notifications);
        }
        if (isTopLevel) {
            this.fireAndLockPendingNotifications();
        }
    }
}

