/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.ctandem2;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueSelector;
import org.javades.jqueues.r5.listener.MultiSimQueueNotificationProcessor;
import org.javades.jsimulation.r5.SimEventList;

public class CTandem2<DJ extends SimJob, DQ extends SimQueue, J extends SimJob, Q extends CTandem2>
extends AbstractSimQueueComposite<DJ, DQ, J, Q> {
    private SimJQEvent.Revocation<DJ, DQ> pendingDelegateRevocationEvent = null;

    private static Set<SimQueue> createQueuesSet(SimQueue waitQueue, SimQueue serveQueue) {
        if (waitQueue == null || serveQueue == null || waitQueue == serveQueue) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<SimQueue> set = new LinkedHashSet<SimQueue>();
        set.add(waitQueue);
        set.add(serveQueue);
        return set;
    }

    public CTandem2(SimEventList eventList, final SimQueue<? extends DJ, ? extends DQ> waitQueue, final SimQueue<? extends DJ, ? extends DQ> serveQueue, DelegateSimJobFactory delegateSimJobFactory) {
        super(eventList, CTandem2.createQueuesSet(waitQueue, serveQueue), new SimQueueSelector<J, DQ>(){

            @Override
            public void resetSimQueueSelector() {
            }

            @Override
            public DQ selectFirstQueue(double time, J job) {
                return waitQueue;
            }

            @Override
            public DQ selectNextQueue(double time, J job, DQ previousQueue) {
                if (previousQueue == null) {
                    throw new IllegalArgumentException();
                }
                if (previousQueue == waitQueue) {
                    if (job.getQueue() == null) {
                        throw new IllegalStateException();
                    }
                    if (!job.getQueue().getJobs().contains(job)) {
                        throw new IllegalStateException();
                    }
                    if (job.getQueue().getJobsInWaitingArea().contains(job)) {
                        return null;
                    }
                    throw new IllegalStateException();
                }
                if (previousQueue == serveQueue) {
                    return null;
                }
                throw new IllegalArgumentException();
            }
        }, delegateSimJobFactory);
        this.getWaitQueue().setAutoRevocationPolicy(SimQueue.AutoRevocationPolicy.UPON_START);
    }

    public CTandem2<DJ, DQ, J, Q> getCopySimQueue() {
        SimQueue waitQueueCopy = this.getWaitQueue().getCopySimQueue();
        SimQueue serveQueueCopy = this.getServeQueue().getCopySimQueue();
        return new CTandem2(this.getEventList(), waitQueueCopy, serveQueueCopy, this.getDelegateSimJobFactory());
    }

    public final DQ getWaitQueue() {
        return this.getQueue(0);
    }

    public final DQ getServeQueue() {
        return this.getQueue(1);
    }

    @Override
    public String toStringDefault() {
        return "CTandem2[" + this.getWaitQueue() + "," + this.getServeQueue() + "]";
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    @Override
    protected void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.resetEntitySubClassLocal();
    }

    private void resetEntitySubClassLocal() {
        this.getWaitQueue().setServerAccessCredits(this.getLastUpdateTime(), this.getServeQueue().isStartArmed() ? 1 : 0);
    }

    @Override
    protected final void queueAccessVacationDropSubClass(double time, J job) {
        super.queueAccessVacationDropSubClass(time, job);
    }

    @Override
    public final boolean isStartArmed() {
        return this.getServeQueue().isStartArmed();
    }

    protected final void setServerAccessCreditsOnWaitQueue() {
        int newWaitQueueSac;
        Object waitQueue = this.getQueue(0);
        Object serveQueue = this.getQueue(1);
        int oldWaitQueueSac = waitQueue.getServerAccessCredits();
        if (oldWaitQueueSac < 0 || oldWaitQueueSac > 1) {
            throw new IllegalStateException("oldWaitQueueSac: " + oldWaitQueueSac);
        }
        int n = newWaitQueueSac = this.hasServerAcccessCredits() && serveQueue.isStartArmed() ? 1 : 0;
        if (newWaitQueueSac != oldWaitQueueSac) {
            waitQueue.setServerAccessCredits(this.getLastUpdateTime(), newWaitQueueSac);
        }
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
        this.addRealJobLocal(job);
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job) || this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        Object delegateJob = this.getDelegateJob(job);
        this.getWaitQueue().arrive(time, delegateJob);
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        Object delegateJob = this.getDelegateJob(job);
        Object subQueue = delegateJob.getQueue();
        if (subQueue != null) {
            this.removeJobFromQueueUponRevokation(job, time, true);
        } else {
            this.removeJobsFromQueueLocal(job, delegateJob);
        }
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        if (this.pendingDelegateRevocationEvent != null) {
            this.rescheduleAfterRevokation(job, time, true);
        }
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        Object delegateJob = this.getDelegateJob(job);
        Object subQueue = delegateJob.getQueue();
        if (subQueue == null) {
            throw new IllegalStateException();
        }
        if (this.pendingDelegateRevocationEvent != null) {
            throw new IllegalStateException();
        }
        this.pendingDelegateRevocationEvent = new SimJQEvent.Revocation(delegateJob, subQueue, time, true);
        this.removeJobsFromQueueLocal(job, delegateJob);
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        if (this.pendingDelegateRevocationEvent == null) {
            throw new IllegalStateException();
        }
        this.pendingDelegateRevocationEvent.getEventAction().action(this.pendingDelegateRevocationEvent);
        if (this.pendingDelegateRevocationEvent != null) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        if (this.getServerAccessCredits() == 0) {
            this.setServerAccessCreditsOnWaitQueue();
        }
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        this.setServerAccessCreditsOnWaitQueue();
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job) || this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        this.getDelegateJob(job);
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job) || !this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        Object delegateJob = this.getDelegateJob(job);
        this.getServeQueue().arrive(time, delegateJob);
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
        Object delegateJob = this.getDelegateJob(departingJob);
        Object subQueue = delegateJob.getQueue();
        if (subQueue != null) {
            this.removeJobFromQueueUponRevokation(departingJob, time, true);
        } else {
            this.removeJobsFromQueueLocal(departingJob, delegateJob);
        }
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
        if (this.pendingDelegateRevocationEvent != null) {
            this.rescheduleAfterRevokation(departedJob, time, true);
        }
    }

    @Override
    protected final void processSubQueueNotifications(List<MultiSimQueueNotificationProcessor.Notification<DJ, DQ>> notifications) {
        if (notifications == null || notifications.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (MultiSimQueueNotificationProcessor.contains(notifications, SimEntitySimpleEventType.RESET)) {
            if (notifications.size() != 1 || notifications.get(0).getSubNotifications().size() != 1 || !((SimEntityEvent)notifications.get(0).getSubNotifications().get(0).get(SimEntitySimpleEventType.RESET) instanceof SimEntityEvent.Reset)) {
                throw new IllegalStateException();
            }
            notifications.clear();
            return;
        }
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        while (!notifications.isEmpty()) {
            MultiSimQueueNotificationProcessor.Notification notification = notifications.remove(0);
            double notificationTime = notification.getTime();
            if (notification.getTime() != this.getLastUpdateTime()) {
                throw new IllegalArgumentException("on " + this + ": notification time [" + notification.getTime() + "] != last update time [" + this.getLastUpdateTime() + "], subnotifications: " + notification.getSubNotifications() + ".");
            }
            Object subQueue = notification.getQueue();
            if (subQueue == null || !this.getQueues().contains(subQueue)) {
                throw new IllegalStateException();
            }
            int nrStarted = 0;
            Object lastJobStarted = null;
            int nrAutoRevocations = 0;
            Object lastJobAutoRevoked = null;
            for (Map subNotification : notification.getSubNotifications()) {
                Object realJob;
                if (subNotification == null || subNotification.size() != 1) {
                    throw new RuntimeException();
                }
                SimEntitySimpleEventType.Member notificationType = subNotification.keySet().iterator().next();
                SimJQEvent notificationEvent = subNotification.values().iterator().next();
                if (notificationEvent == null) {
                    throw new RuntimeException();
                }
                Object job = subNotification.values().iterator().next().getJob();
                if (job != null && notificationType != SimQueueSimpleEventType.REVOCATION) {
                    this.getRealJob(job);
                }
                if (notificationType == SimEntitySimpleEventType.RESET) {
                    throw new IllegalStateException();
                }
                if (notificationType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION || notificationType == SimQueueSimpleEventType.QAV_START || notificationType == SimQueueSimpleEventType.QAV_END) {
                    throw new IllegalStateException();
                }
                if (notificationType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS || notificationType == SimQueueSimpleEventType.OUT_OF_SAC || notificationType == SimQueueSimpleEventType.REGAINED_SAC || notificationType == SimQueueSimpleEventType.STA_FALSE || notificationType == SimQueueSimpleEventType.STA_TRUE || notificationType == SimQueueSimpleEventType.ARRIVAL) continue;
                if (notificationType == SimQueueSimpleEventType.DROP) {
                    realJob = this.getRealJob(job);
                    this.drop(realJob, notificationTime);
                    continue;
                }
                if (notificationType == SimQueueSimpleEventType.REVOCATION) {
                    if (this.isDelegateJob(job)) {
                        throw new IllegalStateException();
                    }
                    if (this.pendingDelegateRevocationEvent == null || this.pendingDelegateRevocationEvent.getQueue() != subQueue || this.pendingDelegateRevocationEvent.getJob() != job) {
                        throw new IllegalStateException();
                    }
                    this.pendingDelegateRevocationEvent = null;
                    continue;
                }
                if (notificationType == SimQueueSimpleEventType.AUTO_REVOCATION) {
                    if (subQueue == this.getWaitQueue()) {
                        ++nrAutoRevocations;
                        lastJobAutoRevoked = job;
                        this.start(notificationTime, this.getRealJob(job, null));
                        continue;
                    }
                    throw new IllegalStateException();
                }
                if (notificationType == SimQueueSimpleEventType.START) {
                    ++nrStarted;
                    lastJobStarted = job;
                    continue;
                }
                if (notificationType != SimQueueSimpleEventType.DEPARTURE) continue;
                realJob = this.getRealJob(job);
                Object nextQueue = this.selectNextQueue(notificationTime, realJob, subQueue);
                if (nextQueue != null) {
                    nextQueue.arrive(notificationTime, job);
                    continue;
                }
                this.depart(notificationTime, realJob);
            }
            if (notification.getQueue() == this.getWaitQueue() && (nrStarted > 1 || nrAutoRevocations > 1 || nrStarted != nrAutoRevocations || lastJobStarted != lastJobAutoRevoked)) {
                throw new IllegalStateException();
            }
            if (this.getIndex(subQueue) != 1) continue;
            this.setServerAccessCreditsOnWaitQueue();
        }
        this.triggerPotentialNewStartArmed(this.getLastUpdateTime());
        if (!notifications.isEmpty()) {
            throw new IllegalStateException();
        }
        if (isTopLevel) {
            this.fireAndLockPendingNotifications();
        }
    }
}

