/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.enc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntityOperation;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueSelector;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.DelegatedSimQueueOperation;
import org.javades.jqueues.r5.listener.MultiSimQueueNotificationProcessor;
import org.javades.jsimulation.r5.SimEventList;

public abstract class AbstractEncapsulatorSimQueue<DJ extends SimJob, DQ extends SimQueue, J extends SimJob, Q extends AbstractEncapsulatorSimQueue>
extends AbstractSimQueueComposite<DJ, DQ, J, Q> {
    private SimJQEvent.Revocation<DJ, DQ> pendingDelegateRevocationEvent = null;

    public AbstractEncapsulatorSimQueue(SimEventList eventList, DQ queue, DelegateSimJobFactory delegateSimJobFactory) {
        super(eventList, Collections.singleton(queue), new SimQueueSelector<J, DQ>((SimQueue)queue){
            final /* synthetic */ SimQueue val$queue;
            {
                this.val$queue = simQueue;
            }

            @Override
            public void resetSimQueueSelector() {
            }

            @Override
            public DQ selectFirstQueue(double time, J job) {
                return this.val$queue;
            }

            @Override
            public DQ selectNextQueue(double time, J job, DQ previousQueue) {
                if (previousQueue != this.val$queue) {
                    throw new IllegalArgumentException();
                }
                return null;
            }
        }, delegateSimJobFactory);
        for (SimEntityOperation oDQueue : queue.getRegisteredOperations()) {
            if (this.getRegisteredOperations().contains(oDQueue)) continue;
            this.registerDelegatedOperation(oDQueue, new DelegatedSimQueueOperation(this, (SimQueue)queue, oDQueue, this.realDelegateJobMapper));
        }
        for (SimEntitySimpleEventType.Member nDQueue : queue.getRegisteredNotificationTypes()) {
            if (this.getRegisteredNotificationTypes().contains(nDQueue)) continue;
            this.registerNotificationType(nDQueue, null);
        }
    }

    public final SimQueue<DJ, DQ> getEncapsulatedQueue() {
        return this.getQueue(0);
    }

    @Override
    public Object getQoS() {
        return this.getEncapsulatedQueue().getQoS();
    }

    @Override
    public Class getQoSClass() {
        return this.getEncapsulatedQueue().getQoSClass();
    }

    @Override
    protected void resetEntitySubClass() {
        super.resetEntitySubClass();
    }

    @Override
    protected void insertJobInQueueUponArrival(J job, double time) {
        this.addRealJobLocal(job);
    }

    @Override
    protected void rescheduleAfterArrival(J job, double time) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job) || this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        Object delegateJob = this.getDelegateJob(job);
        this.getEncapsulatedQueue().arrive(time, delegateJob);
    }

    @Override
    protected void removeJobFromQueueUponDrop(J job, double time) {
        Object delegateJob = this.getDelegateJob(job);
        Object subQueue = delegateJob.getQueue();
        if (subQueue != null) {
            this.removeJobFromQueueUponRevokation(job, time, true);
        } else {
            this.removeJobsFromQueueLocal(job, delegateJob);
        }
    }

    @Override
    protected void rescheduleAfterDrop(J job, double time) {
        if (this.pendingDelegateRevocationEvent != null) {
            this.rescheduleAfterRevokation(job, time, true);
        }
    }

    @Override
    protected void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        Object delegateJob = this.getDelegateJob(job);
        Object subQueue = delegateJob.getQueue();
        if (auto && subQueue == null) {
            if (this.pendingDelegateRevocationEvent != null) {
                throw new IllegalStateException();
            }
            if (time != this.getLastUpdateTime() || this.clearAndUnlockPendingNotificationsIfLocked()) {
                throw new IllegalStateException();
            }
            this.removeJobsFromQueueLocal(job, delegateJob);
            return;
        }
        if (subQueue == null) {
            throw new IllegalStateException();
        }
        if (this.pendingDelegateRevocationEvent != null) {
            throw new IllegalStateException();
        }
        this.pendingDelegateRevocationEvent = new SimJQEvent.Revocation(delegateJob, subQueue, time, true);
        this.removeJobsFromQueueLocal(job, delegateJob);
    }

    @Override
    protected void rescheduleAfterRevokation(J job, double time, boolean auto) {
        if (auto && this.pendingDelegateRevocationEvent == null) {
            return;
        }
        if (this.pendingDelegateRevocationEvent == null) {
            throw new IllegalStateException();
        }
        this.pendingDelegateRevocationEvent.getEventAction().action(this.pendingDelegateRevocationEvent);
        if (this.pendingDelegateRevocationEvent != null) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean isStartArmed() {
        return this.getEncapsulatedQueue().isStartArmed();
    }

    @Override
    protected void setServerAccessCreditsSubClass() {
        this.getEncapsulatedQueue().setServerAccessCredits(this.getLastUpdateTime(), this.getServerAccessCredits());
    }

    @Override
    protected void rescheduleForNewServerAccessCredits(double time) {
    }

    @Override
    protected void insertJobInQueueUponStart(J job, double time) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job) || this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        this.getDelegateJob(job);
    }

    @Override
    protected void rescheduleAfterStart(J job, double time) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job) || !this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        Object delegateJob = this.getDelegateJob(job);
    }

    @Override
    protected double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected void removeJobFromQueueUponDeparture(J departingJob, double time) {
        Object delegateJob = this.getDelegateJob(departingJob);
        Object subQueue = delegateJob.getQueue();
        if (subQueue != null) {
            this.removeJobFromQueueUponRevokation(departingJob, time, true);
        } else {
            this.removeJobsFromQueueLocal(departingJob, delegateJob);
        }
    }

    @Override
    protected void rescheduleAfterDeparture(J departedJob, double time) {
        if (this.pendingDelegateRevocationEvent != null) {
            this.rescheduleAfterRevokation(departedJob, time, true);
        }
    }

    @Override
    protected void processSubQueueNotifications(List<MultiSimQueueNotificationProcessor.Notification<DJ, DQ>> notifications) {
        if (notifications == null || notifications.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (MultiSimQueueNotificationProcessor.contains(notifications, SimEntitySimpleEventType.RESET)) {
            if (notifications.size() != 1 || notifications.get(0).getSubNotifications().size() != 1 || !((SimEntityEvent)notifications.get(0).getSubNotifications().get(0).get(SimEntitySimpleEventType.RESET) instanceof SimEntityEvent.Reset)) {
                throw new IllegalStateException();
            }
            notifications.clear();
            return;
        }
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        while (!notifications.isEmpty()) {
            MultiSimQueueNotificationProcessor.Notification notification = notifications.remove(0);
            double notificationTime = notification.getTime();
            if (notification.getTime() != this.getLastUpdateTime()) {
                throw new IllegalArgumentException("on " + this + ": notification time [" + notification.getTime() + "] != last update time [" + this.getLastUpdateTime() + "], subnotifications: " + notification.getSubNotifications() + ".");
            }
            Object subQueue = notification.getQueue();
            if (subQueue == null || !this.getQueues().contains(subQueue)) {
                throw new IllegalStateException();
            }
            for (Map subNotification : notification.getSubNotifications()) {
                Object realJob;
                if (subNotification == null || subNotification.size() != 1) {
                    throw new RuntimeException();
                }
                SimEntitySimpleEventType.Member notificationType = subNotification.keySet().iterator().next();
                SimJQEvent notificationEvent = subNotification.values().iterator().next();
                if (notificationEvent == null) {
                    throw new RuntimeException();
                }
                Object job = subNotification.values().iterator().next().getJob();
                if (job != null && notificationType != SimQueueSimpleEventType.REVOCATION) {
                    this.getRealJob(job);
                }
                if (notificationType == SimEntitySimpleEventType.RESET) {
                    throw new IllegalStateException();
                }
                if (notificationType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION || notificationType == SimQueueSimpleEventType.QAV_START || notificationType == SimQueueSimpleEventType.QAV_END || notificationType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS || notificationType == SimQueueSimpleEventType.OUT_OF_SAC || notificationType == SimQueueSimpleEventType.REGAINED_SAC || notificationType == SimQueueSimpleEventType.STA_FALSE || notificationType == SimQueueSimpleEventType.STA_TRUE || notificationType == SimQueueSimpleEventType.ARRIVAL) continue;
                if (notificationType == SimQueueSimpleEventType.DROP) {
                    realJob = this.getRealJob(job);
                    this.drop(realJob, notificationTime);
                    continue;
                }
                if (notificationType == SimQueueSimpleEventType.REVOCATION) {
                    if (this.isDelegateJob(job)) {
                        throw new IllegalStateException();
                    }
                    if (this.pendingDelegateRevocationEvent == null || this.pendingDelegateRevocationEvent.getQueue() != subQueue || this.pendingDelegateRevocationEvent.getJob() != job) {
                        throw new IllegalStateException();
                    }
                    this.pendingDelegateRevocationEvent = null;
                    continue;
                }
                if (notificationType == SimQueueSimpleEventType.AUTO_REVOCATION) {
                    this.autoRevoke(notificationTime, this.getRealJob(job));
                    continue;
                }
                if (notificationType == SimQueueSimpleEventType.START) {
                    this.start(notificationTime, this.getRealJob(job));
                    continue;
                }
                if (notificationType == SimQueueSimpleEventType.DEPARTURE) {
                    this.depart(notificationTime, this.getRealJob(job));
                    continue;
                }
                realJob = job != null ? this.getRealJob(job) : null;
                this.addPendingNotification(notificationType, notificationEvent.copyForQueueAndJob(this, realJob));
            }
        }
        this.triggerPotentialNewStartArmed(this.getLastUpdateTime());
        if (!notifications.isEmpty()) {
            throw new IllegalStateException();
        }
        if (isTopLevel) {
            this.fireAndLockPendingNotifications();
        }
    }
}

