/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.enc;

import org.javades.jqueues.r5.entity.SimEntityOperation;
import org.javades.jqueues.r5.entity.jq.SimJQOperation;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite;

public class DelegatedSimQueueOperation
implements SimEntityOperation<SimEntityOperation, SimEntityOperation.Request, SimEntityOperation.Reply> {
    private final AbstractSimQueueComposite.RealDelegateJobMapper jobMapper;
    private final SimQueue queue;
    private final SimQueue subQueue;
    private final SimEntityOperation oDQueue;

    public DelegatedSimQueueOperation(SimQueue queue, SimQueue subQueue, SimEntityOperation oDQueue, AbstractSimQueueComposite.RealDelegateJobMapper jobMapper) {
        if (queue == null || subQueue == null || oDQueue == null) {
            throw new IllegalArgumentException();
        }
        this.queue = queue;
        this.subQueue = subQueue;
        this.oDQueue = oDQueue;
        this.jobMapper = jobMapper;
    }

    @Override
    public final String getName() {
        return "DelegatedOperation[" + this.oDQueue.getName() + "]";
    }

    @Override
    public final Class getOperationRequestClass() {
        return this.oDQueue.getOperationRequestClass();
    }

    @Override
    public final Class getOperationReplyClass() {
        return this.oDQueue.getOperationReplyClass();
    }

    @Override
    public SimEntityOperation.Reply doOperation(double time, SimEntityOperation.Request request) {
        Object dReply;
        Object dRequest;
        if (request == null) {
            throw new IllegalArgumentException();
        }
        if (this.oDQueue == null) {
            throw new IllegalStateException();
        }
        if (!SimJQOperation.RequestJAndOrQ.class.isAssignableFrom(this.oDQueue.getOperationRequestClass())) {
            throw new UnsupportedOperationException();
        }
        if (!(request instanceof SimJQOperation.RequestJAndOrQ)) {
            throw new UnsupportedOperationException();
        }
        SimJQOperation.RequestJAndOrQ rRequest = (SimJQOperation.RequestJAndOrQ)request;
        if (rRequest.getJob() != null && this.jobMapper == null) {
            throw new IllegalArgumentException();
        }
        SimJob dJob = rRequest.getJob() != null ? (SimJob)this.jobMapper.getDelegateJob(rRequest.getJob()) : null;
        if (rRequest instanceof SimJQOperation.RequestJ) {
            dRequest = rRequest.forJob(dJob);
        } else if (rRequest instanceof SimJQOperation.RequestQ) {
            dRequest = rRequest.forQueue(this.subQueue);
        } else if (rRequest instanceof SimJQOperation.RequestJQ) {
            dRequest = rRequest.forJobAndQueue(dJob, this.subQueue);
        } else {
            throw new UnsupportedOperationException();
        }
        Object rReply = dReply = this.subQueue.doOperation(time, dRequest);
        return rReply;
    }
}

