/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.enc;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQSimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.AbstractEncapsulatorSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.Enc;
import org.javades.jqueues.r5.listener.MultiSimQueueNotificationProcessor;
import org.javades.jsimulation.r5.SimEventList;

public class EncJL<DJ extends SimJob, DQ extends SimQueue, J extends SimJob, Q extends Enc>
extends AbstractEncapsulatorSimQueue<DJ, DQ, J, Q> {
    private final int maxJw;
    private final int maxJs;
    private final int maxJ;

    public EncJL(SimEventList eventList, DQ queue, DelegateSimJobFactory delegateSimJobFactory, int maxJw, int maxJs, int maxJ) {
        super(eventList, queue, delegateSimJobFactory);
        if (maxJw < 0 || maxJs < 0 || maxJ < 0) {
            throw new IllegalArgumentException();
        }
        this.maxJw = maxJw;
        this.maxJs = maxJs;
        this.maxJ = maxJ;
        this.setServerAccessCreditsOnEncapsulatedQueue(this.getLastUpdateTime());
    }

    public EncJL<DJ, DQ, J, Q> getCopySimQueue() {
        SimQueue encapsulatedQueueCopy = this.getEncapsulatedQueue().getCopySimQueue();
        EncJL copy = new EncJL(this.getEventList(), encapsulatedQueueCopy, this.getDelegateSimJobFactory(), this.getMaxJobsInWaitingArea(), this.getMaxJobsInServiceArea(), this.getMaxJobs());
        return copy;
    }

    @Override
    public String toStringDefault() {
        return "EncJL(" + (this.getMaxJobsInWaitingArea() == Integer.MAX_VALUE ? "inf" : Integer.valueOf(this.getMaxJobsInWaitingArea())) + "," + (this.getMaxJobsInServiceArea() == Integer.MAX_VALUE ? "inf" : Integer.valueOf(this.getMaxJobsInServiceArea())) + "," + (this.getMaxJobs() == Integer.MAX_VALUE ? "inf" : Integer.valueOf(this.getMaxJobs())) + ")[" + this.getEncapsulatedQueue() + "]";
    }

    public final int getMaxJobsInWaitingArea() {
        return this.maxJw;
    }

    public final int getMaxJobsInServiceArea() {
        return this.maxJs;
    }

    public final int getMaxJobs() {
        return this.maxJ;
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.setServerAccessCreditsOnEncapsulatedQueue(this.getLastUpdateTime());
    }

    @Override
    protected final void queueAccessVacationDropSubClass(double time, J job) {
        super.queueAccessVacationDropSubClass(time, job);
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
        super.insertJobInQueueUponArrival(job, time);
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        this.setServerAccessCreditsOnEncapsulatedQueue(time);
        if (this.getMaxJobs() > 0 && (this.getMaxJobsInWaitingArea() == Integer.MAX_VALUE || this.getEncapsulatedQueue().getNumberOfJobsInWaitingArea() < this.getMaxJobsInWaitingArea() || this.getEncapsulatedQueue().getNumberOfJobsInWaitingArea() == this.getMaxJobsInWaitingArea() && this.getEncapsulatedQueue().getNumberOfJobsInWaitingArea() == 0 && this.getEncapsulatedQueue().getServerAccessCredits() > 0 && this.getEncapsulatedQueue().isStartArmed())) {
            super.rescheduleAfterArrival(job, time);
        } else {
            this.drop(job, time);
        }
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        super.removeJobFromQueueUponDrop(job, time);
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        super.rescheduleAfterDrop(job, time);
        this.setServerAccessCreditsOnEncapsulatedQueue(time);
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        super.removeJobFromQueueUponRevokation(job, time, auto);
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        super.rescheduleAfterRevokation(job, time, auto);
        this.setServerAccessCreditsOnEncapsulatedQueue(time);
    }

    @Override
    public final boolean isStartArmed() {
        return !(this.getMaxJobs() <= 0 || this.getMaxJobs() != Integer.MAX_VALUE && this.getEncapsulatedQueue().getNumberOfJobs() >= this.getMaxJobs() || this.getMaxJobsInServiceArea() != Integer.MAX_VALUE && this.getEncapsulatedQueue().getNumberOfJobsInServiceArea() >= this.getMaxJobsInServiceArea() || !this.getEncapsulatedQueue().isStartArmed());
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        this.setServerAccessCreditsOnEncapsulatedQueue(this.getLastUpdateTime());
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        super.insertJobInQueueUponStart(job, time);
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        super.rescheduleAfterStart(job, time);
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
        super.removeJobFromQueueUponDeparture(departingJob, time);
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
        super.rescheduleAfterDeparture(departedJob, time);
        this.setServerAccessCreditsOnEncapsulatedQueue(time);
    }

    private void setServerAccessCreditsOnEncapsulatedQueue(double time) {
        int sacRequired = Integer.MAX_VALUE;
        if (this.getMaxJobsInServiceArea() < Integer.MAX_VALUE) {
            sacRequired = this.getMaxJobsInServiceArea() - this.getEncapsulatedQueue().getNumberOfJobsInServiceArea();
        }
        if (this.getServerAccessCredits() < Integer.MAX_VALUE && this.getServerAccessCredits() < sacRequired) {
            sacRequired = this.getServerAccessCredits();
        }
        if (this.getEncapsulatedQueue().getServerAccessCredits() != sacRequired) {
            this.getEncapsulatedQueue().setServerAccessCredits(time, sacRequired);
        }
    }

    @Override
    protected final void processSubQueueNotifications(List<MultiSimQueueNotificationProcessor.Notification<DJ, DQ>> notifications) {
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        if (notifications != null) {
            for (MultiSimQueueNotificationProcessor.Notification<DJ, DQ> notification : notifications) {
                Iterator<Map<SimEntitySimpleEventType.Member, SimJQEvent<DJ, DQ>>> i_sub = notification.getSubNotifications().iterator();
                while (i_sub.hasNext()) {
                    Map<SimEntitySimpleEventType.Member, SimJQEvent<DJ, DQ>> subNotification = i_sub.next();
                    if (!subNotification.containsKey(SimJQSimpleEventType.START)) continue;
                    DJ job = subNotification.get(SimJQSimpleEventType.START).getJob();
                    this.start(notification.getTime(), this.getRealJob(job));
                    i_sub.remove();
                }
            }
        }
        super.processSubQueueNotifications(notifications);
        if (isTopLevel) {
            this.fireAndLockPendingNotifications();
        }
    }
}

