/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.enc;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.AbstractEncapsulatorSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.Enc;
import org.javades.jqueues.r5.listener.MultiSimQueueNotificationProcessor;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventList;

public class EncTL<DJ extends SimJob, DQ extends SimQueue, J extends SimJob, Q extends Enc>
extends AbstractEncapsulatorSimQueue<DJ, DQ, J, Q> {
    private ExpirationMethod exprirationMethod;
    private final double maxWaitingTime;
    private final double maxServiceTime;
    private final double maxSojournTime;
    private final Map<DJ, Double> arrivalTimes = new HashMap<DJ, Double>();
    private final SortedMap<Double, Set<DJ>> autoRevocationSchedule = new TreeMap<Double, Set<DJ>>();
    private SimEvent scheduledRevocationEvent = null;
    private boolean processingOwnAutoRevocationEvent = false;

    public EncTL(SimEventList eventList, DQ queue, DelegateSimJobFactory delegateSimJobFactory, double maxWaitingTime, double maxServiceTime, double maxSojournTime) {
        super(eventList, queue, delegateSimJobFactory);
        if (maxWaitingTime < 0.0 || maxServiceTime < 0.0 || maxSojournTime < 0.0) {
            throw new IllegalArgumentException();
        }
        this.maxWaitingTime = maxWaitingTime;
        this.maxServiceTime = maxServiceTime;
        this.maxSojournTime = maxSojournTime;
        this.exprirationMethod = ExpirationMethod.DEPARTURE;
    }

    public EncTL<DJ, DQ, J, Q> getCopySimQueue() {
        SimQueue encapsulatedQueueCopy = this.getEncapsulatedQueue().getCopySimQueue();
        EncTL copy = new EncTL(this.getEventList(), encapsulatedQueueCopy, this.getDelegateSimJobFactory(), this.getMaxWaitingTime(), this.getMaxServiceTime(), this.getMaxSojournTime());
        copy.setExprirationMethod(this.getExprirationMethod());
        return copy;
    }

    @Override
    public String toStringDefault() {
        return "EncTL(" + this.getMaxWaitingTime() + "," + this.getMaxServiceTime() + "," + this.getMaxSojournTime() + ")[" + this.getEncapsulatedQueue() + "]";
    }

    public final ExpirationMethod getExprirationMethod() {
        return this.exprirationMethod;
    }

    public final void setExprirationMethod(ExpirationMethod exprirationMethod) {
        if (exprirationMethod == null) {
            throw new IllegalArgumentException();
        }
        this.exprirationMethod = exprirationMethod;
    }

    public final double getMaxWaitingTime() {
        return this.maxWaitingTime;
    }

    public final double getMaxServiceTime() {
        return this.maxServiceTime;
    }

    public final double getMaxSojournTime() {
        return this.maxSojournTime;
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    private boolean containsJobInAutoRevocationSchedule(DJ job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        for (Set<DJ> jSet : this.autoRevocationSchedule.values()) {
            if (!jSet.contains(job)) continue;
            return true;
        }
        return false;
    }

    private void addNewJobToAutoRevocationSchedule(DJ job, double time) {
        if (job == null || time < this.getLastUpdateTime()) {
            throw new IllegalArgumentException();
        }
        if (this.containsJobInAutoRevocationSchedule(job)) {
            throw new IllegalArgumentException();
        }
        if (!this.autoRevocationSchedule.containsKey(time)) {
            this.autoRevocationSchedule.put(time, new LinkedHashSet());
        }
        ((Set)this.autoRevocationSchedule.get(time)).add(job);
    }

    private void removeJobFromAutoRevocationSchedule(DJ job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.containsJobInAutoRevocationSchedule(job)) {
            throw new IllegalArgumentException();
        }
        HashSet<Double> keysToRemove = new HashSet<Double>();
        for (Map.Entry<Double, Set<DJ>> entry : this.autoRevocationSchedule.entrySet()) {
            if (!entry.getValue().contains(job)) continue;
            entry.getValue().remove(job);
            if (!entry.getValue().isEmpty()) continue;
            keysToRemove.add(entry.getKey());
        }
        Iterator<Map.Entry<Double, Set<Object>>> iterator = keysToRemove.iterator();
        while (iterator.hasNext()) {
            double d = (Double)((Object)iterator.next());
            this.autoRevocationSchedule.remove(d);
        }
    }

    private void rescheduleExpirationEvent() {
        if (this.processingOwnAutoRevocationEvent) {
            return;
        }
        if (this.scheduledRevocationEvent != null) {
            if (!this.eventsScheduled.contains(this.scheduledRevocationEvent)) {
                throw new IllegalStateException();
            }
            if (this.autoRevocationSchedule.isEmpty() || this.autoRevocationSchedule.firstKey().doubleValue() != this.scheduledRevocationEvent.getTime()) {
                this.getEventList().remove((Object)this.scheduledRevocationEvent);
                this.eventsScheduled.remove(this.scheduledRevocationEvent);
                this.scheduledRevocationEvent = null;
            } else {
                return;
            }
        }
        if (!this.autoRevocationSchedule.isEmpty()) {
            this.scheduledRevocationEvent = new DefaultSimEvent(this.autoRevocationSchedule.firstKey().doubleValue(), this::uponScheduledRevocationEvent);
            this.eventsScheduled.add(this.scheduledRevocationEvent);
            this.getEventList().schedule(this.scheduledRevocationEvent);
        }
    }

    private void expireJob(double time, J job) {
        switch (this.exprirationMethod) {
            case DROP: {
                this.drop(job, time);
                break;
            }
            case AUTO_REVOCATION: {
                this.autoRevoke(time, job);
                break;
            }
            case DEPARTURE: {
                this.depart(time, job);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void uponScheduledRevocationEvent(SimEvent event) {
        if (event == null) {
            throw new IllegalStateException();
        }
        if (event != this.scheduledRevocationEvent) {
            throw new IllegalStateException();
        }
        if (this.autoRevocationSchedule.isEmpty()) {
            throw new IllegalStateException("Illegal (empty) auto-revocation schedule; time=" + event.getTime() + ".");
        }
        if (this.autoRevocationSchedule.firstKey().doubleValue() != event.getTime()) {
            throw new IllegalStateException();
        }
        if (this.processingOwnAutoRevocationEvent) {
            throw new IllegalStateException();
        }
        this.processingOwnAutoRevocationEvent = true;
        this.update(event.getTime());
        double time = event.getTime();
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        if (!isTopLevel) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet jobsToRevoke = new LinkedHashSet((Collection)this.autoRevocationSchedule.get(this.autoRevocationSchedule.firstKey()));
        for (SimJob job : jobsToRevoke) {
            if (!this.isDelegateJob(job)) {
                throw new IllegalStateException();
            }
            if (this.getEncapsulatedQueue().getJobs().contains(job)) continue;
            throw new IllegalStateException();
        }
        for (SimJob job : jobsToRevoke) {
            if (!this.isDelegateJob(job)) continue;
            Object realJob = this.getRealJob(job);
            this.expireJob(time, realJob);
        }
        this.eventsScheduled.remove(this.scheduledRevocationEvent);
        this.scheduledRevocationEvent = null;
        this.processingOwnAutoRevocationEvent = false;
        this.rescheduleExpirationEvent();
        if (isTopLevel) {
            this.fireAndLockPendingNotifications();
        }
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.autoRevocationSchedule.clear();
        this.scheduledRevocationEvent = null;
        this.processingOwnAutoRevocationEvent = false;
    }

    @Override
    protected final void queueAccessVacationDropSubClass(double time, J job) {
        super.queueAccessVacationDropSubClass(time, job);
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
        super.insertJobInQueueUponArrival(job, time);
        Object delegateJob = this.getDelegateJobMild(job);
        if (this.arrivalTimes.containsKey(delegateJob)) {
            throw new IllegalStateException();
        }
        this.arrivalTimes.put(delegateJob, time);
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (this.getMaxSojournTime() > 0.0 && (this.getMaxWaitingTime() > 0.0 || this.getEncapsulatedQueue().getNumberOfJobsInWaitingArea() == 0 && this.getEncapsulatedQueue().getServerAccessCredits() > 0 && this.getEncapsulatedQueue().isStartArmed())) {
            Object delegateJob = this.getDelegateJob(job);
            if (Double.isInfinite(this.getMaxWaitingTime()) && Double.isInfinite(this.getMaxSojournTime())) {
                super.rescheduleAfterArrival(job, time);
            } else if (Double.isInfinite(this.getLastUpdateTime())) {
                this.expireJob(time, job);
            } else {
                double sojExpTime;
                double waiExpTime = time + this.getMaxWaitingTime();
                double expTime = Math.min(waiExpTime, sojExpTime = time + this.getMaxSojournTime());
                if (Double.isInfinite(expTime)) {
                    throw new IllegalStateException();
                }
                this.addNewJobToAutoRevocationSchedule(delegateJob, expTime);
                this.rescheduleExpirationEvent();
                super.rescheduleAfterArrival(job, time);
            }
        } else {
            this.expireJob(time, job);
        }
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        this.removeJobUponExitLocal(job, time);
        super.removeJobFromQueueUponDrop(job, time);
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        super.rescheduleAfterDrop(job, time);
        this.rescheduleUponExitLocal(job, time);
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        this.removeJobUponExitLocal(job, time);
        super.removeJobFromQueueUponRevokation(job, time, auto);
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        super.rescheduleAfterRevokation(job, time, auto);
        this.rescheduleUponExitLocal(job, time);
    }

    @Override
    public final boolean isStartArmed() {
        return super.isStartArmed();
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        super.setServerAccessCreditsSubClass();
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        super.rescheduleForNewServerAccessCredits(time);
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        super.insertJobInQueueUponStart(job, time);
        Object delegateJob = this.getDelegateJob(job);
        if (!this.arrivalTimes.containsKey(delegateJob)) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        super.rescheduleAfterStart(job, time);
        Object delegateJob = this.getDelegateJob(job);
        if (this.containsJobInAutoRevocationSchedule(delegateJob)) {
            this.removeJobFromAutoRevocationSchedule(delegateJob);
        }
        if (Double.isFinite(this.getMaxServiceTime()) || Double.isFinite(this.getMaxSojournTime())) {
            double sojExpTime;
            double serExpTime;
            double expTime;
            if (Double.isInfinite(this.getLastUpdateTime())) {
                this.expireJob(time, this.getRealJob(delegateJob));
            }
            if (Double.isInfinite(expTime = Math.min(serExpTime = time + this.getMaxServiceTime(), sojExpTime = this.arrivalTimes.get(delegateJob) + this.getMaxSojournTime()))) {
                throw new IllegalStateException();
            }
            this.addNewJobToAutoRevocationSchedule(delegateJob, expTime);
        }
        this.rescheduleExpirationEvent();
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
        this.removeJobUponExitLocal(departingJob, time);
        super.removeJobFromQueueUponDeparture(departingJob, time);
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
        super.rescheduleAfterDeparture(departedJob, time);
        this.rescheduleUponExitLocal(departedJob, time);
    }

    private void removeJobUponExitLocal(J job, double time) {
        if (this.isJob((SimJob)job)) {
            Object delegateJob = this.getDelegateJob(job);
            if (this.arrivalTimes.containsKey(delegateJob)) {
                this.arrivalTimes.remove(delegateJob);
            }
            if (this.containsJobInAutoRevocationSchedule(delegateJob)) {
                this.removeJobFromAutoRevocationSchedule(delegateJob);
            }
        }
    }

    private void rescheduleUponExitLocal(J job, double time) {
        this.rescheduleExpirationEvent();
    }

    @Override
    protected final void processSubQueueNotifications(List<MultiSimQueueNotificationProcessor.Notification<DJ, DQ>> notifications) {
        super.processSubQueueNotifications(notifications);
    }

    public static enum ExpirationMethod {
        DROP,
        AUTO_REVOCATION,
        DEPARTURE;

    }
}

